/***************************************************************************
                      ksthsdialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qwidget.h>

// include files for KDE
#include <kcombobox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstaticdeleter.h>
#include <kmdimainfrm.h>

// application specific includes
#include "ksthsdialog_i.h"
#include "curveappearancewidget.h"
#include "curveplacementwidget.h"
#include "kst.h"
#include "kst2dplot.h"
#include "kstdatacollection.h"
#include "kstdoc.h"
#include "kstvectordialog_i.h"
#include "kstviewwindow.h"
#include "vectorselector.h"

#define DIALOGTYPE KstHsDialogI
#define DTYPE "Histogram"
#include "dataobjectdialog.h"


KstHsDialogI *KstHsDialogI::_inst = 0L;
static KStaticDeleter<KstHsDialogI> _hsInst;


KstHsDialogI *KstHsDialogI::globalInstance() {
  if (!_inst) {
    _inst = _hsInst.setObject(new KstHsDialogI);
  }
  return _inst;
}


KstHsDialogI::KstHsDialogI(QWidget* parent,
                           const char* name, bool modal, WFlags fl)
: KstHsDialog(parent, name, modal, fl) {
  Init();

  connect(AutoBin, SIGNAL(clicked()), this, SLOT(autoBin()));
  connect(_vector, SIGNAL(newVectorCreated(const QString&)), this, SIGNAL(modified()));
  _curveAppearance->setUsePoints(false);
  _curveAppearance->setMustUseLines(true);
}

KstHsDialogI::~KstHsDialogI() {
  DP = 0L;
}

KstHistogramPtr KstHsDialogI::_getPtr(const QString &tagin) {
  KstHistogramList c =
    kstObjectSubList<KstDataObject, KstHistogram>(KST::dataObjectList);

  if ( c.findTag(tagin) == c.end() ) {
    return 0L;
  } else {
    return *c.findTag(tagin);
  }
}

void KstHsDialogI::updateWindow() {
  _curvePlacement->update();
}

void KstHsDialogI::_fillFieldsForEdit() {
  if ( DP == 0L ) return; // shouldn't be needed
  _tagName->setText( DP->tagName() );

  /* select the proper Vector */
  _vector->setSelection(DP->getVTag());

  N->setValue(DP->getBins());
  Min->setText(QString::number(DP->minX()));
  Max->setText(QString::number(DP->maxX()));

  if (DP->isNormPercent()) {
    NormIsPercent->setChecked(true);
  } else if (DP->isNormFraction()) {
    NormIsFraction->setChecked(true);
  } else if (DP->isNormOne()) {
    PeakIs1->setChecked(true);
  } else {
    NormIsNumber->setChecked(true);
  }

  _curveAppearance->setColor(DP->getColor());

  _curvePlacement->hide();

  adjustSize();
  resize(minimumSizeHint());
}

void KstHsDialogI::_fillFieldsForNew() {
  KstHistogramList histograms =
    kstObjectSubList<KstDataObject, KstHistogram>(KST::dataObjectList);

  /* set tag name */
  QString new_label;
  new_label.sprintf("H%d-", signed(histograms.count())+1);
  new_label += i18n("<New_Histogram>");
  _tagName->setText(new_label);

  /* set the curve placement window  */
  _curvePlacement->update();

  //for some reason the lower widget needs to be shown first to prevent overlapping?
  _curveAppearance->hide();
  _curvePlacement->show();
  _curveAppearance->show();
  _curveAppearance->reset();

  adjustSize();
  resize(minimumSizeHint());
}

void KstHsDialogI::update() {
  _vector->update();
}

bool KstHsDialogI::new_I() {
  KstHistogramPtr hs;
  double new_max, new_min, m;
  bool bRetVal = false;
  int new_n_bins;
  KstHsNormType new_norm_mode;

  QString tag_name = _tagName->text();
  tag_name.replace(i18n("<New_Histogram>"), _vector->selectedVector());

  /* verify that the curve name is unique */
  if (KST::dataTagNameNotUnique(tag_name)) {
    _tagName->setFocus();
    return false;
  }

  if (_vector->selectedVector().isEmpty()) {
    KMessageBox::sorry(0L, i18n("New Histogram not made: define "
                                "vectors first."));
    return false;
  }

  /* find max and min */
  new_min = Min->text().toDouble();
  new_max = Max->text().toDouble();
  if (new_max < new_min) {
    m = new_max;
    new_max = new_min;
    new_min = m;
  }

  if (new_max == new_min) {
    KMessageBox::sorry(0L, i18n("Max and Min can not be equal."));
    return false;
  }

  new_n_bins = N->text().toInt();
  if (new_n_bins < 1) {
    KMessageBox::sorry(0L, i18n("You must have one or more bins in "
                                "a histogram."));
    return false;
  }

  if (NormIsPercent->isChecked()) {
    new_norm_mode = KST_HS_PERCENT;
  } else if (NormIsFraction->isChecked()) {
    new_norm_mode = KST_HS_FRACTION;
  } else if (PeakIs1->isChecked()) {
    new_norm_mode = KST_HS_MAX_ONE;
  } else {
    new_norm_mode = KST_HS_NUMBER;
  }

  { // make sure this iterator falls out of scope
    KstReadLocker ml(&KST::vectorList.lock());
    KstVectorList::Iterator i = KST::vectorList.findTag(_vector->selectedVector());
    if (i == KST::vectorList.end()) {
      kdFatal() << "Bug in kst: the Vector field in plotDialog (Hs) refers to "
                << " a non existant vector..." << endl;
    }

    hs = new KstHistogram(tag_name, *i, new_min, new_max,
                          new_n_bins, new_norm_mode,
                          _curveAppearance->color());
    if (hs) {
      hs->setHasPoints(_curveAppearance->showPoints());
      hs->setHasLines(_curveAppearance->showLines());
      hs->setLineWidth(_curveAppearance->lineWidth());
      hs->setLineStyle(_curveAppearance->lineStyle());
      hs->Point.setType(_curveAppearance->pointType());
    }
  }

  if (hs) {
    Kst2DPlotPtr plot;
    KstViewWindow *w = dynamic_cast<KstViewWindow*>(KstApp::inst()->findWindow(_curvePlacement->_plotWindow->currentText()));
    if (!w) {
      QString newName = KST::suggestWinName();
      QString n = KstApp::inst()->newWindow(newName);
      w = static_cast<KstViewWindow*>(KstApp::inst()->findWindow(n));
    }
    if (w) {
      if (_curvePlacement->existingPlot()) {
        /* assign curve to plot */
        plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(_curvePlacement->plotName()).data());
        if (plot) {
          plot->addCurve(hs.data());
          w->view()->paint(P_DATA);
        }
      }

      if (_curvePlacement->newPlot()) {
        /* assign curve to plot */
        QString name = w->createPlot<Kst2DPlot>(KST::suggestPlotName());
        if (_curvePlacement->reGrid()) {
          w->view()->cleanup(_curvePlacement->columns());
        }
        plot = dynamic_cast<Kst2DPlot*>(w->view()->findChild(name).data());
        if (plot) {
          _curvePlacement->update();
          _curvePlacement->setCurrentPlot(plot->tagName());
          plot->addCurve(hs.data());
          plot->GenerateDefaultLabels();
          w->view()->paint(P_DATA);
        }
      }
    }

    KST::dataObjectList.lock().writeLock();
    KST::dataObjectList.append(hs.data());
    KST::dataObjectList.lock().writeUnlock();

    hs = 0L;
    emit modified();
    bRetVal = true;
  } else {
    bRetVal = false;
  }

  return bRetVal;
}


bool KstHsDialogI::edit_I() {
  double new_max, new_min, m;
  int new_n_bins;

  /* verify that the curve name is unique */
  QString tag_name = _tagName->text();
  if (tag_name != DP->tagName()) {
    if (KST::dataTagNameNotUnique(tag_name)) {
      _tagName->setFocus();
      return false;
    }
  }

  /* find max and min */
  new_min = Min->text().toDouble();
  new_max = Max->text().toDouble();
  if (new_max<new_min) {
    m = new_max;
    new_max = new_min;
    new_min = m;
  }

  if (new_max == new_min) {
    KMessageBox::sorry(0L, i18n("Max and Min can not be equal."));
    Min->setFocus();
    return false;
  }

  new_n_bins = N->text().toInt();
  if (new_n_bins < 1) {
    KMessageBox::sorry(0L, i18n("You must have one or more bins "
                                "in a histogram."));
    N->setFocus();
    return false;
  }

  DP->setTagName(tag_name);
  KST::vectorList.lock().readLock();
  DP->setVector(*KST::vectorList.findTag(_vector->selectedVector()));
  KST::vectorList.lock().readUnlock();
  DP->setColor(_curveAppearance->color());

  DP->setNBins(new_n_bins);
  DP->setXRange(new_min, new_max);

  if (NormIsPercent->isChecked()) DP->setIsNormPercent();
  else if (NormIsFraction->isChecked()) DP->setIsNormFraction();
  else if (PeakIs1->isChecked()) DP->setIsNormOne();
  else DP->setIsNormNum();

  DP->update(-1);
  emit modified();

  return true;
}

void KstHsDialogI::autoBin() {
  KstReadLocker ml(&KST::vectorList.lock());
  double max, min;
  int n;

  if (KST::vectorList.count() > 0) {
    /* find *V */
    KstVectorList::Iterator i = KST::vectorList.findTag(_vector->selectedVector());
    if (i == KST::vectorList.end()) {
      kdFatal() << "Bug in kst: the Vector field in hsdialog refers to "
                   "a non existant vector....(Boh\?\?)" << endl;
    }

    KstHistogram::AutoBin(KstVectorPtr(*i), &n, &max, &min);

    N->setValue(n);
    Min->setText(QString::number(min));
    Max->setText(QString::number(max));
  }
}

#include "ksthsdialog_i.moc"
// vim: ts=2 sw=2 et
