/***************************************************************************
                          kst.h  -  description
                             -------------------
    begin                : Tue Aug 22 13:46:13 CST 2000
    copyright            : (C) 2000 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KST_H
#define KST_H


#include <config.h>

// include files for Qt
#include <qstrlist.h>

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kmdimainfrm.h>

// application specific includes
#include "kstplotbase.h"
#include "kst2dplot.h"
#include "kstdataobject.h"
#include "ksteventmonitorentry.h"
#include "ksttoplevelview.h"

// forward declaration of the Kst classes
class FilterListEditor;
class KstChangeFileDialogI;
class KstChangeNptsDialogI;
class KstDataManagerI;
class KstDebugDialogI;
class KstDoc;
class KstEventMonitorI;
class KstGraphFileDialogI;
class KstIfaceImpl;
class KstLabelDialogI;
class KstPlotDialogI;
class KstTopLevelView;
class KstViewScalarsDialogI;
class KstViewVectorsDialogI;
class KstViewFitsDialogI;
class UpdateThread;
class VectorSaveDialog;

class QLabel;

/** The base class for Kst application windows. It sets up the main
  * window frame, reads the config file.
  * KstApp reimplements the methods that KMdiMainFrm provides.
  * @see KMdiMainFrm @see KApplication @see KConfig
  *
  * @author original Source Framework automatically generated by
  * KDevelop, (c) The KDevelop Team.  Modified by C. Barth Netterfield
  */
class KstApp : public KMdiMainFrm {
  Q_OBJECT
  public:
    KstApp(QWidget* parent=0, const char* name=0);
    virtual ~KstApp();

    static KstApp* inst();

    void checkFontPresent( const QString& strFont );

    /** add a file to the recent file list */
    void addRecentFile(const KURL &file);

    /** opens a file specified by commandline option */
    bool openDocumentFile(const QString& _cmdl = QString::null,
        const QString& o_file = "|", int o_n = -2, int o_f = -2,
        int o_s = -1, bool o_ave = false);

    /** returns a pointer to the current document connected to the
     * KMainWindow instance and is used by the View class to access
     * the document object's methods */
    KstDoc *document() const;

    /** returns a pointer to the plot dialog */
    KstPlotDialogI *plotDialog() const;

    /** pause the updating of data */
    void setPaused(bool paused);
    void togglePaused();
    bool paused() const { return PauseAction->isChecked(); }

    enum KstZoomType { XYZOOM, YZOOM, XZOOM, TEXT, LAYOUT };
    /** Get XY zoom radio button state */
    KstZoomType getZoomRadio();

    /** Get tie zoom button state */
    bool getTieZoom();

    /** Update everything */
    void forcedUpdate();

    KstTopLevelViewPtr activeView();
    Kst2DPlotMap& plotHolderWhileOpeningDocument();

    QString newWindow(const QString& name);
    QString newWindow(bool prompt = true);

    bool dataMode() const;

    void paintAll();

    void EventELOGSubmitEntry(const QString& strMessage);
    
  protected:
    virtual void customEvent(QCustomEvent *e);

    /** save options to the configuration file
     *  Geometry, Toolbar status, Statusbar status */
    void saveOptions();

    /** read options from configuration file
     *  Geometry, Toolbar status, Statusbar status */
    void readOptions();

    /** setup kde2 actions and build the GUI */
    void initActions();

    /** sets up the statusbar for the main window */
    void initStatusBar();

    /** initializes the document object */
    void initDocument();

    /** queryClose is called by KMainWindow on each closeEvent of a
     * window. This calles saveModified() on the document object to ask
     * if the document should be saved if Modified; on cancel the
     * closeEvent is rejected.
     * @see saveModified()
     * @see KMainWindow#queryClose
     * @see KMainWindow#closeEvent */
    virtual bool queryClose();

    /** Calls queryClose */
    virtual bool queryExit();

    /** saves the window properties for each open window during session
     * end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KMainWindow#saveProperties */
    virtual void saveProperties(KConfig *_cfg);

    /** reads the session config file and restores the application's
     * state including the last opened files and documents by reading
     * the temporary files saved by saveProperties()
     * @see KMainWindow#readProperties */
    virtual void readProperties(KConfig *_cfg);

  private slots:
    // Hack to update KStdActions
    void updateActions();

    // for the kaction
    void toggleDataMode();
    void toggleMouseMode();

    void slotSettingsChanged();

  public slots:

    void fromEnd();

    void updatePausedState(bool);

    void tieAll();

    void forceUpdate();

    void slotConfigureKeys();

    /** open a new application window by creating a new instance of KstApp */
    void slotFileNewWindow();

    /** clears the document in the view and creates a new document */
    void slotFileNew();

    /** open a file and load it into the document*/
    void slotFileOpen();

    /** opens a file from the recent files menu */
    void slotFileOpenRecent(const KURL &);

    /** save a document */
    void slotFileSave();

    /** save a document by a new filename*/
    void slotFileSaveAs();

    /** asks for saving if the file is modified, then closes the actual
      file and window*/
    void slotFileClose();

    /** closes all windows and exits program: not used */
    void slotFileQuit();

    /** print the actual file */
    void slotFilePrint();
    void slotFilePrintActiveWindow();

    /** print without querying */
    void immediatePrintToFile(const QString &filename);
    void immediatePrintWindowToFile(KMdiChildView* pWindow, const QString& filename);
    void immediatePrintActiveWindowToFile(const QString& filename);

    /** export to png without querying */
    void immediatePrintToPng(const QString &filename, const QString& format = "PNG", int iWidth=640, int iHeight=480, bool bAll=false);
    void immediatePrintWindowToPng(KMdiChildView* pWindow, const QString& filename, const QString& format = "PNG", int iWidth=640, int iHeight=480);
    void immediatePrintActiveWindowToPng(const QString& filename, const QString& format = "PNG", int iWidth=640, int iHeight=480);

    /** toggles the toolbar */
    void slotViewToolBar();

    //void slotCut() {}
    void slotCopy();
    //void slotPaste() {}

    /** toggles the statusbar */
    void slotViewStatusBar();

    /** changes the statusbar contents */
    void slotUpdateStatusMsg(const QString &msg);
    void slotUpdateDataMsg(const QString &msg);

    /** just calls plotDialog->show_I(0) */
    void showPlotDialog();
    void showPlotDialog(const QString& strWindow, const QString& strPlot);

    /** just calls dataManager->show_I(0) */
    void showDataManager();

    /** just calls changeFileDialog->showChangeFileDialog(0) */
    void showChangeFileDialog();

    /** just calls viewScalarsDialog->showViewScalarsDialog(0) */
    void showViewScalarsDialog();

    /** just calls viewVectorsDialog->showViewVectorsDialog(0) */
    void showViewVectorsDialog();

    /** just calls viewFitsDialog->showViewFitsDialog(0) */
    void showViewFitsDialog();

    /** just calls changeNptsDialog->showChangeNptsDialog(0) */
    void showChangeNptsDialog();

    /** just calls graphFileDialog->showGraphFileDialog(0) */
    void showGraphFileDialog();

    /** just calls filterListEditor->show() */
    void showFilterListEditor();

    /** just calls debugDialog->show() */
    void showDebugDialog();

    /** creates the plugin manager */
    void showPluginManager();

    /** creates the plugin manager */
    void showExtensionManager();

    /** creates the data wizard */
    void showDataWizard();

    /** calls doc->samplesDown */
    void samplesDown();

    /** calls doc->samplesUp */
    void samplesUp();

    /** calls update on all the dialogs */
    void updateDialogs();
    void updateDataDialogs(bool dataManager = true);
    void updateDialogsForWindow();
    
    /*** shows doc as modified, updates doc and dialogs */
    void registerDocChange();

    void reload();

    void slotPreferences();

    KstLabelDialogI *labelDialog() const;
    
    void EventELOGConfigure();

  signals:
    void settingsChanged();
    void ELOGConfigure();
    void ELOGSubmitEntry(const QString& strMessage);
    
  private:
    /** the configuration object of the application */
    KConfig *config;

    /** The document */
    KstDoc *doc;

    FilterListEditor *filterListEditor;

    /* Dialog for viewing the scalar values */
    KstViewScalarsDialogI *viewScalarsDialog;

    /* Dialog for viewing the vector values */
    KstViewVectorsDialogI *viewVectorsDialog;

    /* Dialog for viewing the fit values */
    KstViewFitsDialogI *viewFitsDialog;

    /* Dialog for changing the data files from Vectors */
    KstChangeFileDialogI *changeFileDialog;

    /* Dialog for changing the Sample ranges for Vectors */
    KstChangeNptsDialogI *changeNptsDialog;

    /* Dialog for exporting to a graphics file */
    KstGraphFileDialogI *graphFileDialog;

    /* Dialog for exporting to a text file */
    VectorSaveDialog *vectorSaveDialog;

    /* Dialog for looking at data */
    KstDataManagerI *dataManager;

    /* Dialog for looking at debug information */
    KstDebugDialogI *debugDialog;

    /* Dialog for editing the document properties */
    KstPlotDialogI *_plotDialog;

    KstLabelDialogI *_labelDialog;

    /* contains the recently used filenames */
    KRecentFilesAction *recent;

    KToggleAction *StatusBarAction;
    KToggleAction *ToolBarAction;

    /** The Pause Button */
    KToggleAction *PauseAction;

    /** The Reduce samples Button */
    KAction *SamplesDownAction;
    /** The Increase samples Button */
    KAction *SamplesUpAction;
    /** The 'read data from end of file' Button */
    KAction *SamplesFromEndAction;

    /** TiedZoom Button */
    KAction *_tiedZoomAction;

    KAction *_reloadAction;

    /** Radio Collection: XY, X, Y zoom, Text, Layout */
    KRadioAction *XYZoomAction;
    KRadioAction *XZoomAction;
    KRadioAction *YZoomAction;
    KRadioAction *TextAction;
    KRadioAction *LayoutAction;

    /* Filter Edit Action */
    KAction *FilterDialogAction;
    /* Plot Edit Action */
    KAction *PlotDialogAction;
    /* Vector Edit Action */
    KAction *VectorDialogAction;
    /* Curve Edit Action */
    KAction *CurveDialogAction;
    /* Equation Edit Action */
    KAction *EqDialogAction;
    /* Histogram Edit Action */
    KAction *HsDialogAction;
    /* Power Spectrum Edit Action */
    KAction *PsdDialogAction;
    /* Data Manager Action */
    KAction *DataManagerAction;
    /* Plugin Plot Edit Action */
    KAction *PluginDialogAction;
    /* Vector Save Action */
    KAction *_vectorSaveAction;

    /* View Scalars Action */
    KAction *ViewScalarsDialogAction;
    /* View Vectors Action */
    KAction *ViewVectorsDialogAction;
    /* View Fits Action */
    KAction *ViewFitsDialogAction;

    /* Data mode */
    KToggleAction *DataMode;

    /** Change File Action: brings up the change file dialog box */
    KAction *ChangeFileDialogAction;
    /** Change npts Action: brings up the change data range dialog box */
    KAction *ChangeNptsDialogAction;
    /** GraphFileDialogAction: Brings up the graphics file export window */
    KAction *GraphFileDialogAction;
    /** PluginManagerAction: Brings up the plugin manager window */
    KAction *PluginManagerAction;
    /** ExtensionManagerAction: Brings up the extension manager window */
    KAction *ExtensionManagerAction;
    /** EventMonitorAction: Brings up the event monitor window */
    KAction *EventMonitorAction;

    KAction *DataWizardAction;

    KAction *DebugDialogAction;

    KAction *fileNewWindow;
    KRecentFilesAction *fileOpenRecent;
    KAction *filePrint;
    KAction *fileOpenNew;
    KAction *fileOpen;
    KAction *fileSave;
    KAction *fileSaveAs;
    KAction *fileClose;
    KAction *fileQuit;
    KAction *fileKeyBindings;
    KAction *filePreferences;
    KAction *fileCopy;

    KToggleAction *viewToolBar;
    KToggleAction *viewStatusBar;

    QLabel *_dataBar;
    bool stopping;
    KstIfaceImpl *_dcopIface;
    UpdateThread *_updateThread;
    Kst2DPlotMap _plotHolderWhileOpeningDocument;
};

#endif // KST_H
// vim: ts=2 sw=2 et
