/***************************************************************************
                          textdlg.h  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEXTDLG_H
#define TEXTDLG_H

#include <decodlg.h>

class QLineEdit;
class QComboBox;
class TextItem;

/**
  * Text settings dialog class. Provides a dialog for the settings
  * of a text decoration item.
  * @author Werner Stille
  */
class TextDlg : public DecoDlg
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param td pointer to text item.
   */
  TextDlg(QWidget* parent, KplDoc* model, TextItem* td);
  /** Destructor. */
  ~TextDlg();

protected:
  /**
   * Copies settings to text item.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  TextItem* td;
  KplDoubleEdit* eDir;
  QLineEdit* eText;
  QComboBox* eAlign;

protected slots:
  /** Displays dialog to edit text. */
  void slotEditText();
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
