/***************************************************************************
                          rectdlg.h  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RECTDLG_H
#define RECTDLG_H

#include "decodlg.h"

class BrushButton;
class QCheckBox;
class RectItem;

/**
  * Rectangle settings dialog class. Provides a dialog for the settings
  * of a rectangle decoration item.
  * @author Werner Stille
  */
class RectDlg : public DecoDlg
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param rd pointer to rectangle item.
   */
  RectDlg(QWidget* parent, KplDoc* model, RectItem* rd);
  /** Destructor. */
  ~RectDlg();

protected:
  /**
   * Copies settings to rectangle item.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  RectItem* rd;
  QCheckBox* isotropic;
  BrushButton* fill;
  KplDoubleEdit *eWidth, *eHeight, *eDir;

protected slots:
  /**
   * Sets height widget.
   * @param iso true to set widget for isotropic scaling.
   */
  void slotAspect(bool iso);
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
