/***************************************************************************
                          kplwidget.h  -  description
                             -------------------
    begin                : Mon Jul 16 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLWIDGET_H
#define KPLWIDGET_H

#include <qpixmap.h>
#include <qscrollview.h>
#include "kgraph.h"

template<class> class QPtrList;
class KPrinter;
class KplItem;

/**
  * Kpl widget class. Basic plot widget with scrollbars.
  * @author Werner Stille
  */
class KplWidget : public QScrollView, public KGraph
{
   Q_OBJECT
public:
  /**
    * Constructor.
    * @param parent parent widget.
    */
  KplWidget(QWidget* parent = 0);
  /**
    * Constructor.
    * @param parent parent widget.
    * @param items list of plot items.
    * @param w width.
    * @param h height.
    * @param zoom magnification factor.
    * @param xf page width in cm.
    * @param yf page height in cm.
    */
  KplWidget(QWidget* parent, QPtrList<KplItem>* items, int w = 640, int h = 480,
            double zoom = 1.0, double xf = 21.9, double yf = 29.7);
  /** Destructor. */
  ~KplWidget();
  /**
    * Draws plot items on screen.
    * @param items list of plot items.
    * @param w width.
    * @param h height.
    * @param zoom magnification factor.
    * @param xf page width in cm.
    * @param yf page height in cm.
    * @param paint true for painting.
    */
  void paintWidget(QPtrList<KplItem>* items, int w = 640, int h = 480,
                   double zoom = 1.0, double xf = 21.9, double yf = 29.7,
                   bool paint = true);
  /**
    * Draws plot items.
    * @param g graphics instance.
    * @param items list of plot items.
    */
  static void drawItems(KplGraph* g, QPtrList<KplItem>* items);
  /**
    * Contains the implementation for printing functionality.
    * @param printer printer device.
    * @param items list of plot items.
    */
  static void print(KPrinter* printer, QPtrList<KplItem>* items);
  /**
    * Reimplemented to avoid scrollbars if not necessary.
    */
  QSize sizeHint() const;

protected:
  /**
   * Reimplemented to paint using pixmap.
   */
  virtual void drawContents(QPainter* p, int clipx, int clipy, int clipw,
                            int cliph);
  QPixmap pm;
};

#endif
