/***************************************************************************
 *
 * knetworkmanager-openvpn.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_OPENVPN_H
#define KNETWORKMANAGER_OPENVPN_H

#include <qmap.h>
#include <qstring.h>
#include <qwidget.h>
#include <qlayout.h>
#include <kprocess.h>

#include "knetworkmanager-vpnplugin.h"
#include "openvpnprop.h"
#include "openvpnauth.h"

class OpenVPNPlugin : public VPNPlugin
{
	Q_OBJECT
	public:
		OpenVPNPlugin(QObject*, const char*, const QStringList&);
		~OpenVPNPlugin();

		VPNConfigWidget* CreateConfigWidget(QWidget* parent=0);
		VPNAuthenticationWidget* CreateAuthenticationWidget(QWidget* parent=0);
};

class OpenVPNConnectionType
{
	public:
		enum CONNECTIONTYPE
		{
		  UNKNOWN = -1
		, X509 = 0
		, SHARED_KEY
		, PASSWORD
		, X509USERPASS
		};

		static CONNECTIONTYPE mapString2ConnectionType(QString string);
		static QString mapConnectionType2String(CONNECTIONTYPE connectionType);
};

class OpenVPNConfig : public VPNConfigWidget
{
	Q_OBJECT
	public:
		void setVPNData(const QStringList& routes, const QStringList& properties);
		QStringList getVPNProperties();
		QStringList getVPNRoutes();
		bool hasChanged();
		bool isValid(QStringList& );

		OpenVPNConfig(QWidget* parent);
		~OpenVPNConfig();

	public slots:
		void receiveCipherData(KProcess*, char*, int);

	private:
		OpenVPNConfigWidget*   _openvpnWidget;

		void getCipherModes();
		QString findOpenVPNBinary();

	protected slots:
		void languageChange();
};

class OpenVPNAuthentication : public VPNAuthenticationWidget
{
	Q_OBJECT
	public:
		OpenVPNAuthentication(QWidget* parent = NULL, char* name = NULL);
		~OpenVPNAuthentication();
		void setVPNData(const QStringList&, const QStringList&);
		QStringList getPasswords();	
		bool needsUserInteraction();

	private:
		OpenVPNAuthenticationWidget* _openvpnAuth;
		OpenVPNConnectionType::CONNECTIONTYPE _connectionType;
};

#endif /* KNETWORKMANAGER_OPENVPN_H */
