
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knetload.h"
#include "../version.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kuniqueapplication.h>

static const char *description =
    I18N_NOOP("A small network load meter for Kicker (the KDE panel).");
static const char *message =
    I18N_NOOP("KNetLoad was first released on the 8th of August, 1999.");
static const char *version = VERSION;

int main(int argc, char **argv) {
    KAboutData aboutData("knetload", I18N_NOOP("KNetLoad"), version,
        description, KAboutData::License_GPL,
        "(c) 1999-2000, Markus Gustavsson\n"
        "(c) 2002, Ben Burton",
        message, 0 /* TODO: Website */, "bab@debian.org");

    aboutData.addAuthor("Markus Gustavsson", "Original author",
        "mighty@fragzone.se");
    aboutData.addAuthor("Ben Burton", "KDE3 rewrite, current maintainer",
        "bab@debian.org");

    aboutData.addCredit("Njaard, Charles Samuels",
        "Support and help with KDE", "charles@kde.org");
    aboutData.addCredit("rikkus, Rik Hemsley",
        "Support and help with KDE", "rik@kde.org");
    aboutData.addCredit("Mark Halpaap",
        "Independent port to KDE3", "mark.halpaap@gmx.net");
    aboutData.addCredit("Thanks to everyone in #KDE OpenProjects for "
        "being supportive and helpful!");

    KCmdLineArgs::init(argc, argv, &aboutData);
    KUniqueApplication::addCmdLineOptions();

    if (! KUniqueApplication::start()) {
        fprintf(stderr, I18N_NOOP("KNetLoad is already running!\n"));
        return 1;
    }

    KUniqueApplication app;
    app.setMainWidget(new KNetLoad());
    return app.exec();
}
