/***************************************************************************
                          iprange.cpp  -  description
                             -------------------
    begin                : Thu May 10 08:08:00 EST 2001
    copyright            : (C) 2000-2001 by Simon Edwards
    email                : simon@simonzone.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "iprange.h"

#include <stdlib.h>
#include <kregexp.h>

///////////////////////////////////////////////////////////////////////////
IPRange::IPRange() {
    gottype = false;
}
///////////////////////////////////////////////////////////////////////////
IPRange::IPRange(const QString &a) {
    setAddress(a);
}
        
///////////////////////////////////////////////////////////////////////////
IPRange::~IPRange() {

}

///////////////////////////////////////////////////////////////////////////
void IPRange::setAddress(const QString &a) {
    address = a;
    gottype = false;
}

///////////////////////////////////////////////////////////////////////////
QString IPRange::getAddress() const {
    return address;
}

///////////////////////////////////////////////////////////////////////////
IPRangeType IPRange::getType() {
    if(!gottype) {
        type = guessType();
        gottype = true;
    }
    return type;
}

///////////////////////////////////////////////////////////////////////////
IPRangeType IPRange::guessType() {
    KRegExp sanity("^[0-9a-zA-Z./-]*$");
    KRegExp domainnametest("^([a-zA-Z0-9-]+\\.)+[a-zA-Z0-9-]+$");
    KRegExp iptest("^([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)$");
    KRegExp ipmaskedtest("^([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)/([0-9]+)$");
    KRegExp ipmasked2test("^([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)/([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)$");
    
    long ipbyte;
        
        // Smoke text
    if(sanity.match((const char *)address)==false) {
        return invalid;
    }

    if(address.length()==0) {
        return invalid;
    }

        // Test against the domainname regexp.
    if(domainnametest.match((const char *)address)) {
        return domainname;
    }
    
        // Ok, now lets try the IP address regexp.
    if(iptest.match((const char *)address)==true) {
        ipbyte = atol(iptest.group(1));    // Yep, it returns char *.
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(2));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(3));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(4));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        return ip;
    }

        // Ok, now lets try the IP address regexp.
    if(ipmaskedtest.match((const char *)address)==true) {
        ipbyte = atol(iptest.group(1));    // Yep, it returns char *.
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(2));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(3));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(4));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(5));
        if(ipbyte<0 || ipbyte>32) {
            return invalid;
        }
        return iprange;
    }
    
    if(ipmasked2test.match((const char *)address)==true) {
        ipbyte = atol(iptest.group(1));    // Yep, it returns char *.
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(2));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(3));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(4));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(5));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(6));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(7));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        ipbyte = atol(iptest.group(8));
        if(ipbyte<0 || ipbyte>255) {
            return invalid;
        }
        return iprange;
    }
    return invalid;
}
