/***************************************************************************
                          splfitdlg.h  -  description
                             -------------------
    begin                : Fri Mar 1 2002
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPLFITDLG_H
#define SPLFITDLG_H

#include <kdialogbase.h>
#include "kplnamespace.h"

class QCheckBox;
class KplDoc;
class ArrayItem;
class SplineItem;
class KplSpinBox;
class KplDoubleEdit;

/**
  * Spline fit dialog class. Provides a dialog for performing a fit
  * of a smoothing spline to a data set of an array.
  * @author Werner Stille
  */
class SplFitDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   * @param ad pointer to array item.
   * @param fd pointer to spline item.
   * @param mode combination of ShowDlg and AutoFit.
   */
  SplFitDlg(QWidget* parent, KplDoc* model, ArrayItem* ad,
            SplineItem* fd, int mode);
  /** Destructor. */
  ~SplFitDlg();
  /**
   * Checks and copies settings and parameters.
   * @param accept true for leaving the dialog, false for applying.
   */
  void getValues(bool accept);
  /**
   * Performs smoothing spline fit.
   * @param k degree of spline.
   * @param smf smoothing factor.
   * @param xmin lower boundary of approximation interval.
   * @param xmax upper boundary of approximation interval.
   * @param errcol true for data weighing by error column, false for weighing
   * by error model function.
   * @param errModPath absolute path of the library for the error model
   * function.
   * @param errModName error model function name.
   * @return error code.
   */
  int fit(int k, double smf, double xmin, double xmax, bool errcol,
          const QString& errModPath, const QString& errModName);
  /**
   * Compares table rows for qsort.
   * @param e1 pointer to row 1.
   * @param e2 pointer to row 2.
   * @return -1 if x1 < x2, 0 if x1 = x2, 1 if x1 > x2.
   */
  static int cmpasc(const void* e1, const void* e2);

protected:
  bool running;
  int dlgMode;
  KplDoc* m;
  ArrayItem* ad;
  SplineItem *fd, *spl;
  KplSpinBox* sDeg;
  KplDoubleEdit *exMin, *exMax, *eFactor;
  QListBox* results;
  QCheckBox* errCol;
  QPushButton* errMod;
  Kpl::DataErrorStruct err;
  QArray<double> xv, yv, ev, fv, sigv;

protected slots:
  /**
   * Disables/enables error model button.
   * @param state error column state, disables button when true.
   */
  void errColToggled(bool state);
  /** Applies settings without leaving the dialog (if displayed). */
  virtual void slotApply();
  /** Accepts changes and leaves the dialog. */
  virtual void slotOk();
  /** Performs smoothing spline fit. */
  virtual void slotUser1();
  /** Displays the dialog for setting the calculation of error bars. */
  void slotErrMod();
  /** Saves and shows residuals. */
  virtual void slotUser2();
  /** Shows root finding dialog. */
  virtual void slotUser3();
};

#endif
