/***************************************************************************
                          scalebaritem.h  -  description
                             -------------------
    begin                : Don Jun 12 2003
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCALEBARITEM_H
#define SCALEBARITEM_H

#include <kplitem.h>

/**
  * Scale bar item class. Class for scale bar decoration items.
  * @author Werner Stille
  */
class ScaleBarItem : public DecoItem
{
public: 
  /** Constructor */
  ScaleBarItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  ScaleBarItem(Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  ScaleBarItem(KSimpleConfig* plo, Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param color color for scale bar.
    * @param str text.
    * @param x x position of bar in cm.
    * @param y y position of bar in cm.
    * @param orientation 0 for horizontal, 1 for vertical.
    * @param len length in cm.
    * @param relSize relative size of scale bar.
    */
  ScaleBarItem(bool active, const QString& color, const QString& str,
               double x, double y, int orientation, double len,
               double relSize);
  /** Destructor */
  ~ScaleBarItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(KplCheckListItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
  virtual KplItem* copy() const;

protected:
  int orientation;
  double len;
  QString s;

  friend class ScaleBarDlg;
};

#endif
