/***************************************************************************
                          arrowitem.h  -  description
                             -------------------
    begin                : Sat Apr 14 2001
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ARROWITEM_H
#define ARROWITEM_H

#include <kplitem.h>

/**
  * Arrow item class. Class for arrow decoration items.
  * @author Werner Stille
  */
class ArrowItem : public DecoItem
{
public: 
  /** Constructor */
  ArrowItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  ArrowItem(Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  ArrowItem(KSimpleConfig* plo, Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param color color for arrow.
    * @param x x position of head in cm.
    * @param y y position of head in cm.
    * @param dir direction in degree.
    * @param len total length in cm.
    * @param relSize relative size of head.
    */
  ArrowItem(bool active, const QString& color, double x, double y,
            double dir, double len, double relSize);
  /** Destructor */
  ~ArrowItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(KplCheckListItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
  virtual KplItem* copy() const;

protected:
  double dir, len;

  friend class ArrowDlg;
};

#endif
