/***************************************************************************
                          kplwidget.cpp  -  description
                             -------------------
    begin                : Mon Jul 16 2001
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kplwidget.h"
#if (KDE_VERSION_MAJOR > 2) || (KDE_VERSION_MINOR > 1)
#include <kprinter.h>
#else
#include <qprinter.h>
#endif
#include "kplitem.h"

KplWidget::KplWidget(QWidget* parent) : QScrollView(parent)
{
//  QScrollView::viewport()->setBackgroundMode(PaletteBase);
}

KplWidget::KplWidget(QWidget* parent, QList<KplItem>* items, int w, int h,
                     double zoom) : QScrollView(parent)
{
  QScrollView::viewport()->setBackgroundMode(PaletteBase);
  pm.resize(w, h);
  resizeContents(w, h);
  plInit(&pm);
  factor = zoom;
  drawItems(this, items);
  end();
}

KplWidget::~KplWidget()
{
}

void KplWidget::drawItems(KplGraph* g, QList<KplItem>* items)
{
  for (KplItem* item = items->first(); item; item = items->next())
    item->draw(g);
}

#if (KDE_VERSION_MAJOR > 2) || (KDE_VERSION_MINOR > 1)
void KplWidget::print(KPrinter* printer, QList<KplItem>* items)
#else
void KplWidget::print(QPrinter* printer, QList<KplItem>* items)
#endif
{
  KGraph g;
  QSize sz = printer->margins();
  g.plInit(printer, sz.width(), sz.height());
  drawItems(&g, items);
  g.end();
}

QSize KplWidget::sizeHint() const
{
  return QScrollView::sizeHint() + QSize(1, 1);
}

void KplWidget::drawContents(QPainter*, int clipx, int clipy, int clipw,
                             int cliph)
{
  QRect r(clipx, clipy, QMIN(clipw, pm.width() - clipx),
          QMIN(cliph, pm.height() - clipy));
  if (r.isValid())
    bitBlt(QScrollView::viewport(),
           contentsToViewport(QPoint(clipx, clipy)), &pm, r, CopyROP);
}
