/***************************************************************************
                          autofitdlg.h  -  description
                             -------------------
    begin                : Sat Jun 5 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AUTOFITDLG_H
#define AUTOFITDLG_H

#include <kdialogbase.h>
#include "kplnamespace.h"

class QLineEdit;
class KplSpinBox;
class QCheckBox;
class KColorButton;
class KplDoc;
class KplDoubleEdit;

/**
  * Edit fit parameter dialog class. Provides a dialog for the editing
  * the parameters of a function.
  * @author Werner Stille
  */
class EditFitParameterDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param m pointer to KplDoc model object.
   * @param p parameter array.
   * @param bFit array indicating whether a parameter is to be fitted or fixed.
   * @param file absolute path of the function library.
   * @param func function name.
   */
  EditFitParameterDlg(QWidget* parent, KplDoc* m, double* p, bool* bFit,
                      const QString& file, const QString& func);
  /** Destructor. */
  ~EditFitParameterDlg();

protected:
  bool* bFit;
  double* p;
  QLineEdit* par[KPL_NPMAX];
  QCheckBox* enFit[KPL_NPMAX];

protected slots:
  /** Accepts changes and leaves the dialog. */
  void slotOk();
};

/**
  * Autofit settings dialog class. Provides a dialog for the
  * settings of the automatic parameter fit of a function to a data set from a file.
  * @author Werner Stille
  */
class AutoFitDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   */
  AutoFitDlg(QWidget* parent, KplDoc* model);
  /** Destructor. */
  ~AutoFitDlg();

protected:
  KplDoc* m;
  Kpl::AutoStruct* aut;
  QLineEdit *fileName, *func;
  KplDoubleEdit* eTol;
  KplSpinBox *symb, *sItmax;
  KColorButton* colData;
  QCheckBox *errCol, *showDlg, *saveRes, *follow, *nonLin;
  QPushButton* errMod;

protected slots:
  /** Displays the dialog for selection of a library file to load. */
  void slotFile();
  /** Displays the dialog for selection of a function. */
  void slotFunc();
  /** Displays the dialog for selection of a parameter file to read. */
  void slotGetParameter();
  /** Displays the dialog for parameter editing. */
  void slotEditParameter();
  /** Displays the dialog for selection of a parameter file to save. */
  void slotSaveParameter();
  /** Displays the dialog for setting the calculation of standard deviations. */
  void slotErrMod();
  /**
   * Disables/enables error model button.
   * @param off disables button when true.
   */
  void disableErrMod(bool off);
  /**
   * Disables/enables widgets for nonlinear fits.
   * @param on enables widgets when true.
   */
  void enableNonLin(bool on);
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Displays help for the autofit settings dialog. */
  void slotHelp2();
};

#endif
