/***************************************************************************
                          autodlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AUTODLG_H
#define AUTODLG_H

#include <kdialogbase.h>
#include "kplnamespace.h"

class QCheckBox;
class QButtonGroup;
class QLineEdit;
class KplDoc;
class KplDoubleEdit;
class KplSpinBox;

/**
  * Autoplot settings dialog class. Provides a dialog for the
  * settings of the automatic scaling of array plots from data files.
  * @author Werner Stille
  */
class AutoDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param model pointer to KplDoc model object.
   */
  AutoDlg(QWidget* parent, KplDoc* model);
  /** Destructor. */
  ~AutoDlg();

protected:
  KplDoc* m;
  Kpl::AutoStruct* a;
  KplDoubleEdit *autoX0, *autoY0, *autoXl, *autoYl;
  QLineEdit *autoLetX, *autoLetY, *autoLetH;
  QCheckBox *autohPath, *err, *logX, *logY, *autoNorm, *autoFit;
  QButtonGroup* bg;
  KplSpinBox *ix, *iy, *ie, *autoSymb;
  QPushButton* editH;

protected slots:
  /** Displays dialog to edit the x axis label. */
  void slotEditLetX();
  /** Displays dialog to edit the y axis label. */
  void slotEditLetY();
  /** Displays dialog to edit the heading. */
  void slotEditLetH();
  /**
   * Disables/enables heading widgets.
   * @param off disables widgets when true.
   */
  void disableHeading(bool off);
  /** Updates dialog according to logarithmic axis option. */
  void slotLogToggled(bool state);
  /** Updates dialog according to autonormalization option. */
  void slotNormToggled(bool state);
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Displays help for the autoplot settings dialog. */
  void slotHelp2();
};

#endif
