/***************************************************************************
                          arrowdlg.cpp  -  description
                             -------------------
    begin                : Sat Apr 14 2001
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapp.h>
#include "arrowdlg.h"
#include "arrowitem.h"
#include "kpldoubleedit.h"

ArrowDlg::ArrowDlg(QWidget* _parent, KplDoc* model, ArrowItem* ad0, int nrows) :
 DecoDlg(_parent, i18n("Arrow"), "SEC-ARROW", model, ad0, nrows), ad(ad0)
{
  initPolarEntries(plainPage(), ad, grid, &eDir, &eLen);
  initEntries(1);
#if KDE_VERSION == 303
  connect(this, SIGNAL(helpClicked()), SLOT(slotHelp2()));
#endif
}

ArrowDlg::~ArrowDlg()
{
}

void ArrowDlg::initPolarEntries(QWidget* _parent, ArrowItem* _ad,
                                QGridLayout* _grid, KplDoubleEdit** _eDir,
                                KplDoubleEdit** _eLen)
{
  _grid->addWidget(new QLabel(i18n("Direction"), _parent), 0, 0);
  _grid->addWidget(*_eDir = new KplDoubleEdit(_ad->dir, -360.0, 360.0,
                   _parent), 0, 1);
  _grid->addWidget(new QLabel("", _parent), 0, 2);
  _grid->addWidget(new QLabel(i18n("Length"), _parent), 0, 4);
  _grid->addWidget(*_eLen = new KplDoubleEdit(_ad->len, 0.0, 200.0, _parent),
                   0, 5);
  _grid->addWidget(new QLabel("cm", _parent), 0, 6);
}

void ArrowDlg::getValues(bool ok)
{
  ad->dir = eDir->value();
  ad->len = eLen->value();
  DecoDlg::getValues(ok);
}

void ArrowDlg::slotOk()
{
  getValues(true);
}

void ArrowDlg::slotApply()
{
  getValues(false);
}

void ArrowDlg::slotHelp2()
{
#if KDE_VERSION == 303
  kapp->startServiceByDesktopName("konqueror", QString("help:/kpl/arrow.html"),
                                  0, 0, 0, "", true);
#endif
}
