/***************************************************************************
                                   dirfile.cpp
                             -------------------
    begin                : May 26 2010
    copyright            : (C) 2010 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirfile.h"
#include "dirfilesave_i.h"

#include <qmessagebox.h>

#include <kaction.h>
#include <kapplication.h>
#include <kgenericfactory.h>
#include <kmainwindow.h>

#include <kst.h>

K_EXPORT_COMPONENT_FACTORY(kstextension_dirfile, KGenericFactory<KstDirfile>)

KstDirfile::KstDirfile(QObject *parent, const char *name, const QStringList& list) : KstExtension(parent, name, list), KXMLGUIClient() {
  new KAction(i18n("&Save Vectors to Dirfile..."), 0, 0, this, SLOT(doSave()), actionCollection(), "dirfile_save");
  setInstance(app()->instance());
  setXMLFile("kstextension_dirfile.rc", true);
  app()->guiFactory()->addClient(this);

  _dirfileSave = new DirfileSaveI( app() );
}


KstDirfile::~KstDirfile() {
  if( app() ) {
    if( app()->guiFactory() ) {
      app()->guiFactory()->removeClient(this);
    }
  }

  delete _dirfileSave;
}


void KstDirfile::doSave() {
  if( _dirfileSave ) {
    _dirfileSave->show();
    _dirfileSave->raise();
  }
}


void KstDirfile::load(QDomElement& e) {
  Q_UNUSED(e)
}


void KstDirfile::save(QTextStream& ts, const QString& indent) {
  Q_UNUSED(ts)
  Q_UNUSED(indent)
}

#include "dirfile.moc"

