#ifdef _WIN32
#pragma warning ( disable : 4786 )
#endif

#include "tabledescr.h"
#include "pairs.h"
#include <algorithm>

CKeyDescriptor::CKeyDescriptor(const CKeyDescriptor&old) 
{
    name = old.name;
    ColumnsList = old.ColumnsList;
    type = old.type;
    compound = old.is_compound();
}

CKeyDescriptor&CKeyDescriptor::operator=(const CKeyDescriptor&old)
{
    name = old.name;
    ColumnsList = old.ColumnsList;
    type = old.type;
    compound = old.is_compound();
    return *this;
}

int CKeyDescriptor::add_column_name(const std::string&column,const unsigned int size)
{
    if (column.size()==0)
        return 0;

    pairIlist::iterator iter;
    string_int_pair p(column,size);

    //iter = ColumnsList.find(p);
    iter = std::find(ColumnsList.begin(),ColumnsList.end(),p);
    if (iter != ColumnsList.end()) {
        return -1;
    }
    ColumnsList.push_back(p);
    return 1;
}

void CKeyDescriptor::remove_column_name(const std::string&column)
{
    if (column.size() == 0)
        return;
    pairIlist::iterator iter;

    string_int_pair p(column,0);

    iter = std::find(ColumnsList.begin(),ColumnsList.end(),p);

    if (iter != ColumnsList.end())
        ColumnsList.erase(iter);
}

bool CKeyDescriptor::contains_column_name(const std::string&column)
{
    if (column.size()==0)
        return false;
    string_int_pair p(column,0);
    return (std::find(ColumnsList.begin(),ColumnsList.end(),p)!=ColumnsList.end());
}

unsigned int CKeyDescriptor::column_size(const std::string&column)
{
    if (column.size() == 0)
    return 0xFFFFFFFF;
    pairIlist::iterator iter;

    string_int_pair p(column,0);

    iter = std::find(ColumnsList.begin(),ColumnsList.end(),p);
    if (iter==ColumnsList.end())
        return 0xFFFFFFFF;
    return iter->second;
}

CColumnDescriptor::CColumnDescriptor()
{
    name = "";
    Def = "";
    table = "";
    
    FieldType = 0;
    MaxLength = 0;
    MaxDecimals = 0;
    
    AutoIncrement = false;
    PrimaryField = false;
    Binary = false;
    TimeStamp = false;
    ZeroFill = false;
    NotNull = false;
    Blob = false;
    PartOfMultiple = false;
    Numeric = false;
    UniqueValue = false;
    Set = false;
}

void CColumnDescriptor::copy_old(const CColumnDescriptor*old)
{
    name = old->name;
    Def = old->Def;
    table = old->table;
    
    FieldType = old->FieldType;
    MaxLength = old->MaxLength;
    MaxDecimals = old->MaxDecimals;
    
    AutoIncrement = old->AutoIncrement;
    PrimaryField = old->PrimaryField;
    Binary = old->Binary;
    TimeStamp = old->TimeStamp;
    ZeroFill = old->ZeroFill;
    NotNull = old->NotNull;
    Blob = old->Blob;
    PartOfMultiple = old->PartOfMultiple;
    Numeric = old->Numeric;
    UniqueValue = old->UniqueValue;
    Enums = old->Enums;
    Unsigned = old->Unsigned;
    Set = old->Set;
}

CColumnDescriptor::CColumnDescriptor(const CColumnDescriptor&old)
{
    copy_old(&old);
}

CColumnDescriptor& CColumnDescriptor::operator=(const CColumnDescriptor&old)
{
    copy_old(&old);
    return *this;
}

void CColumnDescriptor::remove_enum(const std::string&what)
{
    stringIlist::iterator iter;
    iter = Enums.find(what);
    if (iter!=Enums.end()) {
        Enums.erase(iter);
    }
}
