#include "setupdlg.h"
#include "fontsetup.h"
#include "fontsetup.h"
#include "timersetup.h"
#include "../stringres.h"
#include <kapp.h>
#include <qspinbox.h>
#include "settings.h"

#define Inherited CSetupDlgData

CSetupDlg::CSetupDlg(QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    m_FixedFont = GlobalSettings.get_fixed_font();
    m_NonPropFont = GlobalSettings.get_nonprop_font();
    m_StatusTime = GlobalSettings.StatusPolltime();
    m_ThreadTime = GlobalSettings.ThreadPolltime();
    m_ThreadTimeoutEdit->setValue(m_ThreadTime);
    m_StatusTimeoutEdit->setValue(m_StatusTime);
}

CSetupDlg::~CSetupDlg()
{
}

const QFont& CSetupDlg::fixed_font()const{return m_FixedFont;}
const QFont& CSetupDlg::nonprop_font()const{return m_NonPropFont;}

int CSetupDlg::ThreadPolltime()const
{
    return m_ThreadTime;
}

int CSetupDlg::StatusPolltime()const
{
    return m_StatusTime;
}
/** No descriptions */
void CSetupDlg::accept()
{
    CSetupDlgData::accept();
}

void CSetupDlg::statusTime(int time)
{
    m_StatusTime = time;
}

void CSetupDlg::threadTime(int time)
{
    m_ThreadTime = time;
}

int CSetupDlg::exec()
{
    return CSetupDlgData::exec();
}

void CSetupDlg::fixFontChanged(const QFont&aFont)
{
    m_FixedFont = aFont;
}

void CSetupDlg::nonpropFontChanged(const QFont&aFont)
{
    m_NonPropFont = aFont;
}
