//-*-Mode: C++;-*-
/***************************************************************************
 * pairs.h  -  description                              
 * -------------------                                         
 * begin                : Sat Aug 14 1999 
 * copyright            : (C) 1999 by Rajko Albrecht
 * email                : Rajko.Albrecht@informatik.tu-chemnitz.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#ifndef _pairs_h_included
#define _pairs_h_included

#include <string>
#include <utility>
#include "kmysqladmin/helpers/stringhelper.h"

// a struct of voted pairs. Voted means - only the first entry is used for
// comparsion
template<class T1,class T2> struct voted_pair : public std::pair<T1,T2>
{
    voted_pair();
    voted_pair(const T1&a,const T2&b);
    virtual ~voted_pair();
};

template <class T1, class T2> inline voted_pair<T1,T2>::voted_pair()
    :std::pair<T1,T2>()
{
}

template <class T1, class T2> inline voted_pair<T1,T2>::voted_pair(const T1&a,const T2&b)
    :std::pair<T1,T2>(a,b)
{
}

template <class T1, class T2> inline voted_pair<T1,T2>::~voted_pair()
{
}

template <class T1, class T2> inline bool operator<(const voted_pair<T1, T2>& x, const voted_pair<T1, T2>& y)
{
    return x.first < y.first;
}

template <class T1, class T2> inline bool operator>(const voted_pair<T1, T2>& x, const voted_pair<T1, T2>& y)
{
    return y<x;
}

template <class T1, class T2> inline bool operator==(const voted_pair<T1, T2>& x, const voted_pair<T1, T2>& y) 
{
    return !(x<y||y<x);
}

typedef voted_pair<std::string,unsigned int> string_int_pair;

inline bool operator<(const string_int_pair&x,const string_int_pair&y) 
{
    return Casecmp()(x.first,y.first)==true;
}

inline bool operator>(const string_int_pair&x,const string_int_pair&y) 
{
    return y<x;
}

inline bool operator==(const string_int_pair&x,const string_int_pair&y)
{
    return !(x<y||y<x);
}

typedef std::pair<std::string,std::string> string_pair;

inline bool operator<(const string_pair&x,const string_pair&y)
{
    return Casecmp()(x.first,y.first)==true;
}

inline bool operator>(const string_pair&x,const string_pair&y)
{
    return y<x;
}

inline bool operator==(const string_pair&x,const string_pair&y) 
{
    return !(x<y||y<x);
}

#endif
