// -*- Mode: C++; -*-

#ifndef _string_helper
#define _string_helper

#include <string>
#include <functional>

std::string FormatSTLString(const char*Format,...);

//! Operator class for caseinsensitive stl-string compare
class Casecmp {
public:
    bool operator()(const std::string&,const std::string&)const;
};

//! Operator class for comparing two stl-string
/*!
 * Compares two strings in a non case-sensitive way.
 */
class Caseequ {
public:
    //! the real operator
    /*!
     * 
     */
    bool operator()(const std::string&a,const std::string&b)const;
};

inline bool Caseequ::operator()(const std::string&x, const std::string&y)const
{
    return (!Casecmp()(x,y)&&!Casecmp()(y,x));
}

class Caseequif{
    std::string arg2;
public:
    explicit Caseequif(const std::string&x):arg2(x){}
    bool operator()(const std::string&x)const{return Caseequ()(x,arg2);}
};

#endif
