#include "stringhelper.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

#include <qstring.h>

#ifndef rcsid
static const char rcsid[]="$Id: stringhelper.cpp,v 1.6 2003/11/04 12:51:47 ral Exp $";
#endif

std::string FormatSTLString(const char*Format,...)
{
    std::string msg = "";
    char*buffer;
    int chars;

    va_list ap;
    va_start(ap,Format);
    int size = 100;
    
    buffer = new char[size];
    
    while (1) {
#ifndef _WIN32
        chars = vsnprintf(buffer,size,Format,ap);
#else
        chars = _vsnprintf(buffer,size,Format,ap);
#endif
        if (chars > -1 && chars < size) {
            break;
        }
        if (chars>-1) {
            size=chars+1;
        } else {
            size*=2;
        }
        delete[]buffer;
        buffer = new char[size];
    }
    va_end(ap);

    if (buffer) {
        msg = buffer;
        delete []buffer;
    }
    return msg;
}

bool Casecmp::operator()(const std::string&x, const std::string&y)const
{
    std::string::const_iterator p=x.begin();
    std::string::const_iterator q=y.begin();

    while (p!=x.end()&&q!=y.end()&&toupper(*p)==toupper(*q)) {
        ++p;
        ++q;
    }
    if (p==x.end()) return q!=y.end();
    return toupper(*p)<toupper(*q);
}
