/***************************************************************************
 *                        addmysqluser.cpp  -  description
 *                           -------------------
 *  begin                : Sam Sep 27 2003
 *  copyright            : (C) 2003 by Rajko Albrecht
 *  email                : ral@alwins-world.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addmysqluser.h"
#include "helpers/tfunctions.h"
#include <kcombobox.h>
#include <kactivelabel.h>
#include <klineedit.h>
#include <klistbox.h>
#include <qcheckbox.h>
#include <kpassdlg.h>
#include <string>
#include <iostream>

using namespace std;

const std::string CAddmysqluser::JOKER = string("*");
const char* CAddmysqluser::GRANT = "Grant";
const char* CAddmysqluser::ALL = "All";

CAddmysqluser::CAddmysqluser(smart_pointer<CMySql>& _sql_server,QWidget *parent, const char *name ) 
    : CAddmysqluserdata(parent,name)
{
    sql_server = _sql_server;
    npw = "";
    npw2 = "";
    m_current_db = "*";
    m_current_table = "*";
    setNextEnabled(page,false);
    if (sql_server) {
        sql_server->get_db_list("%",m_db_list);
        for (stringlist::iterator iter = m_db_list.begin();iter != m_db_list.end();++iter) {
            dblist->insertItem(iter->c_str());
        }
    }
    init_right_lists();
    rights_list->clear();
    rights_list->insertStringList(userrights);
    m_grant = false;
}

CAddmysqluser::~CAddmysqluser()
{
}

void CAddmysqluser::pw1changed(const QString&)
{
    check_next_1();
}

void CAddmysqluser::pw2changed(const QString&)
{
    check_next_1();
}

void CAddmysqluser::dblistchanged(const QString&adb)
{
    dbinput->setText(adb);
}

void CAddmysqluser::alternate_db_changed(bool how)
{
    dbinput->setReadOnly(!how);
    dbinput->setEnabled(how);
    dblist->setEnabled(!how);
    if (!how) {
        dbinput->setText(dblist->currentText());
    }
}

void CAddmysqluser::dbtext_changed(const QString&adb)
{
    string t_db = adb.latin1();
    tablelist->clear();
    tablelist->insertItem(JOKER.c_str());
    if (m_db_list.find(t_db)!=m_db_list.end()) {
        dblist->setCurrentText(adb);
        tablelist->setEnabled(true);
        if (m_db_tables.find(t_db)==m_db_tables.end()) {
            stringlist Result;
            sql_server->get_table_list("%",t_db,Result);
            m_db_tables[t_db]=Result;
        }
        for (stringlist::iterator iter=m_db_tables[t_db].begin();iter!=m_db_tables[t_db].end();++iter) {
            tablelist->insertItem(iter->c_str());
        }
    } else {
        tablelist->setEnabled(false);
    }
    m_current_db = t_db;

    if (m_current_table != JOKER) {
        tablelist->setCurrentText(JOKER.c_str());
        tablelistchanged(JOKER.c_str());
    } else {
        rights_list->clear();
        m_rights_list.clear();
        if (m_current_db == JOKER) {
            rights_list->insertStringList(userrights);
        } else {
            rights_list->insertStringList(dbrights);
        }
    }
    check_buttons();
}

void CAddmysqluser::tablelistchanged(const QString&atable)
{
    tableinput->setText(atable);
}

void CAddmysqluser::alternate_table_changed(bool how)
{
    tableinput->setEnabled(how);
    tableinput->setReadOnly(!how);
    tablelist->setEnabled(!how);
    if (!how) {
        
    } else {
    }
}

void CAddmysqluser::tabletext_changed(const QString&aTab)
{
    m_columns_list.clear();
    column_list->clear();
    m_current_table = aTab.latin1();
    if (m_db_tables.find(m_current_db)!=m_db_tables.end() 
        && m_db_tables[m_current_db].find(m_current_table)!=m_db_tables[m_current_db].end()) {
        enable_column_check->setEnabled(true);
    } else {
        enable_column_check->setEnabled(false);
    }
    enable_column_check->setChecked(false);
    rights_list->clear();
    m_rights_list.clear();
    if (m_current_db==JOKER) {
        rights_list->insertStringList(userrights);
    } else {
        if (m_current_table==JOKER) {
            rights_list->insertStringList(dbrights);
        } else {
            rights_list->insertStringList(tablerights);
        }
    }
    check_buttons();
}

void CAddmysqluser::hostname_changed(const QString&ahostname)
{
    hostname = ahostname.latin1();
    check_next_1();
}

void CAddmysqluser::username_changed(const QString&aName)
{
    username = aName.latin1();
}

void CAddmysqluser::column_check_changed(bool how)
{
    column_list->setEnabled(how);
    rights_list->clear();
    m_rights_list.clear();
    if (m_columns_list.size()==0 && how == true) {
        // we had changed the table
        ColumnList tlist;
        if (!sql_server->get_table_fields(m_current_db,m_current_table,tlist)) {
            column_list->setEnabled(false);
            enable_column_check->setChecked(false);
            return;
        }
        for (ColumnList_iterator iter=tlist.begin();iter!=tlist.end();++iter) {
            m_columns_list.push_back(iter->get_name());
            column_list->insertItem(iter->get_name().c_str());
        }
    }
    enablegrantbox->setEnabled(!how);
    if (how) {
        rights_list->insertStringList(columnrights);
        enablegrantbox->setChecked(false);
    } else {
        if (m_current_db==JOKER) {
            rights_list->insertStringList(userrights);
        } else {
            if (m_current_table==JOKER) {
                rights_list->insertStringList(dbrights);
            } else {
                rights_list->insertStringList(tablerights);
            }
        }
    }
}

void CAddmysqluser::column_list_changed(const QString&)
{
}

void CAddmysqluser::enable_grants_changed(bool how)
{
    m_grant = how;
    check_finish();
}

void CAddmysqluser::allrightsbox_changed(bool how)
{
    rights_list->setEnabled(!how);
    if (m_current_db==JOKER) {
        check_usage->setEnabled(!how);
    }
    m_rights_list.clear();
    if (how) {
        m_rights_list.push_back(ALL);
    } else {
        for (unsigned int c = 0; c < rights_list->count();++c) {
            if (rights_list->isSelected(c)) {
                m_rights_list.push_back(rights_list->text(c).latin1());
            }
        }
    }
    check_finish();
}

void CAddmysqluser::rights_selection_changed()
{
    m_rights_list.clear();
    for (unsigned int c = 0; c < rights_list->count();++c) {
        if (rights_list->isSelected(c)) {
            m_rights_list.push_back(rights_list->text(c).latin1());
        }
    }
    check_finish();
}

void CAddmysqluser::check_next_1()
{
    if (pw1input->text()!=pw2input->text()|| hostname.size()==0) {
        setNextEnabled(page,false);
    } else {
        setNextEnabled(page,true);
    }
}

void CAddmysqluser::init_right_lists()
{
    unsigned j;
    const char**rlist;
    hostrights.clear();
    rlist = CMySql::host_rights();
    for (j = 0; strlen(rlist[j])!=0;++j) {
        if (Caseequ()(rlist[j],GRANT))
            continue;
        hostrights.append(rlist[j]);
    }
    userrights.clear();
    rlist = CMySql::user_rights();
    for (j=0; strlen(rlist[j])!=0;++j) {
        if (Caseequ()(rlist[j],GRANT))
            continue;
        userrights.append(rlist[j]);
    }
    dbrights.clear();
    rlist = CMySql::db_rights();
    for (j = 0; strlen(rlist[j])!=0; ++j) {
        if (Caseequ()(rlist[j],GRANT))
            continue;
        dbrights.append(rlist[j]);
    }
    tablerights.clear();
    rlist = CMySql::table_rights();
    for (j = 0; strlen(rlist[j])!=0;++j) {
        if (Caseequ()(rlist[j],GRANT))
            continue;
        tablerights.append(rlist[j]);
    }
    columnrights.clear();
    rlist = CMySql::column_rights();
    for (j = 0; strlen(rlist[j])!=0;++j) {
        if (Caseequ()(rlist[j],GRANT))
            continue;
        columnrights.append(rlist[j]);
    }
}

void CAddmysqluser::usage_toggled(bool how)
{
    m_rights_list.clear();
    if (how) {
        m_rights_list.push_back("Usage");
    } else {
        for (unsigned int c = 0; c < rights_list->count();++c) {
            if (rights_list->isSelected(c)) {
                m_rights_list.push_back(rights_list->text(c).latin1());
            }
        }
    }
    dblist->setEnabled(!how && !alternatedb->isChecked());
    alternatedb->setEnabled(!how);
    dbinput->setEnabled(!how && alternatedb->isChecked());
    tablelist->setEnabled(!how && !alternatedb->isChecked());
    alternatetable->setEnabled(!how);
    tableinput->setEnabled(!how && alternatedb->isChecked());
    enablegrantbox->setEnabled(!how);
    rights_list->setEnabled(!how);
    allrightsbox->setEnabled(!how);
    check_finish();
}

void CAddmysqluser::check_buttons()
{
    if (m_current_table != JOKER) {
        check_usage->setEnabled(false);
        check_usage->setChecked(false);
        allrightsbox->setEnabled(true);
    } else {
        if (m_current_db == JOKER) {
            check_usage->setEnabled(!allrightsbox->isChecked());
        } else {
            check_usage->setEnabled(false);
            check_usage->setChecked(false);
            allrightsbox->setEnabled(true);
        }
    }
}

void CAddmysqluser::check_finish()
{
    if (m_rights_list.size()) {
        setFinishEnabled(page_3,true);
    } else {
        setFinishEnabled(page_3,false);
    }
}

void CAddmysqluser::accept()
{
    npw = pw1input->text().latin1();
    if (enable_column_check->isChecked()) {
        if (allrightsbox->isChecked()) {
            m_rights_list.clear();
            for (unsigned int c = 0; c < rights_list->count();++c) {
                m_rights_list.push_back(rights_list->text(c).latin1());
            }
        }
        string col = column_list->currentText().latin1();
        for (unsigned c = 0; c < m_rights_list.size(); ++c) {
            m_rights_list[c] += (string("(")+col+string(")"));
        }
    }
    CAddmysqluserdata::accept();
}
