/***************************************************************************
                          kryptosf.cpp  -  description
                             -------------------
    begin                : Sam Dez 22 22:15:44 CET 2001
    copyright            : (C) 2001 by SiSch
    email                : general_ossig@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kryptosf.h"
#include <kcmdlineargs.h>

Kryptosf::Kryptosf( )
{
	 kryptosDateiHeader = "Kryptosf save file.Do not change anything!\n\n\5\6\7";
	 Programsaidit = false;
	 w = new QWidget( this, "Kryptos main Widget" );
	 CHECK_PTR( w );

	 statusBar()->setSizeGripEnabled( true );
	 statusBar()->insertItem (i18n("Bereit "), 	STATUSBAR_READY);
	 setCaption ("KRYPTOs frend");

//-----------------------konstruktoraufrufe  usw.---------------

  DirView = new KDirOperator(KURL("file:/home/simon"), w, "DirView" );
	CHECK_PTR( DirView );
  DirView->readConfig( KGlobal::config(), "Your KDiroperator ConfigGroup" );

	FileInfo = new QFileInfo ();
 	CHECK_PTR( FileInfo );

   cd = new ConfigDialog( w , "the_fucking_config dialog");
   CHECK_PTR ( cd );

   QButtonGroup *bg = new QButtonGroup( w );
   bg->hide();

   r8fach = new QRadioButton (i18n("&Schwere Verschlüsselung"), w , "r8fach");
   r2fach = new QRadioButton (i18n("E&infache Verschlüsselung"), w , "r2fach");

   bg->insert(r2fach);
   bg->insert(r8fach);

   bg = new QButtonGroup( w );
   bg->hide();

   rver = new QRadioButton (i18n("&Verschlüsseln"), w , "rver");
   rent = new QRadioButton (i18n("E&ntschlüsseln"), w, "rent");

   bg->insert(rent);
   bg->insert(rver);

   FileDialog = new KFileDialog ("/", "*", w, "file_dialog", true);
   CHECK_PTR ( FileDialog );

   SrcGroup = new QGroupBox (i18n("Quelle"), w , "src_group");
	 CHECK_PTR ( SrcGroup );

   TrgGroup = new QGroupBox (i18n("Output"), w , "trg_group");
	 CHECK_PTR ( TrgGroup );
	
   SrcGroupvlayout = new QVBoxLayout (SrcGroup, 5);
   CHECK_PTR ( SrcGroupvlayout );

   TrgGroupvlayout = new QVBoxLayout (TrgGroup, 5);
   CHECK_PTR ( TrgGroupvlayout );

   hlayout1 = new QHBoxLayout ();
   CHECK_PTR ( hlayout1 );

	 Trghlayout = new QHBoxLayout ();
   CHECK_PTR ( Trghlayout );

	 Srchlayout = new QHBoxLayout ();
   CHECK_PTR ( Srchlayout );

   vlayout = new QVBoxLayout ();
   CHECK_PTR ( vlayout );

   hlayout = new QHBoxLayout ( w , 5);
   CHECK_PTR ( hlayout );

   Browser = new QTextView (i18n( "<center><b><u>Hier erscheint die Ausgabe des Krypto Verschlüsselungsprogramms</u></b></center><br>" ), i18n( "Ausgabe von Krypto" ), w , "main_edit");
   CHECK_PTR ( Browser );

   BeginBtn = new QPushButton(i18n( "&Los!"), w );
   CHECK_PTR ( BeginBtn );

   BeginAllBtn = new QPushButton(i18n( "Los A&lle!"), w );
   CHECK_PTR ( BeginAllBtn );

	SrcLbx = new QListBox( SrcGroup, "Source_LBX", 0);
	CHECK_PTR( SrcLbx );

	TrgLbx = new QListBox( TrgGroup, "Target_LBX", 0);
	CHECK_PTR( TrgLbx );

   AddFileBtn = new QPushButton(i18n( "Eintrag &hinzufügen" ), SrcGroup);
	 CHECK_PTR ( AddFileBtn );

   SearchBtn = new QPushButton (BarIcon("find"), i18n ("..."), SrcGroup);
   CHECK_PTR( SearchBtn );

   SrcEdit = new QLineEdit (SrcGroup, "src_edit");
	 CHECK_PTR ( SrcEdit );

   TrgSearchBtn = new QPushButton (BarIcon("find"), i18n ("..."), TrgGroup);
	 CHECK_PTR ( TrgSearchBtn );

   Overwrite = new QCheckBox (i18n( "Dateien ungefragt &überschreiben" ), TrgGroup, "overwrite");
   CHECK_PTR( Overwrite );

   TrgEdit = new QLineEdit (TrgGroup, "Trg_edit");
	 CHECK_PTR ( TrgEdit );

	 timer1 = new QTimer( w, "Process Timer" );
	 CHECK_PTR( timer1 );/*-->*/timer1->stop();

	 Process = new KShellProcess();
	 CHECK_PTR( Process );
   //siehe layout managment wegen der PswEdits

//-Actions-
setupActions();

//+-+-+-+-+-+Menu+-+-+-+-+-+-+-+-+
setupMenu();

//+-+-+-+-+-+Toolbar+-+-+-+-+-+-+-+-+
setupToolbar();
toolBar()->reparent( w, toolBar()->pos(), true );
toolBar()->show();

///////////////////////////layout managment///////////////////////
setupLayouts();

/////////////////////////////tooltips///////////////////////////
setupTooltips();

//+-+-+-+-+-+-+-read configuration+-+-+-+-+-+-+-+
readConfig();

//+-+-+-+-+-+-+-+-+-+-+-+-+-connections+-+-+-+-+-+-+-+-+-+-+-+-+-+
setupConnections();

//+++++++++++++++++++++++++++sonstiges++++++++++++++++++++++++++++

  //einmaliges resizen zu Beginn
/*  QResizeEvent *e = new QResizeEvent(QSize(width(), height()), QSize(width(), height()));
  resizeEvent(e);
  delete e;*/
  DirView->setView(KFile::Default);	
  FileDialog->setFilter (i18n( "*|Alle Dateien|*.txt|Textdateien (*.txt)" ));

	SrcLbx->setHScrollBarMode( QScrollView::AlwaysOn );	
	TrgLbx->setHScrollBarMode( QScrollView::AlwaysOn );	
  setView( w );
	UpAction->setEnabled( ((uint)SrcLbx->currentItem() == SrcLbx->count() -1 ) );
	DownAction->setEnabled( (SrcLbx->currentItem() == 0) );
}

QString Kryptosf::Arguments( const QString Src, bool slim , bool real)
{
QString s = "";

s += real ? ExtraParameter + " " : cd->KryptoExtraEdt->text() + " ";
s += ( slim && rver->isChecked() ) ? "-s" : "-";
s += rent->isChecked() ? "d" : "";
s += "k ";

if (real)
	 s += "\"" + PswEdit->text() + "\"";
else
	{
	s += "\"";
	for (unsigned int i=0;i<PswEdit->text().length();i++)
	   s += "*";
	s += "\"";
   }
s += " ";
s += Src;

return s;
}
void Kryptosf::saveConfig()
{
  config = KGlobal::config();

	DirView->saveConfig( config, "DirView"  );
	config->setGroup( "DirView" );
	config->writeEntry( "Directory", DirView->url().url() );

  config->setGroup( "Krypto" );
  config->writeEntry( "Program", Program );
  config->writeEntry(  "ExtraParameter", ExtraParameter);

  config->setGroup( "LastValues" );
  config->writeEntry ( "SourceEdit", SrcEdit->text() );
  config->writeEntry( "TargetEdit", TrgEdit->text() );
  config->writeEntry( "Ver", rver->isChecked() );
	config->writeEntry( "Overwrite", Overwrite->isChecked() );

	config->writeEntry( "SlimList", SlimList );

	QStringList myStringList;
	for (uint i = 0; i< SrcLbx->count(); i++)
			myStringList.append( SrcLbx->text( i ) );
	config->writeEntry( "SrcList", myStringList.join ( "	" ));//separator is tab

  myStringList.clear();
	for (uint i = 0; i< TrgLbx->count(); i++)
			myStringList.append( TrgLbx->text( i ) );
	config->writeEntry( "TrgList", myStringList.join( "	" ));  //separator is tab

  config->setGroup( "Ansicht" );
	config->writeEntry( "versteckeAusgabe", Browser->isHidden() );
	config->writeEntry( "versteckeToolBar", toolBar()->isHidden() );
	config->writeEntry( "versteckeDirView", DirView->isHidden() );
	config->writeEntry( "versteckeStatusBar", DirView->isHidden() );

	config->writeEntry( "Automatische Ergaenzung", ToggleAutoErgAct->isChecked() );
	config->writeEntry( "Quellen loeschen", ToggleDeleteOrgAct->isChecked() );
}
Kryptosf::~Kryptosf()
{
}

void Kryptosf::slotSrcEditChange ( const QString & FileName)
{

/*Soll TrgEdit berhaupt angepasst/ergnzt werden ?*/
if ( !ToggleAutoErgAct->isChecked() )
		return;

_disconnect();
 SrcLbx->changeItem (getSrcIcon( FileName ), FileName, SrcLbx->currentItem());
 if (rver->isChecked())
	 TrgEdit->setText (FileName + ".kr");
 else
	 {
  	 TrgEdit->setText (FileName + ".krd");
	 }

_reconnect();
}

void Kryptosf::slotAddFileBtnClicked ()
{
/*
 *Die funktion prft ob es den Eintrag bereits gibt
 *bevor sie ihn hinzufgt
 */
_disconnect();
QString Src = SrcEdit->text(), Trg = TrgEdit->text();

/*
 for (uint i = 0; i < SrcLbx->count(); i++ )
	if ( SrcLbx->text( i ) == Src && TrgLbx->text( i ) == Trg)
		{
		 SrcLbx->setSelected( i, true );
		 TrgLbx->setSelected( i, true );
		 return;
		}
*/
 int SrcCp/*cursorposition*/ = SrcEdit->cursorPosition();
 int TrgCp = TrgEdit->cursorPosition();

 SlimList.insert(SrcLbx->currentItem() + 1, r2fach->isChecked() ? 'j' : 'n');


 SrcLbx->insertItem(getSrcIcon( Src ), Src, SrcLbx->currentItem() + 1 );
 TrgLbx->insertItem(getTrgIcon( Trg ), Trg, SrcLbx->currentItem() );

 SrcLbx->setCurrentItem( SrcLbx->currentItem() +1 );
 slotLbxUpdate();

 SrcEdit->setCursorPosition( SrcCp );
 TrgEdit->setCursorPosition( TrgCp );

 _reconnect();
}

void Kryptosf::slotSearchBtnClicked()
{
 KURL::List filelist;
 QString s = localPathFromURL( SrcEdit->text() );

 if (!s.isEmpty())
    filelist = FileDialog->getOpenURLs( s );
 else
	 filelist = FileDialog->getOpenURLs();

 if (filelist.isEmpty())
     return;

_disconnect();
	SrcLbx->insertStringList( filelist.toStringList() );

	for(uint i = TrgLbx->count(); i < SrcLbx->count(); i++)
		{
		 SrcLbx->changeItem(
				getSrcIcon ( SrcLbx->text( i ) ),
					 SrcLbx->text( i ),
						 i);
		 TrgLbx->insertItem (
				getTrgIcon ( SrcLbx->text( i ) + ( rver->isChecked() ? ".kr" : ".krd") ),
					 SrcLbx->text( i ) + ( rver->isChecked() ? ".kr" : ".krd"),
						 -1);
		 SlimList += (r2fach->isChecked() ? 'j' : 'n');
		}

_reconnect();

SrcLbx->setCurrentItem( SrcLbx->count() );
TrgLbx->setCurrentItem( SrcLbx->currentItem() );
}

void Kryptosf::slotTrgSearchBtnClicked()
{
 KURL file;
 QString s = localPathFromURL( SrcEdit->text() );

 if (s.isEmpty())
     s = FileDialog->getOpenFileName();
 else
     s = FileDialog->getOpenFileName( s );

 if ( s.isEmpty() )
		 return;

 TrgEdit->setText( s );
}

void Kryptosf::slotFilterChanged(const QString & file)
{
 SrcEdit->setText( file );
}

void Kryptosf::slotConfigMnuClicked ()
{
  if ( SrcLbx->count() )
		  QToolTip::add(cd->KryptoExtraEdt, i18n ( "<u>Aktuelle Befehlszeile:</u><br><i> " ) + Program  + "</i><br><font color=#0000ff> " +  Arguments( SrcEdit->text(), (SlimList.ref ( SrcLbx->currentItem() ) == 'j') ,false));

  cd->showDialog(Program, ExtraParameter);
}

void Kryptosf::slotBtn1Clicked()
{
Program=cd->KryptoEdt->text();
ExtraParameter=cd->KryptoExtraEdt->text();
saveConfig();
cd->close(0);
}

void Kryptosf::slotBtn2Clicked()
{
Program=cd->KryptoEdt->text();
ExtraParameter=cd->KryptoExtraEdt->text();
saveConfig();
}
void Kryptosf::slotBtn3Clicked()
{
cd->close (0);
}

void Kryptosf::slotFindBtnClicked()
{
QString s = KFileDialog::getOpenFileName();

if (s.isEmpty())
	return;

cd->KryptoEdt->setText( s );
}

bool Kryptosf::queryClose()
{
saveConfig();

return true;
}

void Kryptosf::slotExtraEdtChange ( const QString &)
{
  QToolTip::add(cd->KryptoExtraEdt, i18n( "<u>Aktuelle Befehlszeile:</u><br> <i>" ) + Program  + "</i><br><font color=#0000ff> " +  Arguments( SrcEdit->text(), (SlimList.ref ( SrcLbx->currentItem() ) == 'j') , false));
}

void Kryptosf::slotBegin()
{
Browser->setText( Browser->text() + i18n( "<b><u><br>neue Session:</u></b><br>" ) );

if (!allRight( SrcEdit->text(), TrgEdit->text() ))
	 return;

_disable();

  timer1->stop();
	currentStep = 0;
	totalSteps=0;

QString Src = SrcEdit->text();

KURL URL( Src );

if (! KIO::NetAccess::download( URL, Src ) )
   {
    sorry ( i18n ( "Quelldatei konnte nicht geöffnet werden:\n" ) + Src, i18n ( "Fehler" ));
		_enable();
    return;
   }

	FileInfo->setFile( Src );
	srcsize=FileInfo->size();

	totalSteps = srcsize;
	if ( rver->isChecked() )
			totalSteps *= r2fach->isChecked() ? 2 : 8;
	else
			totalSteps /= r2fach->isChecked() ? 2 : 8;

QProgressDialog pdlg( i18n( "Bearbeite:\n" ) + Src,i18n( "&Abbruch" ), totalSteps, this, "Progress Dialog");
connect( this, SIGNAL( fortschrittAktualisieren( int ) ), &pdlg, SLOT( setProgress( int ) ) );
connect( &pdlg, SIGNAL( cancelled() ), this, SLOT( slotCancel() ));

statusBar()->message ( i18n("Arbeite...") );	

work ( SrcLbx->currentItem(), Src, TrgEdit->text() );	

KIO::NetAccess::removeTempFile( Src );
statusBar()->message ( pdlg.wasCancelled() ? i18n("Abgebrochen") : i18n("Fertig"), 2000 );

_enable();
}

void Kryptosf::slotDataReceived(KProcess *proc, char *buffer, int buflen)
{
 QString s;
 for (int i=0; i < buflen; i++)
		 s += buffer[i];

 if (s == "ich bin krypto von SiSch")
		Programsaidit = true;

 while ( s.contains( '<' ) )
		s.replace ( s.find( '<', 0, true ), 1, "&lt;"  );

 while ( s.contains( '>' ) )
		s.replace ( s.find( '>', 0, true ), 1, "&gt;"  );

 while ( s.contains( '"' ) )
		s.replace ( s.find( '"', 0, true ), 1, "&quot;"  );

 while ( s.contains( '\n' ) )
		s.replace ( s.find( '\n', 0, true ), 1, "<br>"  );

 Browser->setText( Browser->text() + s );
 Browser->verticalScrollBar()->setValue( Browser->verticalScrollBar()->maxValue() );

 if (s.contains( "<br>Falsches Passwort...<br>" ))
		sorry( i18n( "Das angegebene Passwort ist falsch!" ), i18n( "Krypto:" ) );
}

bool Kryptosf::isRightProgram ()
{
  Programsaidit = false;
	Process->clearArguments();
	*Process << Program << "-w"/*wer_bist_du?*/;
	timer1->start( 1100, true );
	Process->start(KProcess::DontCare, KProcess::Stderr);

	while ( Process->isRunning() && !Programsaidit )
				 kapp->processEvents();

if ( !Process->normalExit() )
		return false;
if  ( Process->exitStatus() != ICH_BIN_KRYPTO_VON_SICH )
		return false;
if ( Programsaidit )
		return false;

return true;
}

void Kryptosf::slotCancel()
{
 Process->closeStderr();
 Process->closeStdout();
 if (Process->isRunning())
		Process->kill( SIGTERM );
 timer1->stop();
 _enable();
 StopAction->setEnabled( false );
}

void Kryptosf::slotStdDataReceived(KProcess *proc, char *buffer, int buflen )
{
oFile->writeBlock( buffer, buflen );
currentStep += buflen;

emit fortschrittAktualisieren( currentStep );
}

/** Allgemeine Connections */
void Kryptosf::setupConnections(){
  connect( DirView, SIGNAL( fileSelected (const KFileViewItem*) ), SLOT( DirViewFileSelected (const KFileViewItem*) ) );
	connect(SrcLbx, SIGNAL( rightButtonClicked( QListBoxItem *, const QPoint & ) ), SLOT( slotLbxMenu( QListBoxItem *, const QPoint & ) ) );
	connect(TrgLbx, SIGNAL( rightButtonClicked( QListBoxItem *, const QPoint & ) ), SLOT( slotLbxMenu( QListBoxItem *, const QPoint & ) ) );
	connect(SrcLbx, SIGNAL( doubleClicked( QListBoxItem *) ), SLOT( slotLbxDoubleClicked( QListBoxItem *) ) );
	connect(TrgLbx, SIGNAL( doubleClicked( QListBoxItem *) ), SLOT( slotLbxDoubleClicked( QListBoxItem *) ) );
	connect(SrcLbx->verticalScrollBar(), SIGNAL( valueChanged( int ) ), SLOT(SrcLbxScrollbarChanged ( int )) );
	connect(TrgLbx->verticalScrollBar(), SIGNAL( valueChanged( int ) ), SLOT(TrgLbxScrollbarChanged ( int )) );

	connect(TrgEdit, SIGNAL(textChanged(const QString &)), this, SLOT(slotTrgEditChange (const QString &)));
	connect(SrcEdit, SIGNAL(textChanged(const QString &)), this, SLOT(slotSrcEditChange (const QString &)));
	connect(SrcEdit, SIGNAL( returnPressed() ), this, SLOT( slotAddFileBtnClicked() ));

	connect(SrcLbx, SIGNAL( highlighted( int ) ), this, SLOT( slotLbxSelChanged( int ) ));
	connect(TrgLbx, SIGNAL( highlighted( int ) ), this, SLOT( slotLbxSelChanged( int ) ));

	connect(AddFileBtn, SIGNAL(clicked()), this, SLOT(slotAddFileBtnClicked ()));
	connect(BeginBtn, SIGNAL(clicked()), this, SLOT(slotBegin()));
	connect(SearchBtn, SIGNAL(clicked()), this, SLOT(slotSearchBtnClicked()));
	connect(TrgSearchBtn, SIGNAL(clicked()), this, SLOT(slotTrgSearchBtnClicked()));
	connect(FileDialog, SIGNAL(filterChanged(const QString & )), this, SLOT(slotFilterChanged (const QString & )));

	connect (cd->button1, SIGNAL(clicked()), this, SLOT(slotBtn1Clicked ()));
	connect (cd->button2, SIGNAL(clicked()), this, SLOT(slotBtn2Clicked ()));
	connect (cd->button3, SIGNAL(clicked()), this, SLOT(slotBtn3Clicked ()));
	connect (cd->KryptoFindBtn, SIGNAL(clicked()), this, SLOT(slotFindBtnClicked ()));
	connect(cd->KryptoExtraEdt, SIGNAL(textChanged( const QString & )), this, SLOT(slotExtraEdtChange (const QString &)));

	connect(timer1, SIGNAL( timeout() ), this, SLOT( slotCancel() ));
	connect(Process, SIGNAL( receivedStderr (KProcess *, char *, int ) ) , this, SLOT( slotDataReceived(KProcess *, char *, int ) ));
	connect(Process, SIGNAL( receivedStdout (KProcess *, char *, int ) ) , this, SLOT( slotStdDataReceived(KProcess *, char *, int ) ));
	connect(BeginAllBtn, SIGNAL( clicked() ), this, SLOT( slotBeginAllBtnClicked() ));
	connect(rver, SIGNAL( stateChanged ( int ) ), this, SLOT( slotStateChanged( int ) ));
	connect(r2fach, SIGNAL( stateChanged ( int ) ), this, SLOT( slotSlimChanged( int ) ));
}
/** No descriptions */
void Kryptosf::slotStateChanged( int s ){

LbxSwapAll();
if ( s == 0 )
	{
	 PswEdit2->setEnabled( false );
	 r2fach->setEnabled( false );
	 r8fach->setEnabled( false );
	}
else
	{
	 PswEdit2->setEnabled( true );
	 r2fach->setEnabled( true );
	 r8fach->setEnabled( true );
	 TrgEdit->setText( SrcEdit->text() + ".kr" );
	}
}
/** Setup the layouts */
void Kryptosf::setupLayouts(){
	vlayout->addWidget( toolBar( ) );
	//vlayout->addWidget( SrcURLRequester );
  //spacer 1
  spacer = new QGroupBox( w , "spacer_1");
	CHECK_PTR( spacer );
  spacer->setFixedHeight(2);
  vlayout->addWidget (spacer);

  ahlayout = new QHBoxLayout ();

  avlayout = new QVBoxLayout ();
	r2fach->setMinimumSize( r2fach->sizeHint() );
	r8fach->setMinimumSize( r8fach->sizeHint() );
  avlayout->addWidget (r2fach);
  avlayout->addWidget (r8fach);


  ahlayout->addLayout (avlayout);
	ahlayout->addStretch();

  avlayout = new QVBoxLayout ();
	rver->setMinimumSize( rver->sizeHint() );
	rent->setMinimumSize( rent->sizeHint() );
  avlayout->addWidget (rver);
  avlayout->addWidget (rent);

  ahlayout->addLayout (avlayout);
	ahlayout->addStretch();

  vlayout->addLayout(ahlayout);

  //source
	avlayout = new QVBoxLayout();
	CHECK_PTR ( avlayout );

  avlayout->addSpacing (20);
	SrcEdit->setMinimumSize( SrcEdit->sizeHint());
  SrcEdit->setFixedHeight(25);
  avlayout->addWidget (SrcEdit);
	avlayout->addSpacing( 10 );
	AddFileBtn->setMinimumSize( AddFileBtn->sizeHint());
  AddFileBtn->setFixedHeight(25);
  avlayout->addWidget (AddFileBtn);
	avlayout->addStretch();

  Srchlayout->addLayout (avlayout);

	avlayout = new QVBoxLayout();
	CHECK_PTR ( avlayout );

	avlayout->addSpacing (20);
	SearchBtn->setFixedSize(25, 25);
	avlayout->addWidget(SearchBtn);
	avlayout->addStretch();

  Srchlayout->addLayout (avlayout);

	SrcGroupvlayout->addLayout( Srchlayout );
	SrcGroupvlayout->addSpacing( 5 );
	SrcLbx->setMinimumSize( 4* SrcLbx->sizeHint() );
	SrcGroupvlayout->addWidget( SrcLbx );

  //target
	avlayout = new QVBoxLayout();
	CHECK_PTR ( avlayout );

  avlayout->addSpacing (20);
	TrgEdit->setMinimumSize( TrgEdit->sizeHint());
  TrgEdit->setFixedHeight(25);
  avlayout->addWidget (TrgEdit);
	avlayout->addSpacing( 10 );
  Overwrite->setMinimumSize( Overwrite->sizeHint() );
  avlayout->addWidget ( Overwrite );
	avlayout->addStretch();

  Trghlayout->addLayout (avlayout);

	avlayout = new QVBoxLayout();
	CHECK_PTR ( avlayout );

	avlayout->addSpacing (20);
	TrgSearchBtn->setFixedSize(25, 25);
	avlayout->addWidget( TrgSearchBtn );
	avlayout->addStretch();

  Trghlayout->addLayout (avlayout);
	TrgGroupvlayout->addLayout( Trghlayout );
	TrgGroupvlayout->addSpacing( 5 );	
	TrgLbx->setMinimumSize( 4* TrgLbx->sizeHint() );
	TrgGroupvlayout->addWidget( TrgLbx );

  //weiteres layout
  hlayout1->addWidget (SrcGroup);
	hlayout1->addSpacing( 5 );
  hlayout1->addWidget (TrgGroup);

  vlayout->addLayout (hlayout1);

  //passwort
  spacer = new QGroupBox( w , "pasw_group");
	CHECK_PTR( spacer );
  avlayout = new QVBoxLayout(spacer, 10);
  CHECK_PTR( avlayout );

  PswEdit = new QLineEdit (spacer, "Psw_edit");
	CHECK_PTR ( PswEdit );
	PswEdit->setEchoMode( QLineEdit::Password );

  PswEdit2 = new QLineEdit (spacer, "Psw_edit2");
	CHECK_PTR ( PswEdit2 );
	PswEdit2->setEchoMode( QLineEdit::Password );

	ahlayout = new QHBoxLayout ();
	CHECK_PTR( ahlayout );
  QLabel *label = new QLabel( i18n( "Passwort:" ), spacer);
	CHECK_PTR( label );
	label->setMinimumSize(label->sizeHint());

  ahlayout->addWidget( label );
  ahlayout->addStretch();

	avlayout->addSpacing( 5 );
	avlayout->addLayout( ahlayout );
	avlayout->addWidget( PswEdit );
	avlayout->addSpacing( 15 );

  ahlayout = new QHBoxLayout ();
	CHECK_PTR( ahlayout );

  label = new QLabel( i18n( "Passwort(nochmal):" ), spacer);
	CHECK_PTR( label );
	label->setMinimumSize(label->sizeHint());

  ahlayout->addWidget( label );
  ahlayout->addStretch();

	avlayout->addLayout( ahlayout );
	avlayout->addWidget( PswEdit2 );
  vlayout->addWidget( spacer );
  vlayout->addSpacing (10);

	Browser->setMinimumSize( 100, 100 );
	vlayout->addWidget ( Browser);
  vlayout->addSpacing( 10 );

  ahlayout = new QHBoxLayout ();
	CHECK_PTR( ahlayout );

	BeginBtn->setMinimumSize( BeginBtn->sizeHint() );
	BeginAllBtn->setMinimumSize( BeginAllBtn->sizeHint() );
	ahlayout->addWidget ( BeginBtn );
	ahlayout->addSpacing ( 10 );
	ahlayout->addWidget ( BeginAllBtn );
	vlayout->addLayout( ahlayout );

  vlayout->addSpacing ( 10 );
	//spacer2
  spacer = new QGroupBox( w , "spacer_2");
	CHECK_PTR( spacer );
  spacer->setFixedHeight(2);
  vlayout->addWidget (spacer);

	DirView->setMinimumSize( 250, 100 );

  hlayout->addWidget( DirView );
	hlayout->addLayout( vlayout );
  hlayout->activate();
  setGeometry (x(), y(), 500, 500);
}
/** setup the Tooltips */
void Kryptosf::setupTooltips(){
	QToolTip::add(Overwrite, i18n ("Soll vor dem überschreiben von Dateien gefragt werden?"));
	QToolTip::add(BeginBtn, i18n ("Mit dem Ver bzw. Entschlüsseln einer einzelnen Datei beginnen"));
	QToolTip::add(SearchBtn, i18n ("Datei suchen"));
	QToolTip::add(TrgSearchBtn, i18n ("Datei suchen"));
	QToolTip::add(cd->KryptoFindBtn, i18n ("Programm suchen"));
	QToolTip::add( cd->KryptoEdt, i18n( "Wechseln sie in das " ) );
/*	QToolTip::add(r8fach, i18n("Die verschlüsselte Datei ist 8x\nso groß wie die Quelldatei\n( sehr starke Verschluesselung ).\n\nDiese Option ist nur für das VERschluesseln relevant."));
	QToolTip::add(r2fach, i18n("Die verschlüsselte Datei ist doppelt\nso groß wie die Quelldatei ( empfohlen ).\n\nDiese Option ist nur für das VERschlüsseln relevant."));
*/
  QToolTip::add(BeginAllBtn, i18n("Mit dem Ver bzw. Entschlüsseln aller aufgelisteten Dateien beginnen."));
  QToolTip::add(PswEdit, i18n("Das Passwort zum (späteren) Entschlüsseln"));
  QToolTip::add(PswEdit2, i18n("Zur Sicherheit nochmal( wird nur beim Verschlüsseln benötigt )"));
}
/** setup the MainMenu */
void Kryptosf::setupMenu(){
	 QPopupMenu *p = new QPopupMenu;
	 CHECK_PTR( p );

	 OpenAction->plug( p );
	 SaveAction->plug( p );
	 p->insertSeparator();
	 QuitAction->plug( p );

	 menuBar()->insertItem( i18n("&Datei"), p );

	 p = new QPopupMenu;
	 CHECK_PTR( p );

   ToggleAusgabeAct->plug( p );
   ToggleToolbarAct->plug( p );
   ToggleStatusbarAct->plug( p );
   ToggleDirViewAct->plug( p );
	 menuBar()->insertItem( i18n("&Ansicht"), p );

	 p = new QPopupMenu;
	 CHECK_PTR( p );
   p->insertItem(BarIcon ("configure"), i18n("&Kryptos"), this , SLOT(slotConfigMnuClicked()) );
	 ToggleAutoErgAct->plug( p );
	ToggleDeleteOrgAct->plug( p );
	 menuBar()->insertItem( i18n("&Einstellungen"), p );

	 p = helpMenu( i18n( "Kryptos frend - Das Frontend für das KRYPTO Verschlüsselungsprogramm \n"
																		"Version 0.1\n\n"
																		"(c) 2001 SiSch\n"
																		"general_Ossig@web.de"), false );
	 menuBar()->insertItem (i18n( "&Hilfe" ), p);
}
/** No descriptions */
void Kryptosf::readConfig(){
  config = KGlobal::config();
	DirView->readConfig( config, "DirView" );
	config->setGroup( "DirView" );

	KURL url ( config->readEntry( "Directory",
														 "" ) );
	if( !url.isEmpty() )
			DirView->setURL( url, false );

  config->setGroup( "Krypto" );
  Program = config->readEntry( "Program", "" );
  ExtraParameter = config->readEntry( "ExtraParameter", "" );

  //search for the program
  if (!isRightProgram())
    {
		Program = "krypto";

		if (!isRightProgram())
		 {
		FileInfo->setFile ( "../KRYPTO/krypto" );
		Program = FileInfo->absFilePath();

  		if (!isRightProgram())
    		{

			sorry ( i18n ( "Das Verschlüsselungsprogramm Krypto scheint\nnoch nicht konfiguriert zu sein.\n"
									   "Da ich es selbst nicht finden kann, wird der Konfigurations-\ndialog aufgerufen!" ),
								i18n( "Krypto:" ));

			FileInfo->setFile ( "KRYPTO/krypto" );
			Program = FileInfo->absFilePath();

			slotConfigMnuClicked ();
			}
		 }
		}

 config->setGroup( "LastValues" );

 if ( config->readNumEntry( "Ver",  true )  )
     rver->setChecked( true );
 else
	   {
			rent->setChecked(  true );
			PswEdit2->setEnabled( false );
		  r2fach->setEnabled( false );
		  r8fach->setEnabled( false );
		 }

 SlimList = config->readEntry( "SlimList", "" );
 Overwrite->setChecked( config->readNumEntry( "Overwrite", false ) );
 SrcLbx->insertStringList(config->readListEntry( "SrcList", '	' ) , -1);//Separator is tab
 TrgLbx->insertStringList( config->readListEntry( "TrgList", '	' ), -1);//Separator is tab

 for (uint i = 0; i < SrcLbx->count(); i++)
	{
	SrcLbx->changeItem(getSrcIcon( SrcLbx->text( i ) ), SrcLbx->text( i ), i);
	TrgLbx->changeItem( getTrgIcon( TrgLbx->text( i ) ), TrgLbx->text( i ), i);
  }

 config->setGroup( "Ansicht" );
//kryptoausgabe
 bool versteckeAusgabe;
 versteckeAusgabe = config->readBoolEntry( "versteckeAusgabe", false );
 if ( versteckeAusgabe )
		Browser->hide();
 else
		ToggleAusgabeAct->setChecked( true );
//toolbar
 bool versteckeToolBar;
 versteckeToolBar = config->readBoolEntry( "versteckeToolBar", false );
 if ( versteckeToolBar )
		toolBar()->hide();
 else
		ToggleToolbarAct->setChecked( true );
//dirview
 bool versteckeDirView;
 versteckeDirView = config->readBoolEntry( "versteckeDirView", true );
 if ( versteckeDirView )
		DirView->hide();
 else
		ToggleDirViewAct->setChecked( true );
//statusbar
 bool versteckeStatusbar;
 versteckeStatusbar = config->readBoolEntry( "versteckeStatusBar", false );
 if ( versteckeStatusbar )
		statusBar()->hide();
 else
		ToggleStatusbarAct->setChecked( true );

	bool state;
	state = config->readBoolEntry( "Automatische Ergaenzung", true );
	ToggleAutoErgAct->setChecked(	state );

	state = config->readBoolEntry( "Quellen loeschen", false );
	ToggleDeleteOrgAct->setChecked( state );

 config->setGroup( "LastValues" );
 SrcEdit->setText( config->readEntry ( "SourceEdit",  QString (getenv("HOME")) + "/") );
 TrgEdit->setText(  config->readEntry( "TargetEdit", SrcEdit->text() + ".kr" ) );

slotLbxUpdate();
}
/** ListBox Selectionchanged */
void Kryptosf::slotLbxSelChanged( int index ){
_disconnect();

TrgLbx->setSelected( index, true );
SrcLbx->setSelected( index, true );

SrcEdit->setText( SrcLbx->currentText() );
TrgEdit->setText( TrgLbx->currentText() );

r2fach->setChecked( SlimList.ref( index ) == 'j' );
r8fach->setChecked( SlimList.ref( index ) == 'n' );

UpAction->setEnabled( ((uint)index == 0) );
DownAction->setEnabled( ((uint) index == SrcLbx->count() -1 ) );

_reconnect();
}
/** the sourcefile listbox scrollbar changed */
void Kryptosf::SrcLbxScrollbarChanged ( int v){
TrgLbx->verticalScrollBar()->setValue( v );
}
/** No descriptions */
void Kryptosf::TrgLbxScrollbarChanged ( int v ){
SrcLbx->verticalScrollBar()->setValue( v );
}
/** Popupmenu of src and Trg listbox */
void Kryptosf::slotLbxMenu ( QListBoxItem * lbi, const QPoint & point) {
  LbxMenu = new QPopupMenu;
  CHECK_PTR( LbxMenu );

if ( lbi )
  {
	LbxMenu->insertItem(BarIcon("rotate"), i18n( "&Swap" ), this, SLOT( LbxSwap() ));
  LbxMenu->insertItem(BarIcon("editcut"), i18n( "Eintrag a&usschneiden" ), this, SLOT( LbxRemoveItem() ));
  LbxMenu->insertItem(BarIcon("editcopy"), i18n( "Eintrag &kopieren" ), this, SLOT( LbxCopyItem() ));
	}
  PasteAction->plug( LbxMenu );
			PasteAction->setEnabled ( clipboardHasFormat() );

  LbxMenu->insertSeparator();

  LbxMenu->insertItem(i18n( "Swa&p All" ), this, SLOT( LbxSwapAll() ));
  LbxMenu->insertItem(i18n( "&Alle Einträge entfernen" ), this, SLOT( LbxClear() ));	
if ( lbi )
  {
//sort
  if ( lbi->listBox() == SrcLbx )
		  LbxMenu->insertItem(i18n( "Einträge s&ortieren" ), this, SLOT( SrcLbxSort() ));		
  else
		  LbxMenu->insertItem(i18n( "Einträge s&ortieren" ), this, SLOT( TrgLbxSort() ));		
//sort ende
	}


  LbxMenu->exec( point, 0 );
	delete LbxMenu;
}

/** Listboxen clearen */
void Kryptosf::LbxClear(){
SrcLbx->clear();
TrgLbx->clear();
SlimList = "";
}
/** No descriptions */
void Kryptosf::slotBeginAllBtnClicked(){
QString Src, Trg, SrcList = "";

_disable();

  Browser->setText( Browser->text() + i18n( "<b><u><br>neue Session:</u></b><br>" ) );
	totalSteps=0;
	currentStep=0;

for (uint i = 0; i < SrcLbx->count(); i++)
{
Src=SrcLbx->text( i );
Trg=TrgLbx->text( i );

KURL URL( Src );
if (! KIO::NetAccess::download( URL, Src ) )
   {
    sorry ( i18n ( "Quelldatei konnte nicht geöffnet werden:\n" ) + Src, i18n ( "Fehler" ));
		_enable();
    return;
   }

//datei berspringen?
if (Src.at( 0 ) == '#' || Trg.at( 0 ) == '#')
  {
   //do nothing
	}
else
{
FileInfo->setFile( Src );

srcsize=FileInfo->size();

if ( rver->isChecked() )
		srcsize *= r2fach->isChecked() ? 2 : 8;
else
		srcsize /= r2fach->isChecked() ? 2 : 8;

totalSteps += srcsize;

if (!allRight( Src, Trg ))
	 {
	 _enable();
	 statusBar()->message ( "Abbruch...", 2000 );	
	 return;
	 }
}
}

QProgressDialog pdlg( i18n( "Bearbeite:\n" ) + Src,i18n( "&Abbruch" ), totalSteps, this, "Progress Dialog");
connect( this, SIGNAL( fortschrittAktualisieren( int ) ), &pdlg, SLOT( setProgress( int ) ) );
connect( &pdlg, SIGNAL( cancelled() ), this, SLOT( slotCancel() ));

statusBar()->message ( i18n("Arbeite...") );	

timer1->stop();

for (uint i = 0; i < SrcLbx->count(); i++)
{
Src=SrcLbx->text( i );
Trg=TrgLbx->text( i );

//datei berspringen?
if (Src.at( 0 ) == '#' || Trg.at( 0 ) == '#')
  {
	 statusBar()->message( "überspringe Datei " + Src , 2000);
	}
else
{
statusBar()->message ( Src + "..." );	
pdlg.setLabelText( i18n( "Bearbeite:\n" ) + Src );
work ( i, Src, Trg );	
}
}

statusBar()->message ( pdlg.wasCancelled() ? i18n("Abgebrochen") : i18n("Fertig"), 2000 );

_enable();
}

/** Die eigentliche Arbeit fr ne bestimmte Datei erledigen
	  SrcIndex gibt den Index dieser bestimmten Datei innerhalb
	  von SrcLbx an*/
void Kryptosf::work ( int SrcIndex, const QString &theSrc, const QString &Trg  ){

  QString Src = theSrc;

	oFile = new QFile( localPathFromURL( Trg ) );
	if (!oFile->open( IO_WriteOnly))
   {

    sorry ( i18n ( "Outputdatei konnte nicht erstellt werden:\n" ) + oFile->name(), i18n( "Fehler:" ));
    return;
   }

 	Process->clearArguments();
	*Process << Program << Arguments(Src, (SlimList.ref ( SrcIndex ) == 'j'), true );
	Process->start(KProcess::DontCare, KProcess::AllOutput);

	while ( Process->isRunning() )
				 kapp->processEvents();

	oFile->close();
	delete oFile;

	//Quelle lschen?
	if ( ToggleDeleteOrgAct->isChecked() )
	{
	oFile = new QFile( Src );	
   oFile->remove();
	delete oFile;
	}
}

/** checked ob alle Dateien existieren bzw. nicht
 existieren usw. */
bool Kryptosf::allRight ( const QString &theSrc, const QString &theTrg  ){
 QString Trg = theTrg, Src=theSrc;

 QString s = i18n ( "Folgende Fehler sind aufgetreten:\n\n" ), s2;
 int a=0;

 if (( PswEdit->text() != PswEdit2->text() ) && rver->isChecked() )
	{
   a++;
	 s2.sprintf (i18n ( "%d.\n	Die 2. Eingabe des Passworts stimmt\n	nicht mit der 1. überein.\n\n" ), a);
	 s += s2;
	}

 if (PswEdit->text().length() < 6)
	{
   a++;
	 s2.sprintf (i18n ( "%d.\n	Die Länge des Passworts beträgt\n	weniger als 6 zeichen\n\n" ), a);
	 s += s2;
	}

 KURL URL;
 URL.setPath( Src );

 FileInfo->setFile( localPathFromURL( Src ) );
 FileInfo->setFile( FileInfo->absFilePath() );

 if ( !KIO::NetAccess::exists( URL ) && !FileInfo->exists() )
	{
   a++;
	 s2.sprintf (i18n ( "%d.\n	Die Quelldatei(en) existiert nicht\n\n" ), a);
	 s += s2;
	}

 URL.setPath( Trg );

 if (!URL.isLocalFile())
	{
	 sorry ( i18n( "Es können nur lokale Outputdateien erstellt werden:\n" ) + URL.url(),i18n( "Abbruch" ) );
	 return false;
	}

 FileInfo->setFile( localPathFromURL( Trg ) );
 if ((KIO::NetAccess::exists( URL ) || FileInfo->exists() ) && !Overwrite->isChecked())
	{
   a++;
	 s2.sprintf (i18n ( "%d.\n	Die Zieldatei existiert bereits.\n\n" ), a);
	 s += s2;
	}

	//prfen obs berhaupt das richtige Programm ist:
	//evt. Fehlermeldung in Fehlerstring einfgen
	if ( !Programsaidit && !isRightProgram() )
		{
	   a++;
		 s2.sprintf (i18n ( "%d.\n	Das in dem Menu 'Einstellungen->Kryptos'\n	spezifizierte Programm ist nicht\n	das Verschlüsselungsprogramm Krypto!\n\n" ), a);
		 s += s2;
		}

 if (a > 0)
    {
		s += i18n ( "Trotzdem weiter machen?" );
    if ( !question( s,	i18n( "Fehler bei Datei " ) + Src	 ) )
				 return false;
		}
return true;
}
/** No descriptions */
void Kryptosf::LbxSwap(){
_disconnect();

QString NewTrg = SrcLbx->currentText();

SrcLbx->changeItem(getSrcIcon( TrgLbx->currentText() ), TrgLbx->currentText(), SrcLbx->currentItem() );
TrgLbx->changeItem(getTrgIcon( NewTrg ), NewTrg, SrcLbx->currentItem() );

_reconnect();
}
/** swapp all item from SrcLbx to TrgLbx */
void Kryptosf::LbxSwapAll(){
_disconnect();

int curpos = SrcLbx->currentItem();

for (uint i = 0; i < SrcLbx->count(); i++)
	{
	 QString NewTrg ( SrcLbx->text( i ) );
	 SrcLbx->changeItem( getSrcIcon( TrgLbx->text( i ) ), TrgLbx->text( i ), i );
	 TrgLbx->changeItem( getTrgIcon( NewTrg ), NewTrg, i );
	}

SrcLbx->setCurrentItem( curpos );
TrgLbx->setCurrentItem( curpos );
SrcEdit->setText( SrcLbx->currentText() );
TrgEdit->setText( TrgLbx->currentText() );

_reconnect();
}
/** No descriptions */
void Kryptosf::setupToolbar(){
toolBar()->enableMoving( true );
toolBar()->setBarPos ( KToolBar::Floating );
toolBar()->setFullSize( true );

QuitAction->plug( toolBar() );
UpAction->plug( toolBar() );
DownAction->plug( toolBar() );
SwapAction->plug( toolBar() );
RunAction->plug( toolBar() );
RunFolderAction->plug( toolBar() );

toolBar()->insertSeparator();
StopAction->plug( toolBar() );
}

/** No descriptions */
void Kryptosf::slotSlimChanged( int s ){
/*to avoid recursion:*/
_disconnect();

if (  s == 0 )//nicht Slim
   SlimList.replace ( SrcLbx->currentItem(), 1, "n" );
else
   SlimList.replace ( SrcLbx->currentItem(), 1, "j" );

/*reconnect:*/
_reconnect();
}
/** disconnected n par slots um in bestimmten
situationen rekursion zu vermeiden */
void Kryptosf::_disconnect(){
disconnect(SrcLbx, SIGNAL( highlighted( int ) ), this, SLOT( slotLbxSelChanged( int ) ));
disconnect(TrgLbx, SIGNAL( highlighted( int ) ), this, SLOT( slotLbxSelChanged( int ) ));
disconnect(SrcEdit, SIGNAL(textChanged( const QString & )), this, SLOT(slotSrcEditChange (const QString &)));
}
/** receonnected n par slots (siehe _disconect) */
void Kryptosf::_reconnect(){
connect(SrcLbx, SIGNAL( highlighted( int ) ), this, SLOT( slotLbxSelChanged( int ) ));
connect(TrgLbx, SIGNAL( highlighted( int ) ), this, SLOT( slotLbxSelChanged( int ) ));
connect(SrcEdit, SIGNAL(textChanged( const QString & )), this, SLOT(slotSrcEditChange (const QString &)));
}
/** No descriptions */
void Kryptosf::slotTrgEditChange (const QString &file){
_disconnect();

TrgLbx->changeItem( getTrgIcon( file ), file, TrgLbx->currentItem());

_reconnect();
}
/** No descriptions */
QPixmap Kryptosf::getSrcIcon ( QString icon ){
if ( icon.at ( 0 ) == '#' )
	 return BarIcon( "blend" );

if ( rent->isChecked() )
		return BarIcon( "encrypted" );

return PixmapProvider.pixmapFor( icon, 22 );
}

/** No descriptions */
QPixmap Kryptosf::getTrgIcon ( QString icon ){
if ( icon.at ( 0 ) == '#' )
	 return BarIcon( "blend" );

if ( rver->isChecked() )
		return BarIcon( "encrypted" );

return PixmapProvider.pixmapFor( icon, 22 );
}

/** returns the local path from the url if it is local */
QString Kryptosf::localPathFromURL( KURL URL ){
QString result = URL.directory ( false ) + URL.fileName();

//remove evt. protocol ("file"):
if ( result.left( URL.protocol().length() + 1 ) == URL.protocol() + ":" )
result.remove( 0, URL.protocol().length() + 1);

return result;
}
/** No descriptions */
void Kryptosf::slotLbxDoubleClicked( QListBoxItem * ){
_disconnect();

QString text;

text = SrcLbx->currentText();

if ( text.at( 0 ) == '#' )
	  text.remove( 0, 1 );
else
		text = "#" + text;

SrcLbx->changeItem( getSrcIcon( text ), text, SrcLbx->currentItem() );
SrcEdit->setText( text );

text = TrgLbx->currentText();
if ( text.at( 0 ) == '#' )
	  text.remove( 0, 1 );
else
		text = "#" + text;

TrgLbx->changeItem( getTrgIcon( text ), text, TrgLbx->currentItem() );
TrgEdit->setText( text );

_reconnect();
}
/** wird aufgerufen vom session manager */
void Kryptosf::saveProperties ( KConfig* ){
saveConfig();
}

/** speichern der listen */
void Kryptosf::saveLists(){
QString name = KFileDialog::getSaveFileName(0, "*.krl",
																				this,
																				"save Dialog");

if ( name.isEmpty() )
		return;

//evt. dateiendung hinzufgen:
FileInfo->setFile( name );
if ( FileInfo->extension().isEmpty() )
		name += ".krl";

QFile file ( name );
if ( file.exists() )
	{
   bool canOverwrite = question(	i18n( "Die Datei existiert "
																"bereits.\n"
																"Soll sie überschrieben werden?" ),
													i18n( "Datei existiert bereits" )	);

	 if ( !canOverwrite ) return;
	}

if ( !file.open( IO_WriteOnly ) )
	{
	 sorry( i18n( "Die Datei konnte nicht zum schreiben geöffnet werden.\n"
							 "Vieleicht besitzen sie nicht die Berechtigung dazu." ),
				 i18n( "Fehler beim Öffnen von Datei" ) );
	 return;
	}


QTextStream stream( &file );

/*die einzelnen eintrge in den Blcken werden durch '\0'
  getrennt.
	Blcke bestehen aus mehreren eintrgen und werden durch '\1'
	getrennt.
	es gibt den SrcList Block der den Header und die einzelnen
	Eintrge der SrcListe enthlt, sowie den TrgList Block der die
	einzelnen	Eintrge der TrgListe enthlt

	nach lesen des header Eintrags wird die
	SrcList gelesen. Dann der Trglist block
	der letzte Block enthlt die slimlist
*/

//schreibe header Eintrag
stream << kryptosDateiHeader;
//Eintrag Ende:
stream << '\0';

//schreibe Srcblock:
for ( uint i = 0; i < SrcLbx->count(); i++)
		{
		 stream << SrcLbx->text( i );
		 //eintrag ende
		 stream << '\0';
		}

//block ende:
stream << '\1';

//schreibe Trgblock:
for ( uint i = 0; i < TrgLbx->count(); i++)
		{
		 stream << TrgLbx->text( i );
		 //eintrag ende
		 stream << '\0';
		}

//Block ende:
stream << '\1';

//schreibe Slimlist(letzter Block):
stream << SlimList;

//Eintrag ende:
stream << '\0';

//Block ende:
stream << '\1';
file.close();

}
/** enable some widgets after work */
void Kryptosf::_enable(){
	BeginAllBtn->setEnabled( true );
	BeginBtn->setEnabled( true );
	StopAction->setEnabled( false);
}
/** disable some widgets before work */
void Kryptosf::_disable(){
	StopAction->setEnabled( true);
	BeginAllBtn->setEnabled( false );
	BeginBtn->setEnabled( false );
}
/** fragt nach (mittels KMessageBox):
	text ist die Ja/Nein Frage
	caption ist der titel der Messagebox

	returns true wenn ja geantwortet wurde,
	ansonsten false
	 */
bool Kryptosf::question ( QString text, QString caption ){
int rc = KMessageBox::questionYesNo( this,
																 text,
																 caption,
																i18n( "Ja" ),
																i18n( "nein" ));

if ( rc == KMessageBox::No )
	{
	 return false;
	}
else
  {
	 return true;
	}
}
/** siehe KMessageBox::sorry */
void Kryptosf::sorry( QString text, QString caption = "Kryptos frend"){
KMessageBox::sorry (this, text, caption);
}

/** listen laden */
void Kryptosf::loadLists(){
KURL name = KFileDialog::getOpenURL(0, "*.krl",
																				this,
																				"open Dialog");

if ( name.isEmpty() )
		return;

QString strname;
if ( !KIO::NetAccess::download( name, strname ) )
    {
	   sorry( i18n( "Die Datei konnte nicht geöffnet werden.\n"
							 "Vieleicht besitzen sie nicht die Berechtigung dazu." ),
				 i18n( "Fehler beim Öffnen von Datei" ) );

		 return;
		}
QFile file ( strname );

if ( !file.open( IO_ReadOnly ) )
	{
	 sorry( i18n( "Die Datei konnte nicht geöffnet werden.\n"
							 "Vieleicht besitzen sie nicht die Berechtigung dazu." ),
				 i18n( "Fehler beim Öffnen von Datei" ) );
	 return;
	}


QTextStream stream( &file );

/*die einzelnen eintrge in der Datei werden durch '\0'
  getrennt.
	Blcke bestehen aus mehreren eintrgen und werden durch '\1'
	getrennt.
	es gibt den SrcList Block der den Header und die einzelnen
	Eintrge der SrcListe enthlt, sowie den TrgList Block der die
	einzelnen	Eintrge der TrgListe enthlt

	nach lesen des header Eintrags wird die
	SrcList gelesen. Dann der Trglist block
	der letzte Block enthlt die slimlist
*/
QString item;
char chr;

_disconnect();

//lese header
item = "";

stream.readRawBytes ( &chr , 1);
while ( chr != '\0' )
	{
	//korrupt
	if ( stream.atEnd() )
	{
	 sorry( i18n ("Die Datei ist keine Kryptosf-savedatei oder sie ist korrupt") );
	 _reconnect();
	 return;
	}

   //lese nchstes zeichen:
	 item += chr;
	 stream.readRawBytes ( &chr , 1);
	}

if ( item != kryptosDateiHeader )
	{
	 sorry( i18n ("Die Datei ist keine Kryptosf-savedatei oder sie ist korrupt") );
	 _reconnect();
	 return;
	}
//ende header lesen

//aktuelle Listen lschen:
LbxClear();

//lese Rest vom Srcblock
item = "";

stream.readRawBytes ( &chr , 1);
while ( chr != '\1' )
	{
	//korrupt
	if ( stream.atEnd() )
	{
	 sorry( i18n ("Die Datei ist keine Kryptosf-savedatei oder sie ist korrupt") );
	 _reconnect();
	 return;
	}

	 //Eintrag ende
	 if ( chr == '\0' )
		{
		 SrcLbx->insertItem(getSrcIcon( item ), item, -1 );
		 item = "";
		}
   else
   	{
		 item += chr;
		}
   //lese nchstes zeichen:
	 stream.readRawBytes ( &chr , 1);
	}
//ende SrcBlock lesen

//lese Trgblock:
item = "";

stream.readRawBytes ( &chr , 1);
while ( chr != '\1' )
	{
	//korrupt
	if ( stream.atEnd() )
	{
	 sorry( i18n ("Die Datei ist keine Kryptosf-savedatei oder sie ist korrupt") );
	 _reconnect();
	 return;
	}

	 //Eintrag ende
	 if ( chr == '\0' )
		{
		 TrgLbx->insertItem(getTrgIcon( item ), item, -1 );
		 item = "";
		}
   else
   	{
	 item += chr;
		}
   //lese nchstes zeichen:
	 stream.readRawBytes ( &chr , 1);
	}
//ende TrgBlock lesen


//lese SlimListBlock
stream.readRawBytes ( &chr , SrcLbx->count() );
SlimList = &chr;
SlimList = SlimList.left( SrcLbx->count() );
//ende SlimListBlock lesen

SrcLbx->setCurrentItem( 0 );
TrgLbx->setCurrentItem( 0 );

r2fach->setChecked( SlimList.ref( 0 ) == 'j' ? true : false );
r8fach->setChecked( SlimList.ref( 0 ) == 'n' ? true : false );

_reconnect();
file.close();

KIO::NetAccess::removeTempFile( strname );
}


/** sortiere SrcLbx */
void Kryptosf::SrcLbxSort(){
QString text, srctext, trgtext;
setEnabled ( false );
for ( uint i = 0; i < SrcLbx->count() ; i++ )
		{
		text = SrcLbx->text( i ) +
					"	"/*tab separator */+
					SlimList.ref( i ) +
					TrgLbx->text( i );

     SrcLbx->changeItem( text, i );
		}

SrcLbx->sort();
SlimList = "";


for ( uint i = 0; i < SrcLbx->count() ; i++ )
		{
		 text = SrcLbx->text( i );
		 srctext = text.left( text.find( "	" /* tab separator*/ ));
		 SlimList += text.ref( text.find( "	" /* tab separator*/ ) +1 );
		 trgtext = text.right( text.find( "	" /* tab separator*/ ) -2 );

		 SrcLbx->changeItem( getSrcIcon( srctext ), srctext, i);
		 TrgLbx->changeItem( getTrgIcon( trgtext ), trgtext, i);
		}

setEnabled ( true );
}

/** sortiere TrgLbx */
void Kryptosf::TrgLbxSort(){
QString text, srctext, trgtext;
setEnabled ( false );
for ( uint i = 0; i < SrcLbx->count() ; i++ )
		{
		text = TrgLbx->text( i ) +
					"	"/*tab separator */+
					SlimList.ref( i ) +
					SrcLbx->text( i );

     TrgLbx->changeItem( text, i );
		}

TrgLbx->sort();
SlimList = "";

for ( uint i = 0; i < TrgLbx->count() ; i++ )
		{
		 text = TrgLbx->text( i );
		 trgtext = text.left( text.find( "	" /* tab separator*/ ));
		 SlimList += text.ref( text.find( "	" /* tab separator*/ ) +1 );
		 srctext = text.right( text.find( "	" /* tab separator*/ ) -2 );

		 TrgLbx->changeItem( getTrgIcon( trgtext ), trgtext, i);
		 SrcLbx->changeItem( getSrcIcon( srctext ), srctext, i);
		}

setEnabled ( true );
}
/** Ausgabe des kryptoprogramms anzeigen
	oder halt nicht */
void Kryptosf::slotToggleAusgabe(){
if ( Browser->isHidden() )
		Browser->show();
else
		Browser->hide();
}
/** No descriptions */
void Kryptosf::slotToggleToolbar(){
if ( toolBar()->isHidden() )
		toolBar()->show();
else
		toolBar()->hide();
}
/** No descriptions */
void Kryptosf::slotToggleDirView(){
if ( DirView->isHidden() )
		DirView->show();
else
		DirView->hide();
}
/** No descriptions */
void Kryptosf::DirViewFileSelected (const KFileViewItem* kfvi){
QString s = kfvi->urlString();

if ( rent->isChecked() )
		s += ".krd";

SrcLbx->insertItem( getSrcIcon( s ),
									s,
									SrcLbx->currentItem() +1);

SrcLbx->setCurrentItem( SrcLbx->currentItem() +1 );

if ( rver->isChecked() )
		s += ".kr";

TrgLbx->insertItem( getSrcIcon( s ),
									s,
									TrgLbx->currentItem() +1);

TrgLbx->setCurrentItem( TrgLbx->currentItem() +1 );
}

/** popupmenuaction */
void Kryptosf::LbxRemoveItem(){

if ( SrcLbx->count() == 0 )
	 return;

_disconnect();
QString Src=SrcEdit->text(), Trg=TrgEdit->text();
QString cbtext = "";

cbtext += SlimList.ref( SrcLbx->currentItem() );
cbtext += SrcLbx->currentText();
cbtext += '\1'/*separator*/;
cbtext += TrgLbx->currentText();

kapp->clipboard()->setText( cbtext );

SlimList.remove ( SrcLbx->currentItem(), 1 );

SrcLbx->removeItem( SrcLbx->currentItem() );
TrgLbx->removeItem( TrgLbx->currentItem() );

slotLbxUpdate();
_reconnect();
}
/** No descriptions */
void Kryptosf::LbxCopyItem(){
if ( SrcLbx->count() == 0 )
	 return;

QString cbtext;

cbtext = SlimList.ref( SrcLbx->currentItem() );
cbtext += SrcLbx->currentText();
cbtext += '\1'/*separator*/;
cbtext += TrgLbx->currentText();

kapp->clipboard()->setText( cbtext );
}

/** No descriptions */
void Kryptosf::LbxPasteItem(){
QString cbtext = kapp->clipboard()->text();
QString srctext, trgtext;

_disconnect();

SlimList.insert(SrcLbx->currentItem() + 1, cbtext.ref( 0 ) );
cbtext.remove( 0, 1 );

srctext = cbtext.left( cbtext.find ( '\1' /*separator*/ ) );
SrcLbx->insertItem( getSrcIcon( srctext ), srctext, SrcLbx->currentItem() +1);

cbtext.remove ( 0, cbtext.find ( '\1' /*separator*/ ) );

trgtext = cbtext;
TrgLbx->insertItem( getTrgIcon( trgtext ), trgtext, TrgLbx->currentItem() +1 );

slotLbxUpdate();
_reconnect();
}
/** No descriptions */
void Kryptosf::slotLbxUpdate(){

if (	SrcLbx->count() == 0 )
		return;

if ( SrcLbx->currentItem() == -1 )
		SrcLbx->setCurrentItem( SrcLbx->count() );


int currentitem = SrcLbx->currentItem();
SrcLbx->setCurrentItem( -1 );
TrgLbx->setCurrentItem( -1 );


SrcEdit->setText( SrcLbx->currentText() );
TrgEdit->setText( TrgLbx->currentText() );

r2fach->setChecked(
		SlimList.ref( SrcLbx->currentItem() ) == 'j' ? true : false );

r8fach->setChecked(
		SlimList.ref( SrcLbx->currentItem() ) == 'n' ? true : false );
}
/** checked ob Inhalt des Clipboards richtiges Format hat */
bool Kryptosf::clipboardHasFormat(){
QString cbtext = kapp->clipboard()->text();

if ( cbtext.isEmpty() )
	 return false;

if ( cbtext.ref( 0 ) != 'j' &&
		cbtext.ref( 0 ) != 'n' )
		return false;

if ( !cbtext.contains ( '\1'/*separator*/ ) )
		return false;

return true;
}

/** setup the shortcuts */
void Kryptosf::setupActions(){
QuitAction = 	 KStdAction::quit( this, SLOT( close() ) );
		QuitAction->setText( i18n( "&Beenden" ) );
UpAction = new KAction(i18n( "Zeile hoch" ), "up", 0,this, SLOT( LbxUp() ), this );
		UpAction->setEnabled( false );
DownAction = new KAction(i18n( "Zeile runter" ),"down", 0, this, SLOT( LbxDown() ), this );
		DownAction->setEnabled( false );
RunAction= new KAction(i18n( "Datei öffnen" ), "run", 0, this, SLOT( LbxRun() ), this);
RunFolderAction= new KAction(i18n( "Verzeichnis öffnen" ), "folder_new", 0, this, SLOT( LbxRunFolder() ), this);
PasteAction = KStdAction::paste( this, SLOT( LbxPasteItem() ) );
		PasteAction->setText( i18n( "Eintrag &einfügen" ) );
OpenAction = KStdAction::open( this, SLOT( loadLists() ) );
		OpenAction->setText( i18n( "Liste &laden" ) );
SaveAction = KStdAction::save( this, SLOT( saveLists() ) );
		SaveAction->setText( i18n( "Liste &speichern" ) );
ToggleToolbarAct = KStdAction::showToolbar( this, SLOT( slotToggleToolbar() ) );
			ToggleToolbarAct->setText( i18n( "&Toolbar" ) );
ToggleStatusbarAct = KStdAction::showStatusbar( this, SLOT( slotToggleStatusbar() ) );
			ToggleStatusbarAct->setText( i18n( "&Statusbar" ) );
ToggleAusgabeAct = new KToggleAction( i18n( "&Ausgabe des Kryptoprogramms" ), 0, this, SLOT( slotToggleAusgabe() ), this );
ToggleDirViewAct = new KToggleAction( i18n( "&Verzeichnisanzeige" ), 0, this, SLOT( slotToggleDirView() ), this );
SwapAction = new KAction( i18n( "Swap all" ), "rotate", 0, this, SLOT( LbxSwapAll() ), this );
StopAction =new KAction(i18n( "Bearbeitung Abbrechen" ), "stop" , 0, this, SLOT( slotCancel() ), this );
		StopAction->setEnabled( false );

ToggleAutoErgAct = new KToggleAction( i18n( "&Automatisches Ergänzen" ), ALT+Key_E, SrcEdit);
ToggleDeleteOrgAct = new KToggleAction( i18n( "Quelldateien &löschen"  ), ALT+Key_L, this );
}
/** zeile runter */
void Kryptosf::LbxDown(){
if ( SrcLbx->isSelected( SrcLbx->currentItem() ) )
		{
     DownAction->setEnabled( false );
		 return;
		}
TrgLbx->setCurrentItem( SrcLbx->currentItem() );

QString OldSrc = SrcLbx->currentText();
QString OldTrg = TrgLbx->currentText();

  _disconnect();
  SrcLbx->changeItem(
  				getSrcIcon( SrcLbx->text( SrcLbx->currentItem() +1 ) ),
			  		SrcLbx->text( SrcLbx->currentItem() +1 ),
			  			SrcLbx->currentItem() );

  SrcLbx->changeItem(
				getSrcIcon( OldSrc ),
					 OldSrc,
						 SrcLbx->currentItem() +1 );

  TrgLbx->changeItem(
			getSrcIcon( TrgLbx->text( TrgLbx->currentItem() +1 ) ),
				 TrgLbx->text( TrgLbx->currentItem() +1 ),
					 TrgLbx->currentItem() );

  TrgLbx->changeItem(
			getSrcIcon( OldTrg ),
				OldTrg,
					TrgLbx->currentItem() +1 );

	UpAction->setEnabled( ((uint)SrcLbx->currentItem() == SrcLbx->count() -1 ) );
	DownAction->setEnabled( (SrcLbx->currentItem() == 0) );

	_reconnect();	
}
/** Zeile hoch */
void Kryptosf::LbxUp(){
if ( SrcLbx->isSelected( SrcLbx->currentItem() ) )
		{
     UpAction->setEnabled( false );
		 return;
		}
TrgLbx->setCurrentItem( SrcLbx->currentItem() );

QString OldSrc = SrcLbx->currentText();
QString OldTrg = TrgLbx->currentText();

	_disconnect();

  SrcLbx->changeItem(
		getSrcIcon( SrcLbx->text( SrcLbx->currentItem()-1 ) ),
			SrcLbx->text( SrcLbx->currentItem()-1 ),
				 SrcLbx->currentItem() 	);

  SrcLbx->changeItem(
		getSrcIcon( OldSrc ),
			 OldSrc,
					SrcLbx->currentItem() -1 );

  TrgLbx->changeItem(
		getTrgIcon( TrgLbx->text( TrgLbx->currentItem()-1 ) ),
			TrgLbx->text( TrgLbx->currentItem()-1 ),
				 TrgLbx->currentItem() );

  TrgLbx->changeItem(
		getTrgIcon( OldTrg ),
			 OldTrg,
				 TrgLbx->currentItem() -1 );

	UpAction->setEnabled( ((uint)SrcLbx->currentItem() == SrcLbx->count() -1 ) );
	DownAction->setEnabled( (SrcLbx->currentItem() == 0) );

	_reconnect();
}
/** datei ausfhren */
void Kryptosf::LbxRun(){
  QString s;
	if ( rver->isChecked() )
		s =  SrcLbx->currentText();
	else
		s =  TrgLbx->currentText();

  KURL URL ( s );
	FileInfo->setFile( URL.url() );
	if ( !FileInfo->exists() && !KIO::NetAccess::exists( URL ) )
		{
		 sorry( "Datei existiert nicht:\n" + s , "sorry! - kryptosf");	
		 return;
		}
	new KRun ( URL );
}
/** No descriptions */
void Kryptosf::LbxRunFolder(){
  QString s;
	if ( rver->isChecked() )
		s =  SrcLbx->currentText();
	else
		s =  TrgLbx->currentText();

	FileInfo->setFile( s );
  KURL URL ( FileInfo->dirPath() );
	FileInfo->setFile( URL.url() );
	if ( !FileInfo->isDir() && !KIO::NetAccess::exists( URL ) )
		{
		 sorry( "Verzeichnis existiert nicht:\n" + s , "sorry! - kryptosf");	
		 return;
		}
	new KRun ( URL );
}
/** No descriptions */
void Kryptosf::slotToggleStatusbar(){
if ( statusBar()->isHidden() )
		statusBar()->show();
else
		statusBar()->hide();
}
