/***************************************************************************
                          configdialog.cpp  -  description
                             -------------------
    begin                : Mon Dec 24 2001
    copyright            : (C) 2001 by SiSch
    email                : general_ossig@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configdialog.h"

ConfigDialog::ConfigDialog(
                QWidget *parent = 0,
                const char *name = 0) : QDialog (parent, name)
{
   vlayout = new QVBoxLayout (this,  5);
   CHECK_PTR(vlayout);

    KryptoGroup = new QGroupBox (i18n("Das Krypto Programm"), this,  "krypto_group");
   CHECK_PTR(KryptoGroup);

    QVBoxLayout *Boxlayout = new QVBoxLayout(KryptoGroup, 5);
    CHECK_PTR (Boxlayout);
    Boxlayout->addSpacing(15);

    vlayout->addWidget(KryptoGroup);

    QLabel *label = new QLabel(i18n("Pfad:"),  KryptoGroup);
    CHECK_PTR(label);
    label->setMinimumSize(label->sizeHint());

    KryptoEdt = new QLineEdit (this, "krypto_edit");
    CHECK_PTR(KryptoEdt);
    KryptoEdt->setMinimumSize(KryptoEdt->sizeHint());

    KryptoExtraEdt = new QLineEdit (this, "krypto_extra_edit");
    CHECK_PTR(KryptoExtraEdt);
    KryptoExtraEdt->setMinimumSize(KryptoExtraEdt->sizeHint());

    KryptoFindBtn = new QPushButton (BarIcon("find"), i18n("..."), this);
   CHECK_PTR(KryptoFindBtn);
	KryptoFindBtn->setFixedSize(25,25);

    ahlayout = new QHBoxLayout ();
    CHECK_PTR(ahlayout);
    ahlayout->addWidget( label );
    ahlayout->addStretch( );
    Boxlayout->addLayout(ahlayout);

    ahlayout = new QHBoxLayout ();
    CHECK_PTR(ahlayout);
    ahlayout->addSpacing(5);
    ahlayout->addWidget(KryptoEdt);
    ahlayout->addWidget(KryptoFindBtn);

	Boxlayout->addLayout(ahlayout);

    label = new QLabel(i18n("Besondere Argumente:"),  KryptoGroup);
    CHECK_PTR(label);
    label->setMinimumSize(label->sizeHint());

	ahlayout = new QHBoxLayout ();
    CHECK_PTR(ahlayout);
    ahlayout->addWidget( label );
    ahlayout->addStretch( );
    Boxlayout->addLayout(ahlayout);

	ahlayout = new QHBoxLayout ();
    CHECK_PTR(ahlayout);
    ahlayout->addSpacing( 5 );
    ahlayout->addWidget( KryptoExtraEdt );
    ahlayout->addSpacing( 30 );
    Boxlayout->addLayout(ahlayout);

	ahlayout = new QHBoxLayout ();
    CHECK_PTR(ahlayout);

	button1 = new QPushButton ("&Ok",  this);
	CHECK_PTR(button1);
    button1->setMinimumSize(button1->sizeHint());
	ahlayout->addWidget(button1);
	ahlayout->addSpacing(15);
	ahlayout->addStretch();

	button2 = new QPushButton ("&Anwenden",  this);
	CHECK_PTR(button2);
	button2->setMinimumSize(button2->sizeHint());
	ahlayout->addWidget(button2);
	ahlayout->addSpacing(15);
	ahlayout->addStretch();

   button3 = new QPushButton ("A&bbrechen",  this);
  CHECK_PTR(button3);
   button3->setMinimumSize(button3->sizeHint());
   ahlayout->addWidget(button3);

   vlayout->addSpacing(15);
   vlayout->addLayout(ahlayout);

   vlayout->activate();
   resize(0,0);
   vlayout->freeze();
}

void ConfigDialog::showDialog(QString &Program,
							              QString &ExtraParameter)
{
KryptoEdt->setText( Program );
KryptoExtraEdt->setText( ExtraParameter );
show();
}
