/*
     File: khronostatepanel.cpp
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "khronostatepanel.h"
#include "khronotimer.h"
#include <qpainter.h>
#include <stdio.h>

// *** Constructeurs *** //

KhronoStatePanel::KhronoStatePanel( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
  startState=TRUE;
  pauseState=FALSE;
  modeState=TIME;
  laps=MAXLAPS;
  lapTime=new char*[MAXLAPS];
  for(int i=0; i<MAXLAPS; i++) lapTime[i]=0;
}

// *** Evenements *** //

void KhronoStatePanel::paintEvent( QPaintEvent * )
{
  QPainter p;
  p.begin( this );
  paintMode( p );
  paintControls( p );
  paintLaps( p );
  p.end();
}

bool KhronoStatePanel::addLap(const char* time)
{
  if( laps<1 ) return FALSE;
  char *t=new char[strlen(time)];
  strcpy(t, time);
  lapTime[--laps]=t;
  repaint();
  return TRUE;
}

// *** Slots publics *** //

void KhronoStatePanel::setStart(bool started)
{
  if( startState==started ) return;
  startState=started;
  repaint();
}

void KhronoStatePanel::setPause(bool paused)
{
  if( pauseState==paused ) return;
  pauseState=paused;
  repaint();
}

void KhronoStatePanel::setMode(int mode)
{
  if( modeState==mode ) return;
  modeState=mode;
  initLaps();
  repaint();
}

// *** Methodes privees *** //

void KhronoStatePanel::initLaps()
{
  for(int i=0; i<MAXLAPS; i++) {
    if( lapTime[i]!=0 ) delete lapTime[i];
    lapTime[i]=0;
  }
  laps=MAXLAPS;
  repaint();
}

void KhronoStatePanel::paintMode( QPainter &p )
{
  int border=5;
  int offset=border;
  QColorGroup colors=palette().normal();
  QFont font=p.font();
  font.setPointSize(8);
  QFontMetrics fm(font);
  int h=fm.height();
  p.setFont(font);
  if( modeState==TIME ) p.setPen(colors.foreground());
  else p.setPen(colors.dark());
  p.drawText( offset, h, "TIME" );
  if( modeState==CHRONO ) p.setPen(colors.foreground());
  else p.setPen(colors.dark());
  p.drawText( offset, 2*h, "KHRONO" );
  if( modeState==COUNTDOWN ) p.setPen(colors.foreground());
  else p.setPen(colors.dark());
  p.drawText( offset, 3*h, "COUNTDOWN" );
}

void KhronoStatePanel::paintControls( QPainter &p )
{
  QColorGroup colors=palette().normal();
  int w=width();
  int h=height();
  int size=12;
  int inter=5;
  int offset=w/2-size-inter;
  int nb=0;
  // start
  if( startState==TRUE ) {
    p.setPen( colors.foreground() );
    p.setBrush( colors.foreground() );
  } else {
    p.setPen( colors.dark() );
    p.setBrush( colors.dark() );
  }
  QPointArray play;
  play.setPoints( 3, offset+nb*(size+inter),       (h/2-size/2),
                     offset+nb*(size+inter)+size,  (h/2),
		     offset+nb*(size+inter),       (h/2+size/2) );
  p.drawPolygon( play );
  nb++;
  // pause
  if( pauseState==TRUE ) {
    p.setPen( colors.foreground() );
    p.setBrush( colors.foreground() );
  } else {
    p.setPen( colors.dark() );
    p.setBrush( colors.dark() );
  }
  p.drawRect( offset+nb*(size+inter)+size/5, (h/2-size/2), size/5, size );
  p.drawRect( offset+nb*(size+inter)+3*size/5, (h/2-size/2), size/5, size );
  nb++;
}

void KhronoStatePanel::paintLaps(QPainter &p)
{
  int border=5;
  QColorGroup colors=palette().normal();
  QFont font=p.font();
  font.setPointSize(8);
  QFontMetrics fm(font);
  int h=fm.height();
  int w=fm.width("00 00:00:00");
  int offset=width()-w-border;
  p.setFont(font);
  char *s=new char[10];
  for(int i=MAXLAPS-1; i>=0; i--) {
    if( lapTime[i]==0 ) {
      p.setPen(colors.dark());
      sprintf(s, "00 00:00:00");
    } else {
      p.setPen(colors.foreground());
      sprintf(s, "%s", lapTime[i]);
    }
    p.drawText( offset, h*(MAXLAPS-i), s );
  }
  delete s;
}
