/*
     File: khronodisplay.h
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KHRONO_DISPLAY_H
#define KHRONO_DISPLAY_H

#include <qlcdnumber.h>
#include <qdatetime.h>
#include <qlayout.h>

class KhronoStatePanel;
class KhronoTimeDisplay;
class KhronoDateDisplay;

class KhronoDisplay : public QWidget
{
  Q_OBJECT
public:
  KhronoDisplay( QWidget *parent=0, const char *name=0 );
  KhronoTimeDisplay* getTimeDisplay();
  static const QColorGroup* defaultTheme;

signals:
  void lapped();
  void themeChanged(QColorGroup*);

public slots:
  void lap();
  void reset();
  void setTheme(QColorGroup*);

private:
  KhronoTimeDisplay *lcdTime;
  KhronoDateDisplay *lcdDate;
  KhronoStatePanel *statePanel;
  QVBoxLayout *layout;
};

#endif /* KHRONO_DISPLAY_H */
