/*
     File: khronodatedisplay.h
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KHRONO_DATE_DISPLAY_H
#define KHRONO_DATE_DISPLAY_H

#include <qwidget.h>
#include <qdatetime.h>
#include <qpainter.h>

class KhronoDateDisplay : public QWidget
{
  Q_OBJECT
public:
  KhronoDateDisplay( QWidget *parent=0, const char *name=0 );

public slots:
  void setMode(int);
  void setDate(QDate&);
  void setDays(int);

protected:
  virtual void paintEvent( QPaintEvent* );
  virtual void resizeEvent( QResizeEvent* );

private:
  void recomputePointSize();
  void paintDate( QPainter &p );
  void paintDays( QPainter &p );
  int paintDaysLetters( QPainter &p );
  QDate* date;
  int days;
  int modeState;
  int pointSize;
};

#endif /* KHRONO_DATE_DISPLAY_H */
