//----------------------------------------------------------------------------
//    filename             : kbearextmdimainfrm.cpp
//----------------------------------------------------------------------------
//    Project              : Qt MDI extension
//
//    begin                : 07/1999       by Szymon Stefanek as part of kvirc
//                                         (an IRC application)
//    changes              : 09/1999       by Falk Brettschneider to create an
//                           - 06/2000     stand-alone Qt extension set of
//                                         classes and a Qt-based library
//    patches              : 02/2000       by Massimo Morin (mmorin@schedsys.com)
//                           */2000        by Lars Beikirch (Lars.Beikirch@gmx.net)
//
//    copyright            : (C) 1999-2000 by Szymon Stefanek (stefanek@tin.it)
//                                         and
//                                         Falk Brettschneider
//    email                :  gigafalk@yahoo.com (Falk Brettschneider)
//----------------------------------------------------------------------------
//
//----------------------------------------------------------------------------
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU Library General Public License as
//    published by the Free Software Foundation; either version 2 of the
//    License, or (at your option) any later version.
//
//----------------------------------------------------------------------------

#include <qcursor.h>
#include <qclipboard.h>
#include <qobjcoll.h>
#include <qtoolbutton.h>

#include "kbearextmdimainfrm.h"
#include "kbearextmditaskbar.h"
#include "kbearextmdichildfrm.h"
#include "kbearextmdichildarea.h"
#include "kbearextmdichildview.h"

//============ constructor ============//

KBearExtMdiMainFrm::KBearExtMdiMainFrm(QWidget* parentWidget, const char* name, WFlags flags)
: KMainWindow( parentWidget, name, flags)
   ,m_pMdi(0L)
   ,m_pTaskBar(0L)
   ,m_pWinList(0L)
   ,m_pCurrentWindow(0L)
   ,m_pWindowPopup(0L)
   ,m_pTaskBarPopup(0L)
   ,m_pWindowMenu(0L)
   ,m_pDockMenu(0L)
   ,m_pPlacingMenu(0L)
   ,m_pMainMenuBar(0L)
   ,m_bTopLevelMode(false)
   ,m_bMaximizedChildFrmMode(false)
   ,m_oldMainFrmHeight(0)
   ,m_oldMainFrmMinHeight(0)
   ,m_oldMainFrmMaxHeight(0)
{
   setRightJustification( TRUE);

   // Create the local list of windows
   m_pWinList = new QList<KBearExtMdiChildView>;
   m_pWinList->setAutoDelete(FALSE);
   // This seems to be needed (re-check it after Qt2.0 comed out)
   setFocusPolicy(ClickFocus);
   
   // And start creating self
   createMdiManager();
   createTaskBar();
   
   // Apply options for the MDI manager
   applyOptions();

   m_pTaskBarPopup=new QPopupMenu( this, "taskbar_popup_menu");
   m_pWindowPopup=new QPopupMenu( this, "window_popup_menu");

   m_pWindowMenu = new QPopupMenu( this, "window_menu");
   m_pWindowMenu->setCheckable( TRUE);
   QObject::connect( m_pWindowMenu, SIGNAL(aboutToShow()), this, SLOT(fillWindowMenu()) );

   m_pDockMenu = new QPopupMenu( this, "dock_menu");
   m_pDockMenu->setCheckable( TRUE);

   m_pPlacingMenu = new QPopupMenu( this, "placing_menu");
}

//============ ~KBearExtMdiMainFrm ============//
KBearExtMdiMainFrm::~KBearExtMdiMainFrm()
{
   // safely close the windows so properties are saved...
   KBearExtMdiChildView *pWnd = 0L;
   while((pWnd = m_pWinList->first()))closeWindow(pWnd, FALSE); // without re-layout taskbar!
   emit lastChildViewClosed();
   delete m_pWinList;
}

//============ applyOptions ============//
void KBearExtMdiMainFrm::applyOptions()
{
   for(KBearExtMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()){
      QWidget *wdgt = w;
      if(w->mdiParent())wdgt =w->mdiParent();
      // Really ugly hack to FORCE the resize event
      // a resize(width(),height()) won't work...
      wdgt->resize(wdgt->width()+1,wdgt->height()+1);
      wdgt->resize(wdgt->width()-1,wdgt->height()-1);
   }
}

//============ createMdiManager ============//
void KBearExtMdiMainFrm::createMdiManager()
{
   p_mySplitter = new QSplitter( Qt::Vertical, this, "Splitter" );
   m_pMdi = new KBearExtMdiChildArea( p_mySplitter );
	p_mySplitter->setResizeMode ( m_pMdi, QSplitter::Stretch );
	setCentralWidget( p_mySplitter );
   QObject::connect( m_pMdi, SIGNAL(nowMaximized()), this, SLOT(setMaximizeModeOn()) );
   QObject::connect( m_pMdi, SIGNAL(noLongerMaximized(KBearExtMdiChildFrm*)), this, SLOT(setMaximizeModeOff(KBearExtMdiChildFrm*)) );
   QObject::connect( m_pMdi, SIGNAL(sysButtonConnectionsMustChange(KBearExtMdiChildFrm*,KBearExtMdiChildFrm*)), this, SLOT(updateSysButtonConnections(KBearExtMdiChildFrm*,KBearExtMdiChildFrm*)) );
   QObject::connect( m_pMdi, SIGNAL(popupWindowMenu(QPoint)), this, SLOT(popupWindowMenu(QPoint)) );
   QObject::connect( m_pMdi, SIGNAL(lastChildFrmClosed()), this, SIGNAL(lastChildFrmClosed()) );
}

//============ createTaskBar ==============//
void KBearExtMdiMainFrm::createTaskBar()
{
   m_pTaskBar = new KBearExtMdiTaskBar( this );
   m_pTaskBar->show();
   m_pTaskBar->installEventFilter( this);
}

void KBearExtMdiMainFrm::slot_toggleTaskBar()
{
   if(m_pTaskBar->isVisible()){
      m_pTaskBar->hide();
   } else {
      m_pTaskBar->show();
   }
}

////============ closeEvent ============//
//void KBearExtMdiMainFrm::closeEvent(QCloseEvent *e)
//{
//   e->accept();
//   delete this;
//}
//
void KBearExtMdiMainFrm::resizeEvent(QResizeEvent *e)
{
   if( m_bTopLevelMode && ! parentWidget())
      if( e->oldSize().height() != e->size().height()) {
         return;
      }
   QMainWindow::resizeEvent(e);
}

//================ setMinimumSize ===============//

void KBearExtMdiMainFrm::setMinimumSize( int minw, int minh)
{
   if( m_bTopLevelMode && !parentWidget())
      return;
   QMainWindow::setMinimumSize( minw, minh);
}

//================ addWindow ===============//

void KBearExtMdiMainFrm::addWindow( KBearExtMdiChildView* pWnd, int flags)
{
   if( windowExists( pWnd)) {
      // is already added to the MDI system
      return;
   }

   if( flags & KBearExtMdi::ToolWindow) {
      addToolWindow( pWnd);
      // some kind of cascading
      pWnd->move(m_pMdi->mapToGlobal(m_pMdi->getCascadePoint()));

      return;
   }

   QObject::connect( pWnd, SIGNAL(attachWindow(KBearExtMdiChildView*,bool)), this, SLOT(attachWindow(KBearExtMdiChildView*,bool)) );
   QObject::connect( pWnd, SIGNAL(detachWindow(KBearExtMdiChildView*,bool)), this, SLOT(detachWindow(KBearExtMdiChildView*,bool)) );
   QObject::connect( pWnd, SIGNAL(focusInEventOccurs(KBearExtMdiChildView*)), this, SLOT(activateView(KBearExtMdiChildView*)) );
   QObject::connect( pWnd, SIGNAL(childWindowCloseRequest(KBearExtMdiChildView*)), this, SLOT(childWindowCloseRequest(KBearExtMdiChildView*)) );
   QObject::connect( pWnd, SIGNAL(clickedInWindowMenu(int)), this, SLOT(windowMenuItemActivated(int)) );
   QObject::connect( pWnd, SIGNAL(clickedInDockMenu(int)), this, SLOT(dockMenuItemActivated(int)) );

   m_pWinList->append(pWnd);
   KBearExtMdiTaskBarButton* but = m_pTaskBar->addWinButton(pWnd);
   QObject::connect( pWnd, SIGNAL(tabCaptionChanged(const QString&)), but, SLOT(setNewText(const QString&)) );

   if( (flags & KBearExtMdi::Detach) || m_bTopLevelMode) {
      detachWindow( pWnd, false /*bShow*/ ); // false to avoid flickering
   } else {
      attachWindow( pWnd, false /*bShow*/);
   }

   if( flags & KBearExtMdi::Maximize)
      pWnd->maximize();
   if( flags & KBearExtMdi::Minimize)
      pWnd->minimize();
   if( !(flags & KBearExtMdi::Hide)) {
      if( pWnd->isAttached()) {
         pWnd->mdiParent()->show();
      }
      else {
         pWnd->show();
      }
   }
}

//============ addWindow ============//
void KBearExtMdiMainFrm::addWindow( KBearExtMdiChildView* pWnd, QRect rectNormal, int flags)
{
   addWindow( pWnd, flags);
   pWnd->setGeometry( rectNormal);
}


//============ addWindow ============//
void KBearExtMdiMainFrm::addWindow( KBearExtMdiChildView* pWnd, QPoint pos, int flags)
{
   addWindow( pWnd, flags);
   pWnd->move( pos);
}

//============ addWindow ============//
void KBearExtMdiMainFrm::addToolWindow( KBearExtMdiChildView* pWnd)
{
   QRect r = pWnd->geometry();
   pWnd->reparent(this,WType_TopLevel | WStyle_StaysOnTop,r.topLeft(),pWnd->isVisible());
   QObject::connect( pWnd, SIGNAL(childWindowCloseRequest(KBearExtMdiChildView*)), this, SLOT(childWindowCloseRequest(KBearExtMdiChildView*)) );
   m_pWinList->append(pWnd);
   pWnd->m_bToolView = true;
}

//============ attachWindow ============//
void KBearExtMdiMainFrm::attachWindow(KBearExtMdiChildView *pWnd, bool bShow)
{
   // decide whether window shall be cascaded
   bool bCascade = false;
   QRect frameGeo = pWnd->frameGeometry();
   QPoint topLeftScreen = pWnd->mapToGlobal(QPoint(0,0));
   QPoint topLeftMdiChildArea = m_pMdi->mapFromGlobal(topLeftScreen);
   QRect childAreaGeo = m_pMdi->geometry();
   if ( (topLeftMdiChildArea.x() < 0) || (topLeftMdiChildArea.y() < 0) ||
        (topLeftMdiChildArea.x()+frameGeo.width() > childAreaGeo.width()) ||
        (topLeftMdiChildArea.y()+frameGeo.height() > childAreaGeo.height()) ) {
      bCascade = true;
   }

   // create frame and insert child view
   KBearExtMdiChildFrm *lpC=new KBearExtMdiChildFrm(m_pMdi);
   pWnd->hide();
   if (!bCascade) {
      lpC->move(topLeftMdiChildArea);
   }
   lpC->setClient(pWnd);

   lpC->setFocus();
//   if (pWnd->minimumHeight() == pWnd->maximumHeight())
//      lpC->setFixedHeight (lpC->height());
   pWnd->youAreAttached(lpC);
   if( m_bTopLevelMode && !parentWidget()) {
      setMinimumHeight( m_oldMainFrmMinHeight);
      setMaximumHeight( m_oldMainFrmMaxHeight);
      resize( width(), m_oldMainFrmHeight);
      m_oldMainFrmHeight = 0;
      m_bTopLevelMode = false;
      qDebug("TopLevelMode off");
      emit leavedTopLevelMode();
   }

   // this is done in activateView
   //  m_pTaskBar->setActiveButton(pWnd);

   // position and really attach to MDI
   // this should add all the frame stuff but nothing more
   // remove the bShow from here
   m_pMdi->manageChild(lpC,false,bCascade);
   if (bShow) {
      lpC->show();
   }

   // now you set the attribute like position and cascadin/maximize etc...
   // arrangeWindow(pWnd);

   // this will show it...
//   if (bShow) {
//      activateView(pWnd);
//   }
   m_pCurrentWindow  = pWnd;  // required for checking the active item
   QFocusEvent *fe = new QFocusEvent(QEvent::FocusIn);
   QApplication::sendEvent( pWnd, fe);
}

//============= detachWindow ==============//
void KBearExtMdiMainFrm::detachWindow(KBearExtMdiChildView *pWnd, bool bShow)
{

   // ok this part should be fine
   // NOPE! This is not to be set if bshow is FALSE: leave this to the activateView
   //  m_pCurrentWindow  = pWnd;

   pWnd->youAreDetached();

   // see above
   //  m_pTaskBar->setActiveButton(pWnd);

   // this is only if it was attached and you want to detach it
   if(pWnd->parent() != NULL ) {

      KBearExtMdiChildFrm *lpC=pWnd->mdiParent();

      // this one is taking care of te
      lpC->unsetClient( m_undockPositioningOffset);
      m_pMdi->destroyChildButNotItsView(lpC,FALSE); //Do not focus the new top child , we loose focus...
   }
   else {
      if( pWnd->geometry() == QRect(0,0,1,1)) {
         pWnd->setGeometry( QRect( m_pMdi->getCascadePoint(m_pWinList->count()-1), defaultChildFrmSize()));
      }
   }
	pWnd->setMDICaption( pWnd->caption() );

   // there should be an equivalent of manageChild... here
   //

   //  arrangeWindow(pWnd);

   // this will show it...
   if (bShow) {
      activateView(pWnd);
   }
}

//============== removeWindowFromMdi ==============//
void KBearExtMdiMainFrm::removeWindowFromMdi(KBearExtMdiChildView *pWnd)
{
   QObject::disconnect( pWnd, SIGNAL(attachWindow(KBearExtMdiChildView*,bool)), this, SLOT(attachWindow(KBearExtMdiChildView*,bool)) );
   QObject::disconnect( pWnd, SIGNAL(detachWindow(KBearExtMdiChildView*,bool)), this, SLOT(detachWindow(KBearExtMdiChildView*,bool)) );
   QObject::disconnect( pWnd, SIGNAL(focusInEventOccurs(KBearExtMdiChildView*)), this, SLOT(activateView(KBearExtMdiChildView*)) );
   QObject::disconnect( pWnd, SIGNAL(childWindowCloseRequest(KBearExtMdiChildView*)), this, SLOT(childWindowCloseRequest(KBearExtMdiChildView*)) );
   QObject::disconnect( pWnd, SIGNAL(clickedInWindowMenu(int)), this, SLOT(windowMenuItemActivated(int)) );
   QObject::disconnect( pWnd, SIGNAL(clickedInDockMenu(int)), this, SLOT(dockMenuItemActivated(int)) );

   //Closes a child window. sends no close event : simply deletes it
   m_pWinList->removeRef(pWnd);

   KBearExtMdiTaskBarButton* but = m_pTaskBar->getButton(pWnd);
   // changed signale (mmorin)
   QObject::disconnect( pWnd, SIGNAL(tabCaptionChanged(const QString&)), but, SLOT(setNewText(const QString&)) );
   m_pTaskBar->removeWinButton(pWnd);

   if(pWnd->isAttached()) {
      pWnd->mdiParent()->hide();
      m_pMdi->destroyChildButNotItsView(pWnd->mdiParent());
   }

   if(pWnd->isToolView())
      pWnd->m_bToolView = false;
}

//============== closeWindow ==============//
void KBearExtMdiMainFrm::closeWindow(KBearExtMdiChildView *pWnd, bool layoutTaskBar)
{
//UNNECESSARY   QObject::disconnect( pWnd, SIGNAL(attachWindow(KBearExtMdiChildView*,bool)), this, SLOT(attachWindow(KBearExtMdiChildView*,bool)) );
//UNNECESSARY   QObject::disconnect( pWnd, SIGNAL(detachWindow(KBearExtMdiChildView*,bool)), this, SLOT(detachWindow(KBearExtMdiChildView*,bool)) );
//UNNECESSARY   QObject::disconnect( pWnd, SIGNAL(focusInEventOccurs(KBearExtMdiChildView*)), this, SLOT(activateView(KBearExtMdiChildView*)) );
//UNNECESSARY   QObject::disconnect( pWnd, SIGNAL(childWindowCloseRequest(KBearExtMdiChildView*)), this, SLOT(childWindowCloseRequest(KBearExtMdiChildView*)) );
//UNNECESSARY   QObject::disconnect( pWnd, SIGNAL(clickedInWindowMenu(int)), this, SLOT(windowMenuItemActivated(int)) );
//UNNECESSARY   QObject::disconnect( pWnd, SIGNAL(clickedInDockMenu(int)), this, SLOT(dockMenuItemActivated(int)) );

   //Closes a child window. sends no close event : simply deletes it
   m_pWinList->removeRef(pWnd);
   if( m_pWinList->count() == 0L)
      m_pCurrentWindow = 0L;

//UNNECESSARY   KBearExtMdiTaskBarButton* but = m_pTaskBar->getButton(pWnd);
   // Changed signal (mmorin)
//UNNECESSARY   QObject::disconnect( pWnd, SIGNAL(tabCaptionChanged(const QString&)), but, SLOT(setNewText(const QString&)) );
   m_pTaskBar->removeWinButton(pWnd, layoutTaskBar);

   if(pWnd->isAttached())
      m_pMdi->destroyChild(pWnd->mdiParent());
   else
      delete pWnd;

   if( !m_pCurrentWindow)
      emit lastChildViewClosed();
}

//================== findWindow =================//
KBearExtMdiChildView * KBearExtMdiMainFrm::findWindow(const QString& caption)
{
   for(KBearExtMdiChildView *w=m_pWinList->first();w;w=m_pWinList->next()){
      if(QString(w->caption()) == QString(caption))return w;   //F.B.
   }
   return 0L;
}

//================== activeWindow ===================//
KBearExtMdiChildView * KBearExtMdiMainFrm::activeWindow()
{
   return m_pCurrentWindow;
}

//================== windowExists ? =================//
bool KBearExtMdiMainFrm::windowExists(KBearExtMdiChildView *pWnd)
{
   for(KBearExtMdiChildView *w=m_pWinList->first();w;w=m_pWinList->next()){
      if(w == pWnd)return TRUE;
   }
   return FALSE;
}

/*
QPopupMenu * KBearExtMdiMainFrm::windowPopup(KBearExtMdiChildView * pWnd,bool bIncludeTaskbarPopup)
{
   m_pWindowPopup->clear();
   if(bIncludeTaskbarPopup){
      m_pWindowPopup->insertItem(i18n("Window"),taskBarPopup(pWnd,FALSE));
      m_pWindowPopup->insertSeparator();
   }
   return m_pWindowPopup;
}
*/
//================ taskBarPopup =================//
QPopupMenu * KBearExtMdiMainFrm::taskBarPopup(KBearExtMdiChildView *pWnd,bool bIncludeWindowPopup)
{
   //returns the g_pTaskBarPopup filled according to the KBearExtMdiChildView state
   m_pTaskBarPopup->clear();
	if(pWnd->isAttached()){
		m_pTaskBarPopup->insertItem(i18n("Undock"),pWnd,SLOT(detach()));
		m_pTaskBarPopup->insertSeparator();
		if(pWnd->isMinimized() || pWnd->isMaximized())
			m_pTaskBarPopup->insertItem(i18n("Restore"),pWnd,SLOT(restore()));
		if(!pWnd->isMaximized())
			m_pTaskBarPopup->insertItem(i18n("Maximize"),pWnd,SLOT(maximize()));
		if(!pWnd->isMinimized())
			m_pTaskBarPopup->insertItem(i18n("Minimize"),pWnd,SLOT(minimize()));
	}
	else
		m_pTaskBarPopup->insertItem(i18n("Dock"),pWnd,SLOT(attach()));
	m_pTaskBarPopup->insertSeparator();
   m_pTaskBarPopup->insertItem(i18n("Close"),pWnd,SLOT(close()));
   // the window has a view...get the window popup
//   m_pTaskBarPopup->insertSeparator();
//   m_pTaskBarPopup->insertItem(i18n("Operations"),windowPopup(pWnd,FALSE));  //alvoid recursion
   return m_pTaskBarPopup;
   bIncludeWindowPopup = FALSE; // dummy!, only to avoid "unused parameter"
}

void KBearExtMdiMainFrm::activateView(KBearExtMdiChildView *pWnd)
{

   m_pCurrentWindow = pWnd;
   m_pTaskBar->setActiveButton(pWnd);

   if(pWnd->isAttached()){
      if( !(pWnd->hasFocus()) ) {
         // this should go out of here
         // (mmorin)
         if( m_pMdi->topChild()->state() == KBearExtMdiChildFrm::Maximized) {
            updateSysButtonConnections( m_pMdi->topChild(), pWnd->mdiParent());
         }
      }
   }
   else {
      // this was the one not too cool
      // see here you are not doing anything if it is maximize...
      if(!pWnd->hasFocus() || !pWnd->isActiveWindow()) {
         pWnd->show();
         pWnd->setActiveWindow();
         pWnd->raise();
      }
   }
   pWnd->setFocus();
}

void KBearExtMdiMainFrm::taskbarButtonRightClicked(KBearExtMdiChildView *pWnd)
{
   //taskbarButtonLeftClicked( pWnd); // set focus
   activateView( pWnd); // set focus
   taskBarPopup( pWnd, TRUE)->popup( QCursor::pos());
}

void KBearExtMdiMainFrm::childWindowCloseRequest(KBearExtMdiChildView *pWnd)
{
   KBearExtMdiViewCloseEvent* ce = new KBearExtMdiViewCloseEvent( pWnd);
   QApplication::postEvent( this, ce);
}

//##################################################
// Internal handlers
//##################################################

void KBearExtMdiMainFrm::focusInEvent(QFocusEvent *)
{
   //qDebug("KBearExtMdiMainFrm::focusInEvent");
   m_pMdi->setFocus();
}

bool KBearExtMdiMainFrm::event( QEvent* e)
{
   if( e->type() == QEvent::User) {
      KBearExtMdiChildView* pWnd = (KBearExtMdiChildView*)((KBearExtMdiViewCloseEvent*)e)->data();
      if( pWnd != 0L)
         closeWindow( pWnd);
      return TRUE;
   }
   return QMainWindow::event( e);
}

/**
 * close all views
 */
void KBearExtMdiMainFrm::closeAllViews()
{
   for(KBearExtMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()){
      w->close();
   }
}

/**
 * iconify all views
 */
void KBearExtMdiMainFrm::iconifyAllViews()
{
   for(KBearExtMdiChildView *w = m_pWinList->first();w;w= m_pWinList->next()){
      if(!w->isToolView())
         w->minimize();
   }
}

/**
 * closes the view of the active (topchild) window
 */
void KBearExtMdiMainFrm::closeActiveView()
{
   if( m_pCurrentWindow != 0L)
      m_pCurrentWindow->close();
}

/**
 * undocks all view windows (unix-like)
 */
void KBearExtMdiMainFrm::switchToToplevelMode()
{
   QListIterator<KBearExtMdiChildView> it( *m_pWinList);
   for( ; it.current(); ++it) {
      KBearExtMdiChildView* pView = it.current();
      if( pView->isToolView())
         continue;
      if( pView->isAttached()) {
         if( pView->isMaximized())
            pView->mdiParent()->setGeometry( 0, 0, m_pMdi->width(), m_pMdi->height());
         detachWindow( pView, TRUE);
      }
   }
   if(!parentWidget()) {
      m_oldMainFrmMinHeight = minimumHeight();
      m_oldMainFrmMaxHeight = maximumHeight();
      m_oldMainFrmHeight = height();
      if( m_pWinList->count())
         setFixedHeight( height() - m_pMdi->height());
      else  // consider space for the taskbar
         setFixedHeight( height() - m_pMdi->height() + 27);
   }
   m_bTopLevelMode = true;
   qDebug("ToplevelMode on");
}

/**
 * docks all view windows (Windows-like)
 */
void KBearExtMdiMainFrm::switchToChildframeMode()
{
   QListIterator<KBearExtMdiChildView> it( *m_pWinList);
   for( ; it.current(); ++it) {
      KBearExtMdiChildView* pView = it.current();
      if( !pView->isToolView())
         if( !pView->isAttached())
            attachWindow( pView, TRUE);
   }
   if( m_bTopLevelMode && !parentWidget()) {
      setMinimumHeight( m_oldMainFrmMinHeight);
      setMaximumHeight( m_oldMainFrmMaxHeight);
      resize( width(), m_oldMainFrmHeight);
      m_oldMainFrmHeight = 0;
      m_bTopLevelMode = false;
      qDebug("TopLevelMode off");
      emit leavedTopLevelMode();
   }
}

/**
 * redirect the signal for insertion of buttons to an own slot
 * that means: If the menubar (where the buttons should be inserted) is given,
 *             QextMDI can insert them automatically.
 *             Otherwise only signals can be emitted to tell the outside that
 *             someone must do this job itself.
 */
void KBearExtMdiMainFrm::setMenuForSDIModeSysButtons( QMenuBar* pMenuBar)
{
   m_pMainMenuBar = pMenuBar;
   if( m_pMainMenuBar == 0L)
      return;  // use setMenuForSDIModeSysButtons( 0L) for unsetting the external main menu!
   m_pUndock = new QToolButton( pMenuBar);
   m_pRestore = new QToolButton( pMenuBar);
   m_pMinimize = new QToolButton( pMenuBar);
   m_pClose = new QToolButton( pMenuBar);

   setSysButtonsAtMenuPosition();

	QString pathString = KGlobal::dirs()->findResourceDir( "data","kbear/pics/iconify.png" );
   QPixmap* m_pMinButtonPixmap = new QPixmap(pathString+"kbear/pics/iconify.png");
   QPixmap* m_pRestoreButtonPixmap = new QPixmap(pathString+"kbear/pics/restore.png");
   QPixmap* m_pCloseButtonPixmap = new QPixmap(pathString+"kbear/pics/close.png");
   QPixmap* m_pUndockButtonPixmap = new QPixmap(pathString+"kbear/pics/undock.png");

   m_pUndock->hide();
   m_pMinimize->hide();
   m_pRestore->hide();
   m_pClose->hide();

   m_pUndock->setPixmap( *m_pUndockButtonPixmap);
   m_pMinimize->setPixmap( *m_pMinButtonPixmap);
   m_pRestore->setPixmap( *m_pRestoreButtonPixmap);
   m_pClose->setPixmap( *m_pCloseButtonPixmap);
}

void KBearExtMdiMainFrm::setSysButtonsAtMenuPosition()
{
   if( m_pMainMenuBar == 0L)
      return;
   if( m_pMainMenuBar->parentWidget() == 0L)
      return;

   int menuW = m_pMainMenuBar->parentWidget()->width();
   int h = 20;
   int y = m_pMainMenuBar->height()/2-10;

   m_pUndock->setGeometry( ( menuW - ( h * 4) - 5), y, h, h);
   m_pMinimize->setGeometry( ( menuW - ( h * 3) - 5), y, h, h);
   m_pRestore->setGeometry( ( menuW - ( h * 2) - 5), y, h, h);
   m_pClose->setGeometry( ( menuW - h - 5), y, h, h);
}

/** turns the system buttons for maximize mode (SDI mode) on, and connects them with the current child frame */
void KBearExtMdiMainFrm::setMaximizeModeOn()
{
   KBearExtMdiChildFrm* pCurrentChild = m_pMdi->topChild();
   if( !pCurrentChild)
      return;

   m_bMaximizedChildFrmMode = true;
   qDebug("MaximizeMode on");

   // if there is no menubar given, those system buttons aren't possible
   if( m_pMainMenuBar == 0L)
      return;

   QObject::connect( m_pUndock, SIGNAL(clicked()), pCurrentChild, SLOT(undockPressed()) );
   m_pUndock->show();
   QObject::connect( m_pMinimize, SIGNAL(clicked()), pCurrentChild, SLOT(minimizePressed()) );
   m_pMinimize->show();
   QObject::connect( m_pRestore, SIGNAL(clicked()), pCurrentChild, SLOT(maximizePressed()) );
   m_pRestore->show();
   QObject::connect( m_pClose, SIGNAL(clicked()), pCurrentChild, SLOT(closePressed()) );
   m_pClose->show();

   m_pMainMenuBar->insertItem( *pCurrentChild->icon(), pCurrentChild->systemMenu(), -1, 0);
}

/** turns the system buttons for maximize mode (SDI mode) off, and disconnects them */
void KBearExtMdiMainFrm::setMaximizeModeOff(KBearExtMdiChildFrm* oldChild)
{
   if( !oldChild)
      return;

   m_bMaximizedChildFrmMode = true;
   qDebug("MaximizeMode off");

   // if there is no menubar given, those system buttons aren't possible
   if( m_pMainMenuBar == 0L)
      return;

   m_pMainMenuBar->removeItem( m_pMainMenuBar->idAt(0));

   QObject::disconnect( m_pUndock, SIGNAL(clicked()), oldChild, SLOT(undockPressed()) );
   m_pUndock->hide();
   QObject::disconnect( m_pMinimize, SIGNAL(clicked()), oldChild, SLOT(minimizePressed()) );
   m_pMinimize->hide();
   QObject::disconnect( m_pRestore, SIGNAL(clicked()), oldChild, SLOT(maximizePressed()) );
   m_pRestore->hide();
   QObject::disconnect( m_pClose, SIGNAL(clicked()), oldChild, SLOT(closePressed()) );
   m_pClose->hide();
}

/** reconnects the system buttons form maximize mode (SDI mode) with the new child frame */
void KBearExtMdiMainFrm::updateSysButtonConnections( KBearExtMdiChildFrm* oldChild, KBearExtMdiChildFrm* newChild)
{
   // if there is no menubar given, those system buttons aren't possible
   if( m_pMainMenuBar == 0L)
      return;
      
   QObject::disconnect( m_pUndock, SIGNAL(clicked()), oldChild, SLOT(undockPressed()) );
   QObject::disconnect( m_pMinimize, SIGNAL(clicked()), oldChild, SLOT(minimizePressed()) );
   QObject::disconnect( m_pRestore, SIGNAL(clicked()), oldChild, SLOT(maximizePressed()) );
   QObject::disconnect( m_pClose, SIGNAL(clicked()), oldChild, SLOT(closePressed()) );

   QObject::connect( m_pUndock, SIGNAL(clicked()), newChild, SLOT(undockPressed()) );

   QObject::connect( m_pMinimize, SIGNAL(clicked()), newChild, SLOT(minimizePressed()) );
   QObject::connect( m_pRestore, SIGNAL(clicked()), newChild, SLOT(maximizePressed()) );
   QObject::connect( m_pClose, SIGNAL(clicked()), newChild, SLOT(closePressed()) );
}

/** Shows the view taskbar. This should be connected with your "View" menu. */
void KBearExtMdiMainFrm::showViewTaskBar()
{
   m_pTaskBar->show();
}

/** Hides the view taskbar. This should be connected with your "View" menu. */
void KBearExtMdiMainFrm::hideViewTaskBar()
{
   m_pTaskBar->hide();
}

//=============== fillWindowMenu ===============//
void KBearExtMdiMainFrm::fillWindowMenu()
{
   m_pWindowMenu->clear();
   m_pWindowMenu->insertItem(i18n("&Close"), this, SLOT(closeActiveView()));
   m_pWindowMenu->insertItem(i18n("Close &All"), this, SLOT(closeAllViews()));
   m_pWindowMenu->insertItem(i18n("&Iconify All"), this, SLOT(iconifyAllViews()));
   m_pWindowMenu->insertSeparator();
   m_pWindowMenu->insertItem(i18n("&Placing..."), m_pPlacingMenu);
   m_pWindowMenu->insertSeparator();
   m_pWindowMenu->insertItem(i18n("&Dock/Undock..."), m_pDockMenu);
   m_pWindowMenu->insertSeparator();

   m_pPlacingMenu->clear();
   m_pPlacingMenu->insertItem(i18n("Ca&scade windows"), m_pMdi,SLOT(cascadeWindows()));
   m_pPlacingMenu->insertItem(i18n("Cascade &maximized"), m_pMdi,SLOT(cascadeMaximized()));
   m_pPlacingMenu->insertItem(i18n("Expand &vertical"), m_pMdi,SLOT(expandVertical()));
   m_pPlacingMenu->insertItem(i18n("Expand &horizontal"), m_pMdi,SLOT(expandHorizontal()));
   m_pPlacingMenu->insertItem(i18n("A&nodine's tile"), m_pMdi,SLOT(tileAnodine()));
   m_pPlacingMenu->insertItem(i18n("&Pragma's tile"), m_pMdi,SLOT(tilePragma()));
   m_pPlacingMenu->insertItem(i18n("Tile v&ertically"), m_pMdi,SLOT(tileVertically()));

   m_pDockMenu->clear();
   m_pDockMenu->insertItem(i18n("&Toplevel mode"), this, SLOT(switchToToplevelMode()));
   m_pDockMenu->insertItem(i18n("C&hildframe mode"), this, SLOT(switchToChildframeMode()));
   m_pDockMenu->insertSeparator();

   // for all child frame windows: give an ID to every window and connect them in the end with windowMenuItemActivated()
   int i=100;
   KBearExtMdiChildView* pView = 0L;
   QListIterator<KBearExtMdiChildView> it(*m_pWinList);
   for( ; it.current(); ++it) {

      pView = it.current();
      if( pView->isToolView())
         continue;

      QString item;
      // set titles of minimized windows in brackets
      if( pView->isMinimized()) {
         item += "(";
         item += pView->caption();
         item += ")";
      }
      else {
         item += " ";
         item += pView->caption();
       }

      // insert the window entry sorted in alphabetical order
      unsigned int indx;
      unsigned int windowItemCount = m_pWindowMenu->count() - 8;
      bool inserted = FALSE;
      QString tmpString;
      for( indx = 0; indx <= windowItemCount; indx++) {
         tmpString = m_pWindowMenu->text( m_pWindowMenu->idAt( indx+8));
         if( tmpString.right( tmpString.length()-2) > item.right( item.length()-2)) {
            m_pWindowMenu->insertItem( item, pView, SLOT( slot_clickedInWindowMenu()), 0, -1, indx+8);
            m_pDockMenu->insertItem( item, pView, SLOT( slot_clickedInDockMenu()), 0, -1, indx+3);
            if( pView == m_pCurrentWindow)
               m_pWindowMenu->setItemChecked( m_pWindowMenu->idAt( indx+8), TRUE);
            pView->setWindowMenuID( i);
            if( pView->isAttached())
               m_pDockMenu->setItemChecked( m_pDockMenu->idAt( indx+3), TRUE);
            inserted = TRUE;
            indx = windowItemCount+1;  // break the loop
         }
      }
      if( !inserted) {  // append it
         m_pWindowMenu->insertItem( item, pView, SLOT( slot_clickedInWindowMenu()), 0, -1, windowItemCount+8);
         if( pView == m_pCurrentWindow)
            m_pWindowMenu->setItemChecked( m_pWindowMenu->idAt( windowItemCount+8), TRUE);
         pView->setWindowMenuID( i);
         m_pDockMenu->insertItem( item, pView, SLOT( slot_clickedInDockMenu()), 0, -1, windowItemCount+3);
         if( pView->isAttached())
            m_pDockMenu->setItemChecked( m_pDockMenu->idAt( windowItemCount+3), TRUE);
      }
      i++;
   }
}

//================ windowMenuItemActivated ===============//

void KBearExtMdiMainFrm::windowMenuItemActivated(int id)
{
   if( id < 100) return;
   id -= 100;
   KBearExtMdiChildView *pView = m_pWinList->at( id);
   if( !pView) return;
   if( pView->isMinimized()) pView->minimize();
   if( (pView == m_pMdi->topChild()->m_pClient) && pView->isAttached()) return;
   activateView( pView);
}

//================ dockMenuItemActivated ===============//

void KBearExtMdiMainFrm::dockMenuItemActivated(int id)
{
   if( id < 100) return;
   id -= 100;
   KBearExtMdiChildView *pView = m_pWinList->at( id);
   if( !pView) return;
   if( pView->isMinimized()) pView->minimize();
   if( pView->isAttached()) {
      detachWindow( pView, TRUE);
   }
   else {   // is detached
      attachWindow( pView, TRUE);
   }
}

//================ popupWindowMenu ===============//

void KBearExtMdiMainFrm::popupWindowMenu(QPoint p)
{
   m_pWindowMenu->popup( p);
}
