#ifndef KCMDR_H
#define KCMDR_H
#include <qobject.h>
#include <qevent.h>

#define ASK_DIR 1
#define ASK_ITEM 2
#define ASK_HAND 4
#define ASK_EMPTY_HAND 8
#define ASK_TRY_AGAIN 0x100

#define CMD_MOVE_DOWN 'j'
#define CMD_MOVE_UP 'k'
#define CMD_MOVE_LEFT 'h'
#define CMD_MOVE_RIGHT 'l'
#define CMD_MOVE_UPLEFT 'y'
#define CMD_MOVE_UPRIGHT 'u'
#define CMD_MOVE_DOWNLEFT 'b'
#define CMD_MOVE_DOWNRIGHT 'n'
#define CMD_QUIT 'Q'
#define CMD_SAVE 'S'
#define CMD_INV 'i'
#define CMD_CALL 'c'
#define CMD_WIZ '\x17'
#define CMD_HELP '?'

struct cmd
{
  int cmdid, ask;
  int mask;
  const char *q;
};

extern cmd r_cmdtable[];
extern int ccmd, cmd_count;
extern int cmd_ask;
extern int direction, item, hand;
#define NCMD (sizeof(r_cmdtable)/sizeof(r_cmdtable[0]))

struct obj;
class KConfig;

class KCmdr:public QObject
{
  Q_OBJECT
public:
  KCmdr();
  virtual ~KCmdr();
  virtual int getDirection(QKeyEvent *k);
  virtual void getCmd(QKeyEvent *k);
  virtual void checkCmd(void);
  virtual void execCmd(void);
  virtual void cmdLoop(void);
  virtual void command(int _cmd, int _item=0, int _direction=0, int _hand=0);
  virtual void newmsg(int enable, int more=false);
  virtual void disableCmds(void);
  virtual void enableCmds(void);
  virtual void restart(void);
  virtual void reset(bool b) {ccmd=cmd_ask=cmd_count=0; if (b) newmsg(1);}
  virtual void saveProperties(KConfig *);
  virtual void readProperties(KConfig *);
  virtual void interpretKey(QKeyEvent *k);
  virtual void check();
  virtual void writeCfg(KConfig *);
  virtual bool readOnly(void) {return ro;}
  virtual void setReadOnly(bool b);

  int cmd_executed;
  bool running;

protected:
  int cmds;
  int armor, lring, rring, stairs;
  int rgr, rcol;
  bool ro;
public slots:
  void run();
  void eat();
  void eat(int i);
  void read();
  void read(int i);
  void wield();
  void wield(int i);
  void quaff();
  void quaff(int i);
  void throwsl();
  void throwsl(int i);
  void drop();
  void drop(int i);
  void zap();
  void zap(int i);
  void wear();
  void wear(int i);
  void putonr(int i);
  void putonl(int i);
  void puton();
  void puton(int i);
  void lremr();
  void rremr();
  void remove();
  void takeoff();
  void idtrap();
  void restbt();
  void searchbt();
  void downstair();
  void upstair();
  void call();
  void call(int i);
  void nitem();
  void showinv();
  void showlinv();
signals:
  void roguePosChanged(int row, int col);
  void newlevel();
  void quit();
  void wizard();
  void help();
  void inCommand(bool);
  void enableButtons(bool);
  void noArmor();
  void wearsArmor();
  void noLRing();
  void putLRing(struct obj *name);
  void noRRing();
  void putRRing(struct obj *name);
  void onStairs(bool);
  void isRunning(bool);
};

extern KCmdr *cmdr;

#endif
