/***************************************************************************
                          dlgoptionpreferences.cpp
                            -------------------
    begin                : Sat Sep 11 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>

#include "dlgoptionpreferences.h"


DlgOptionPreferences::DlgOptionPreferences(QWidget *parent, const char *name)
 : QTabDialog(parent,name, true)
{

	setCaption(i18n("Preferences"));

	generalTab = new DlgOptionGeneral(this,"General");
	echoTab = new DlgOptionEcho(this,"Echo");
	historyTab = new DlgOptionHistory(this,"History");
	inputTab = new DlgOptionsInput(this, "Input");
	timingTab = new DlgOptionTiming(this, "Timing");

	addTab(generalTab,i18n("General"));
	addTab(echoTab,i18n("Echo"));
	addTab(historyTab,i18n("History"));
	addTab(inputTab, i18n("Input settings"));
	addTab(timingTab, i18n("Timing"));

	setOkButton(i18n("OK"));
	setDefaultButton(i18n("Default"));
	setCancelButton(i18n("Cancel"));

	connect(this, SIGNAL(applyButtonPressed()), SLOT(slotOKPressed()));
	connect(this, SIGNAL(defaultButtonPressed()), SLOT(slotDefaultPressed()));

	this->resize(380,330);

	slotDefaultPressed();

}


DlgOptionPreferences::~DlgOptionPreferences(){

	// no need to delete widgets that are children of this class
	// since they will be destroyed when destroying the parent
	// see: ~QObject()
}

void DlgOptionPreferences::slotOKPressed(){

}

void DlgOptionPreferences::slotDefaultPressed()
{

// the "Default" button should affect _all_ tabs.
// it's on the dialog and not the tab and the OK button affects all tabs, too.
// see also: http://world.std.com/~uieweb/tabbed.htm

	// General Group
	setKeepLastInput(false);
  setUseBeep(true);
 	setIntelligentHistory(false);
  setNumpadMacros(true);
	setSelectAllOnFocus(false);

	// set Default Values in the Memory Tab
	setInputSize(1000);
	setOutputSize(5000);
	setSharedInputHistory(false);

	// set Default Values in the Echo Tab
	setLocalEchoMode(2);
	setLocalEchoSuppressNewline(false);
	setInputEchoMode(2);

	// set Default Values in the Input Tab
	// Special Character Group
	setEnableSpecialChars(true);
	setExternChar("#");
	setSeparator(";");
	setSpeedwalkingChar(".");

	// set Default Values in the Timing Tab
	// Auto Reconnect Group
	setAutoReconnect(true);
	setAutoTime(10);
  // Output Notification Group
  setOutputNotifyOn(true);
  setOutputNotifySeconds(10);
  // Connection TimeOut Group
  setConnectTimeoutSeconds(10);

}

int DlgOptionPreferences::getLocalEchoMode()
{
	return echoTab->getLocalEchoMode();
}

bool DlgOptionPreferences::getLocalEchoSuppressNewline()
{
	return echoTab->getLocalEchoSuppressNewline();
}

int DlgOptionPreferences::getInputEchoMode()
{
	return echoTab->getInputEchoMode();
}

int DlgOptionPreferences::getInputSize()
{
	return historyTab->getInputSize();
}

int DlgOptionPreferences::getOutputSize()
{
	return historyTab->getOutputSize();
}

bool DlgOptionPreferences::getSharedInputHistory()
{
	return historyTab->getSharedInputHistory();
}

void DlgOptionPreferences::setSharedInputHistory(bool b)
{
	historyTab->setSharedInputHistory(b);
}

void DlgOptionPreferences::setLocalEchoMode(int i)
{
	echoTab->setLocalEchoMode(i);
}

void DlgOptionPreferences::setLocalEchoSuppressNewline(bool b)
{
	echoTab->setLocalEchoSuppressNewline(b);
}

void DlgOptionPreferences::setInputEchoMode(int i)
{
	echoTab->setInputEchoMode(i);
}


void DlgOptionPreferences::setInputSize(int i)
{
	historyTab->setInputSize(i);
}

void DlgOptionPreferences::setOutputSize(int i)
{
	historyTab->setOutputSize(i);
}

bool DlgOptionPreferences::getKeepLastInput()
{
	return generalTab->getKeepLastInput();
}


/** gets the autoreconnect timer start value */
unsigned int DlgOptionPreferences::getAutoTime()
{
	return timingTab->getAutoTime();
}

/** sets the autoreconnect timer start value */
void DlgOptionPreferences::setAutoTime(unsigned int t)
{
	timingTab->setAutoTime(t);
}

void DlgOptionPreferences::setKeepLastInput(bool b)
{
	generalTab->setKeepLastInput(b);
}

bool DlgOptionPreferences::getAutoReconnect()
{
	return timingTab->getAutoReconnect();
}

void DlgOptionPreferences::setAutoReconnect(bool b)
{
	timingTab->setAutoReconnect(b);
}



bool DlgOptionPreferences::getEnableSpecialChars()
{
	return inputTab->getEnableSpecialChars();
}

void DlgOptionPreferences::setEnableSpecialChars(bool b)
{
	inputTab->setEnableSpecialChars(b);
}

QString DlgOptionPreferences::getSeparator()
{
	return inputTab->getSeparator();
}

void DlgOptionPreferences::setSeparator(QString s)
{
	inputTab->setSeparator(s);
}

/** returns the character, taht starts a speedwalking-sequence */
QString DlgOptionPreferences::getSpeedwalkingChar()
{
	return inputTab->getSpeedwalkingChar ();
} // getSpeedwalkingChar

/** sets the character, that starts a speedwalking-sequence */
void DlgOptionPreferences::setSpeedwalkingChar (QString s)
{
	inputTab->setSpeedwalkingChar (s);
} // setSpeedwalkingChar

/** set's the external command char */
void DlgOptionPreferences::setExternChar (QString externChar)
{
	inputTab->setExternChar (externChar);
} // setExternChar

/** returns the external command char */
QString DlgOptionPreferences::getExternChar()
{
	return inputTab->getExternChar ();
} // getExternChar


void DlgOptionPreferences::setUseBeep(bool b) {
	generalTab->setUseBeep(b);
}

bool DlgOptionPreferences::getUseBeep() {
	return generalTab->getUseBeep();
}

void DlgOptionPreferences::setOutputNotifyOn(bool b)
{
	timingTab->setOutputNotifyOn(b);
}

bool DlgOptionPreferences::getOutputNotifyOn()
{
	return timingTab->getOutputNotifyOn();
}

void DlgOptionPreferences::setOutputNotifySeconds(unsigned int sec)
{
	timingTab->setOutputNotifySeconds(sec);
}

unsigned int DlgOptionPreferences::getOutputNotifySeconds()
{
	return timingTab->getOutputNotifySeconds();
}

/** gets the ConnectionTimeout */
unsigned int DlgOptionPreferences::getConnectTimeoutSeconds()
{
	return timingTab->getConnectTimeoutSeconds();
}
/** sets the ConnectionTimeout */
void DlgOptionPreferences::setConnectTimeoutSeconds(unsigned int t)
{
	timingTab->setConnectTimeoutSeconds(t);
}

/** set's the intelligent history */
void DlgOptionPreferences::setIntelligentHistory(bool i)
{
	generalTab->setIntelligentHistory(i);
} // setIntelligentHistory

/** returns the status of the intelligent history feature */
bool DlgOptionPreferences::getIntelligentHistory()
{
	return generalTab->getIntelligentHistory();
} // getIntelligentHistory

/** enables or disables the keypad-macros */
void DlgOptionPreferences::setNumpadMacros(bool b)
{
	generalTab->setNumpadMacros(b);
} // setkeypadMacros

/** returns true if the Numpad-Macros are enabled */
bool DlgOptionPreferences::getNumpadMacros()
{
	return generalTab->getNumpadMacros();
} // getNumpadMacros

void DlgOptionPreferences::setSelectAllOnFocus(bool b)
{
	generalTab->setSelectAllOnFocus(b);
}

bool DlgOptionPreferences::getSelectAllOnFocus()
{
	return generalTab->getSelectAllOnFocus();
}

/** Sets data associated to ping configuration */
void DlgOptionPreferences::setPingData(QString path, bool enabled)
{
  generalTab->setPingData(path, enabled);
}

/** returns the path (including  filename) */
QString DlgOptionPreferences::getPingPath()
{
  return generalTab->getPingPath();
}

/** returns true if ping should be enabled */
bool DlgOptionPreferences::getPingEnabled()
{
  return generalTab->getPingEnabled();
}
