// Local includes
#include "database.h"
#include "databaseresource.h"

// Stdlib includes
#include <iostream.h>
#include <bool.h>

Database::Database()
{
  fDBOpen = dbNotOpen;
}


Database::~Database()
{
  if (fDBOpen != dbNotOpen)
    {
      fDBOpen = dbNotOpen;
      closeDB();
    }
}

bool Database::openDB(char* name, dbOpenType flag)
{
  if (fDBOpen != dbNotOpen)
    closeDB();

  switch (flag)
    {
    case dbOpenReadWrite:
      fDatabase = gdbm_open(name, 512, GDBM_WRCREAT, 0666, NULL);
      break;

    case dbOpenRead:
      fDatabase = gdbm_open(name, 512, GDBM_READER, 0666, NULL);
      break;

    default:
      fDatabase = NULL;
      break;
    }

  if (fDatabase == NULL)
    {
      DATABASE_ERROR("The database could not be opened with desired access.");
      return FALSE;
    }
 
  fDBOpen = flag;
  return TRUE;
}

void Database::closeDB()
{
  if (fDBOpen != dbNotOpen)
    {
      fDBOpen = dbNotOpen;
      gdbm_close(fDatabase);
    }
  
  else
    {
      DATABASE_ERROR("Attempted to close database but it was never opened.");
    }
}

dbOpenType Database::openDBType()
{
  return fDBOpen;
}

int Database::storeData(DATA_TYPE key, DATA_TYPE content, insertionPolicy flag)
{
  int success = 0 ;

  if (fDBOpen != dbOpenReadWrite)
    {
      DATABASE_ERROR("Attempted to store to the database but it was never opened or opened in read only.");
      return -1;

    }
  
  switch (flag)
    {
    case dbInsertNoReplace:
      success = gdbm_store(fDatabase, key, content, GDBM_INSERT);
      break;

    default:  // dbInsertReplace
      success = gdbm_store(fDatabase, key, content, GDBM_REPLACE);
      break;
    }
  
  return success;
      
}

DATA_TYPE Database::fetchData(DATA_TYPE key)
{
  datum datumStruct;

  if (fDBOpen == dbNotOpen)
    {
      DATABASE_ERROR("Attempted to fetch from the database but it was never opened.");
      datumStruct.dptr = NULL;
      return datumStruct;
    }
  
  return gdbm_fetch(fDatabase, key);
}

int Database::deleteData(DATA_TYPE key)
{
  if (fDBOpen != dbOpenReadWrite)
    {
      DATABASE_ERROR("Attempted to delete an item in the database but it was never opened.");
      return -1;
    }

  return gdbm_delete(fDatabase, key);
}

DATA_TYPE Database::firstKey()
{
  datum datumStruct;

   if (fDBOpen == dbNotOpen)
    {
      DATABASE_ERROR("Attempted to fetch first key from the database but it was never opened.");
      datumStruct.dptr = NULL;
      return datumStruct;
    }

   return gdbm_firstkey(fDatabase);

}

DATA_TYPE Database::nextKey(DATA_TYPE key)
{
  datum datumStruct;

   if (fDBOpen == dbNotOpen)
    {
      DATABASE_ERROR("Attempted to fetch next key from the database but it was never opened.");
      datumStruct.dptr = NULL;
      return datumStruct;
    }
  
   return gdbm_nextkey(fDatabase, key);
}

int Database::reorganize()
{
  if (fDBOpen == dbNotOpen)
    {
      DATABASE_ERROR("Attempted to reorganize the database but it was never opened.");
      return -1;
    }

  return gdbm_reorganize(fDatabase);
}

void Database::sync()
{
  if (fDBOpen == dbNotOpen)
    {
      DATABASE_ERROR("Attempted to sync the database but it was never opened.");
      return;
    }

  gdbm_sync(fDatabase);
}

int Database::exists(DATA_TYPE key)
{
   if (fDBOpen == dbNotOpen)
    {
      DATABASE_ERROR("Attempted to check if a key exists in the database but it was never opened.");
      return FALSE;
    }

   return gdbm_exists(fDatabase, key);
}

