/***************************************************************************
                          lost_treenode.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Jun 5 1999                                           
    copyright            : (C) 1999 by jec                         
    email                : cuendet@linkvest.ch                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qlistview.h>
#include <qmessagebox.h>

#include <kmsgbox.h>

#include "lost_treenode.h"
#include "lostview.h"



LoST_TreeNode::LoST_TreeNode(LoSTView& parent, const QString& dir, e_Type type)
	:QListViewItem(&parent),
	filesNode_(0),
	view_(parent),
	myDir_(dir),
	type_(type),
	size_(0),
	needSizeUpdate_(true)
{
}

LoST_TreeNode::LoST_TreeNode(QListViewItem* parent, LoSTView& view, const QString& dir, e_Type type)
	:QListViewItem(parent),
	filesNode_(0),
	view_(view),
	myDir_(dir),
	type_(type),
	size_(0),
	needSizeUpdate_(true)
{
}

LoST_TreeNode::~LoST_TreeNode()
{
}

void LoST_TreeNode::setSymbolicLink(const QString& link)
{
	link_ = link;
}

const char* LoST_TreeNode::key(int column, bool ascending) const
{
	static QString key;
	
	key = "";
	switch(view_.getSortOption())
	{
	case LoSTView::SIZE:
		{
			int64_t size = ((LoST_TreeNode*)this)->getSize();
			if (ascending)
			{
				key.sprintf( "%017d",  size);
			}
			else
			{
				key.sprintf( "%017d", size);
				for (int i=0;i<key.length();i++)
				{
					char c = key[i];
					key[i] = 90-c;
				}
			}
		}
		break;
	case LoSTView::NAME:
	default:
		if (getType() == FILES)
		{
			/*
			QString nbFiles;
			nbFiles.setNum( childCount() );
			key = nbFiles + " " + myDir_;
			*/
			key = "zzzzzzzzzzzzzzzzzzzzz";
		}
		else
		{
			if (ascending)
			{
				key = myDir_;
			}
			else
			{
				const char* c = myDir_;
				key = c;
				for (uint i=0;i<key.length();i++)
				{
					char c = key[i];
					key[i] = (char)(188-c);
				}
			}
		}
		break;
	};
	
	const char* k = key;
	QString temp = getCompletePath();
	const char* d = temp;
	if (ascending) printf("ASC: "); else printf("DESC: ");
	printf("'%s' -> '%s'\n", d, k);
	return key;
}

const char* LoST_TreeNode::text(int col) const
{
	return ((LoST_TreeNode*)this)->getText(col);
}

void LoST_TreeNode::setFilesNode(LoST_TreeNode* node)
{
	filesNode_ = node;
}
	
LoST_TreeNode* LoST_TreeNode::getFileThatMatch(const QString& str)
{
	if (filesNode_ != 0)
	{
		LoST_TreeNode* child = (LoST_TreeNode*)filesNode_->firstChild();
		while (child != 0)
		{
			if (child->getPath() == str)
			{
				return child;
			}
			child = (LoST_TreeNode*)child->nextSibling();
		}
	}
	else
	{
		QMessageBox::warning(0, "", "The filesNode is NULL");
	}
	return 0;
}

LoST_TreeNode* LoST_TreeNode::getChildThatMatch(const QString& str)
{
	LoST_TreeNode* child = (LoST_TreeNode*)firstChild();
	while (child != 0)
	{
		if (child->getPath() == str)
		{
			return child;
		}		
		child = (LoST_TreeNode*)child->nextSibling();
	}
	return 0;
}

void LoST_TreeNode::removeDir(LoST_TreeNode* node)
{
	QString temp;
	if (node->getFilesNode() == 0)
	{
		KMsgBox::message(0, "", "filesNode_ is NULL. Not removing.");
		return;
	}
	
	if (node->childCount() == 1)
	{
		if (node->getFilesNode()->childCount() == 0)
		{
			QString path = node->getCompletePath();
			//temp.sprintf("No files in %s. Removing.", path.data());
			//KMsgBox::message(0, "", temp);
			
			removeItem(node);
		}
		else
		{
			/*
			QString temp;
			temp.sprintf("<%s> was not removed. #Node: <%d> Files: <", node->getCompletePath().data(), node->childCount());
			LoST_TreeNode* achild = (LoST_TreeNode*)node->getFilesNode()->firstChild();
			while(achild != 0)
			{
				temp += " <";
				temp += achild->getPath();
				temp += ">";
				achild = (LoST_TreeNode*)achild->nextSibling();
			}
			temp += " >";
			KMsgBox::message(0, "", temp);
			*/
		}
	}
	else
	{
		//KMsgBox::message(0, "", "There is more than one child");
	}
	setNeedSizeUpdateRecurse();
}

void LoST_TreeNode::removeFile(LoST_TreeNode* node)
{
	if (filesNode_ != 0)
	{
		filesNode_->removeItem(node);
		setNeedSizeUpdateRecurse();
	}
}

LoST_TreeNode* LoST_TreeNode::getFilesNode()
{
	return filesNode_;
}

LoST_TreeNode* LoST_TreeNode::getParent()
{
	return (LoST_TreeNode*)parent();
}
	
const QPixmap* LoST_TreeNode::pixmap( int column ) const
{
	if (isOpen())
	{
		return view_.getPixmap(type_, true);
	}
	else
	{
		return view_.getPixmap(type_, false);
	}
}

const char* LoST_TreeNode::getText(int col)
{
	static QString text;
	ASSERT(col == 0);
	QString sizeText;
	getSizeText(sizeText);
	switch(type_)
	{
	case FILES:
		{
			QString nbFiles;
			nbFiles.setNum( childCount() );
			text = "  " + sizeText + "   " + nbFiles + " " + myDir_;
		}
		break;
	case SKIPPED:
		text = "  " + myDir_ + " -> Skipped";
		break;
	case SYM_LINK:
		text = "  " + myDir_ + " -> " + link_;
		break;
	default:
		text = "  " + sizeText + "   " + myDir_;
		break;
	};
	return text;
}

void LoST_TreeNode::getSizeText(QString& sizeString)
{
	QString temp;
	sizeString = "";
	int64_t size = getSize();
	switch(view_.getViewOption())
	{
	case LoSTView::REAL_SIZE:
		// Nothing to do
		break;
	case LoSTView::USED_SIZE:
		{
			double d = (double)size / (double)4096;
			if (d != (int)d)
			{
				size = (( (int)d )+1) * 4096;
			}
		}
		break;
	case LoSTView::PERCENT:
		if (getParent() == 0)
		{
			size = 100;
		}
		else
		{
			size = (int)((double)getSize() / (double)(getParent()->getSize()) * 100);
		}
		break;
	};
	
	switch(view_.getViewOption())
	{
	case LoSTView::REAL_SIZE:
	case LoSTView::USED_SIZE:
		{
			if (size < 1024)
			{
				temp.sprintf("%4d", size);
				sizeString = temp + " bytes";
			}
			else if(size < 1024*1024) // less than 1Mb
			{
				double s = (double)size / (double)1024;
				temp.sprintf("%6.1f", s);
				sizeString = temp + " Kb";
			}
			else // more than 1Mb
			{
				double s = ((double)size / (double)(1024*1024));
				temp.sprintf("%5.2f", s);
				sizeString = temp +" Mb";
			}
		}
		break;
	default:
		temp.sprintf("%3d", size);
		sizeString = temp + " %";
		break;
	};
	
}

const QString& LoST_TreeNode::getPath()
{
	return myDir_;
}

QString LoST_TreeNode::getCompletePath()
{
	QString dir;
	LoST_TreeNode* p = getParent();
	if (p != 0)
	{
		dir = p->getCompletePath();
		dir += "/";
	}
	dir += myDir_;
	return dir;
}

LoST_TreeNode::e_Type LoST_TreeNode::getType() const
{
	return type_;
}

void LoST_TreeNode::setType(LoST_TreeNode::e_Type t)
{
	type_ = t;
}

int64_t LoST_TreeNode::getSize()
{
	switch( getType() )
	{
	case SYM_LINK:
		needSizeUpdate_ = false;
		return 0;
	default:
		if (needSizeUpdate_)
		{
			size_ = 0;
			LoST_TreeNode* child = (LoST_TreeNode*)firstChild();
			while(child)
			{
				size_ += child->getSize();
				child = (LoST_TreeNode*)child->nextSibling();
			}
			needSizeUpdate_ = false;
		}
		return size_;
	}
}

void LoST_TreeNode::setSize(int64_t size)
{
	size_ = size;
	needSizeUpdate_ = false;
}

void LoST_TreeNode::setNeedSizeUpdate(bool val)
{
	if (type_ != FILE)
	{
		needSizeUpdate_ = val;
	}
}

void LoST_TreeNode::setNeedSizeUpdateRecurse()
{
	setNeedSizeUpdate(true);
	LoST_TreeNode* p = getParent();
	if (p != 0)
	{
		p->setNeedSizeUpdateRecurse();
	}
}














































