/***************************************************************************
                          lost.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Jun  5 13:37:40 CEST 1999
                                           
    copyright            : (C) 1999 by jec                         
    email                : cuendet@linkvest.ch                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <lost.h>
#include <qfiledialog.h>
#include <qmessagebox.h>

#include <kfiledialog.h>



LoSTApp::LoSTApp()
	:view_(0)
{
  setCaption("LoST - the LOst Space Tracker V" VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!viewToolbar_)
    enableToolBar(KToolBar::Hide,0);
  if (!viewStatusbar_)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menubarPos_);
  toolBar()->setBarPos(toolbarPos_);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup

}

LoSTApp::~LoSTApp()
{
}

void LoSTApp::closeEvent(QCloseEvent* e)
{
	if (this->queryExit(false))
	{
		saveOptions();
		KTMainWindow::closeEvent(e);
	}
}

void LoSTApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void LoSTApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void LoSTApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu_
  fileMenu_ = new QPopupMenu();
  fileMenu_->insertItem(Icon("filenew.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  fileMenu_->insertSeparator();
  fileMenu_->insertItem(Icon("findf.xpm"), i18n("&Choose dir"), ID_FILE_CHOOSE_DIR );
  fileMenu_->insertItem(Icon("reload.xpm"), i18n("&Update"), ID_FILE_UPDATE );
  fileMenu_->insertItem(Icon("stop.xpm"), i18n("&Stop update"), ID_FILE_STOP_UPDATE );
  fileMenu_->insertSeparator();
  fileMenu_->insertItem(i18n("C&lose Window"), ID_FILE_CLOSE_WINDOW);
  fileMenu_->insertSeparator();
  fileMenu_->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // fileMenu_ key accelerators
  fileMenu_->setAccel(CTRL+Key_C, ID_FILE_CHOOSE_DIR);
  fileMenu_->setAccel(CTRL+Key_U, ID_FILE_UPDATE);
  fileMenu_->setAccel(CTRL+Key_S, ID_FILE_STOP_UPDATE);
  fileMenu_->setAccel(CTRL+Key_W, ID_FILE_CLOSE_WINDOW);
  fileMenu_->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu_
  viewMenu_ = new QPopupMenu();
  viewMenu_->setCheckable(true);
  viewMenu_->insertItem(i18n("Tool&bar"), ID_SHOW_TOOLBAR);
  viewMenu_->insertItem(i18n("&Statusbar"), ID_SHOW_STATUSBAR );

  viewMenu_->setItemChecked(ID_SHOW_TOOLBAR, viewToolbar_);
  viewMenu_->setItemChecked(ID_SHOW_STATUSBAR, viewStatusbar_);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  ///////////////////////////////////////////////////////////////////
  // menuBar entry actions_menu
  actionsMenu_ = new QPopupMenu();
  actionsMenu_->insertItem(Icon("folder_excl.xpm"), i18n("Exclude dirs"), ID_ACTIONS_EXCLUDE_DIRS );
  actionsMenu_->insertSeparator();
  actionsMenu_->insertItem(Icon("kpackage.xpm"), i18n("Diff with RPM"), ID_ACTIONS_DIFF_RPM );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  helpMenu_ = new QPopupMenu();
  helpMenu_ = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), fileMenu_);
  menuBar()->insertItem(i18n("&Show"), viewMenu_);
  menuBar()->insertItem(i18n("&Actions"), actionsMenu_);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu_);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  connect(fileMenu_,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(fileMenu_,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(viewMenu_,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(viewMenu_,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(actionsMenu_,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(actionsMenu_,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));
}

void LoSTApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW_WINDOW, true, i18n("New File"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("findf.xpm"), ID_FILE_CHOOSE_DIR, true, i18n("Choose dir"));
  toolBar()->insertButton(Icon("reload.xpm"), ID_FILE_UPDATE, true, i18n("Update"));
  toolBar()->insertButton(Icon("stop.xpm"), ID_FILE_STOP_UPDATE, true, i18n("Stop update"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("sort_name.xpm"), ID_SORT_NAME, true, i18n("Sort by name"));
  toolBar()->insertButton(Icon("sort_size.xpm"), ID_SORT_SIZE, true, i18n("Sort by size"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("view_real_size.xpm"), ID_VIEW_REAL_SIZE, true, i18n("View the real size"));
  toolBar()->insertButton(Icon("view_used_size.xpm"), ID_VIEW_USED_SIZE, true, i18n("View the used size"));
  toolBar()->insertButton(Icon("view_percent.xpm"), ID_VIEW_PERCENT, true, i18n("View the percentage"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("exit.xpm"), ID_FILE_CLOSE_WINDOW, true, i18n("Close window"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
  connect(toolBar(), SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)));

}

void LoSTApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

void LoSTApp::initView()
{
	view_ = new LoSTView(this);
	setView(view_);

	view_->setExcludeDirList(excludeDirList_);
	
	connect(view_,SIGNAL(rightButtonPressed(QListViewItem*,const QPoint&,int)), view_, SLOT(slotRightButtonPressed(QListViewItem*,const QPoint&,int)));
}

bool LoSTApp::queryExit(bool askForQuit)
{
	if (view_->isUpdating())
	{
		QMessageBox::warning(this, i18n("Exit application"), i18n("You can't quit while updating. Stop update first") );
		return false;
	}
	else
	{
		if (askForQuit)
		{
			// TEMP
			return true;
			int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));
			return (exit==1);
		}
	}
	return true;
}

void LoSTApp::saveOptions()
{
	KConfig *config = kapp->getConfig();
	
	QPoint p = pos();
	QSize s = size();
	int pos_x = p.x();
	int pos_y = p.y();
	int size_x = s.width();
	int size_y = s.height();

	config->setGroup("APPEARANCE");
	config->writeEntry("ShowToolbar",toolBar()->isVisible());
	config->writeEntry("ShowStatusbar",statusBar()->isVisible());
	config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
	config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());
	config->writeEntry("Window_pos_x", pos_x);
	config->writeEntry("Window_pos_y", pos_y);
	config->writeEntry("Window_size_x", size_x);
	config->writeEntry("Window_size_y", size_y);
	
	QStrList qlist;
	StdStringList& list = view_->getExcludeDirList();
	StdStringListIterator iter(list);
	std::string* str = iter.first();
	while(str)
	{
		QString qstr;
		copyStdStringToQString(qstr, *str);
		qlist.insert(0, qstr);
		str = iter.next();
	}
	config->writeEntry("ExcludeDirList", qlist);
}
void LoSTApp::readOptions()
{
	//////////////////////////////////////////////////////////////////
	// read the config file entries
	KConfig *config = kapp->getConfig();


	config->setGroup("APPEARANCE");
	viewToolbar_ = config->readBoolEntry("ShowToolbar", true);
	viewStatusbar_ = config->readBoolEntry("ShowStatusbar", true);
	menubarPos_ = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);
	toolbarPos_ = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);
	//int pos_x = config->readNumEntry("Window_pos_x", 50);
	//int pos_y = config->readNumEntry("Window_pos_y", 50);
	//move(pos_x, pos_y);
	int size_x = config->readNumEntry("Window_size_x", 500);
	int size_y = config->readNumEntry("Window_size_y", 500);
	resize(size_x, size_y);
	
	QStrList qlist;
	config->readListEntry("ExcludeDirList", qlist);
	for (uint i = 0;i<qlist.count();i++)
	{
		const char* c = qlist.at(i);
		excludeDirList_.insert(excludeDirList_.end(), std::string(c));
	}
}

void LoSTApp::beginUpdating()
{
	toolBar()->setItemEnabled(ID_FILE_CHOOSE_DIR, false);
	toolBar()->setItemEnabled(ID_FILE_UPDATE, false);
	toolBar()->setItemEnabled(ID_FILE_STOP_UPDATE, true);
}

void LoSTApp::stopUpdating()
{
	toolBar()->setItemEnabled(ID_FILE_CHOOSE_DIR, true);
	toolBar()->setItemEnabled(ID_FILE_UPDATE, true);
	toolBar()->setItemEnabled(ID_FILE_STOP_UPDATE, false);
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void LoSTApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new LoSTApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

void LoSTApp::slotFileChooseDir()
{
	slotStatusMsg(i18n("Opening a new Application window..."));

	//QString dir("/home/lost_test/ok/");
	//QString dir("/usr/opt");
	QString dir("/etc");
	//QString dir("/");
	
	//bool wantChoose = true;
	bool wantChoose = false;
	if (wantChoose)
	{
		KDirDialog dlg(view_->getBasePath(), this, "Choose a directory");
		if (!dlg.exec())
		{
			//QMessageBox::warning(view_, "Choice error", "exec() returned false");
			return;
		}
		dir = dlg.dirPath();
	}
	
	if (dir != "")
	{
		view_->updateTree(dir);
	}
	
	slotStatusMsg(IDS_DEFAULT);
}

void LoSTApp::slotFileUpdate()
{
	slotStatusMsg( i18n("Updating...") );
	view_->updateTree();
	slotStatusMsg(IDS_DEFAULT);
}

void LoSTApp::slotFileStopUpdate()
{
	slotStatusMsg(i18n("Stopping update..."));
	view_->stopUpdate();
	slotStatusMsg(IDS_DEFAULT);
}

void LoSTApp::slotFileCloseWindow()
{
	if(this->queryExit(false))
	{
		close();
	}
}
void LoSTApp::slotFileQuit()
{
	if(this->queryExit(true))
	{
		saveOptions();
		KTMainWindow::deleteAll();
		kapp->quit();
	}
	else
	{
    	slotStatusMsg(IDS_DEFAULT);
		return;
	}
}

void LoSTApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(IDS_DEFAULT);
}

void LoSTApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));

  slotStatusMsg(IDS_DEFAULT);
}

void LoSTApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));

  slotStatusMsg(IDS_DEFAULT);
}

void LoSTApp::slotShowToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  viewToolbar_ = !viewToolbar_;
  menuBar()->setItemChecked(ID_SHOW_TOOLBAR, viewToolbar_);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

void LoSTApp::slotShowStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  viewStatusbar_ = !viewStatusbar_;
  menuBar()->setItemChecked(ID_SHOW_STATUSBAR, viewStatusbar_);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void LoSTApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void LoSTApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void LoSTApp::commandCallback(int id_)
{
	switch (id_)
	{
	case ID_FILE_NEW_WINDOW:
		slotFileNewWindow();
		break;
	case ID_FILE_CHOOSE_DIR:
		slotFileChooseDir();
		break;
	case ID_FILE_UPDATE:
		slotFileUpdate();
		break;
	case ID_FILE_STOP_UPDATE:
		slotFileStopUpdate();
		break;
	case ID_FILE_CLOSE_WINDOW:
		slotFileCloseWindow();
		break;
	case ID_FILE_QUIT:
		slotFileQuit();
		break;
		
	case ID_SORT_NAME:
		slotSortName();
		break;
	case ID_SORT_SIZE:
		slotSortSize();
		break;
		
	case ID_VIEW_REAL_SIZE:
		slotViewRealSize();
		break;
	case ID_VIEW_USED_SIZE:
		slotViewUsedSize();
		break;
	case ID_VIEW_PERCENT:
		slotViewPercent();
		break;
		
	case ID_SHOW_TOOLBAR:
		slotShowToolBar();
		break;
	case ID_SHOW_STATUSBAR:
		slotShowStatusBar();
		break;
		
	case ID_ACTIONS_EXCLUDE_DIRS:
		view_->excludeDirs();
		break;
	case ID_ACTIONS_DIFF_RPM:
		view_->diffWithRpms();
		break;
	};
}

void LoSTApp::statusCallback(int id_)
{
	switch (id_)
	{
	case ID_FILE_NEW_WINDOW:
		slotStatusHelpMsg(i18n("Opens a new application window"));
		break;
	case ID_FILE_CHOOSE_DIR:
		slotStatusHelpMsg(i18n("Choose the destination directory"));
		break;
	case ID_FILE_UPDATE:
		slotStatusHelpMsg(i18n("Update the current directory"));
		break;
	case ID_FILE_CLOSE_WINDOW:
		slotStatusHelpMsg(i18n("Closes the current window"));
		break;
	case ID_FILE_QUIT:
		slotStatusHelpMsg(i18n("Exits the program"));
		break;
	
	case ID_SORT_NAME:
		slotStatusHelpMsg(i18n(""));
		break;
	case ID_SORT_SIZE:
		slotStatusHelpMsg(i18n(""));
		break;
	
	case ID_VIEW_REAL_SIZE:
		slotStatusHelpMsg(i18n(""));
		break;
	case ID_VIEW_USED_SIZE:
		slotStatusHelpMsg(i18n(""));
		break;
	case ID_VIEW_PERCENT:
		slotStatusHelpMsg(i18n(""));
		break;
	
	case ID_SHOW_TOOLBAR:
		slotStatusHelpMsg(i18n("Enables / disables the actual Toolbar"));
		break;
	case ID_SHOW_STATUSBAR:
		slotStatusHelpMsg(i18n("Enables / disables the Statusbar"));
		break;
	};
}
	
void LoSTApp::slotSortName()
{
	view_->setSortOption(LoSTView::NAME);
}

void LoSTApp::slotSortSize()
{
	view_->setSortOption(LoSTView::SIZE);
}

void LoSTApp::slotViewRealSize()
{
	view_->setViewOption(LoSTView::REAL_SIZE);
}

void LoSTApp::slotViewUsedSize()
{
	view_->setViewOption(LoSTView::USED_SIZE);
}

void LoSTApp::slotViewPercent()
{
	view_->setViewOption(LoSTView::PERCENT);
}

























































