/***************************************************************************
                          griddlg.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "griddlg.h"

extern struct GridSettingsType GridDefaults;

GridDlg::GridDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
debug("ColorBits=%X",GridDefaults.ColorFlags);

	initDialog();

  TabCtl = new KTabCtl(this, "TabCtl");
  TabCtl->setGeometry(0,0,this->width(),this->height()-50);
  TabCtl->addTab(GridGrp, i18n("Grid"));
  TabCtl->addTab(TempGrp, i18n("Temp"));
  TabCtl->addTab(PrsGrp, i18n("Pressure"));
  TabCtl->addTab(LevelGrp, i18n("Level"));
  TabCtl->addTab(WindGrp, i18n("Wind"));

  Chart = (TChart*)parent;
  //GridSpin->setValue(Chart->GridY);
  //ZeroSpin->setValue(Chart->GridN);

  TempUnitCmb->clear();
  PrsUnitCmb->clear();
  LevelUnitCmb->clear();
  WindDirUnitCmb->clear();
  WindStrengthUnitCmb->clear();
  for (int i=0; i<CNT_TEMPUNITS;i++)
    TempUnitCmb->insertItem(TempUnits[i]);
  for (int i=0; i<CNT_PRSUNITS;i++)
    PrsUnitCmb->insertItem(PrsUnits[i]);
  for (int i=0; i<CNT_LEVELUNITS;i++)
    LevelUnitCmb->insertItem(LevelUnits[i]);
  for (int i=0; i<CNT_WINDDIRUNITS;i++)
    WindDirUnitCmb->insertItem(WindDirUnits[i]);
  for (int i=0; i<CNT_WINDSTRENGTHUNITS;i++)
    WindStrengthUnitCmb->insertItem(WindStrengthUnits[i]);

  TempGridEdit->setValidChars(FLOAT_VALIDS);
  TempZeroEdit->setValidChars(FLOAT_VALIDS);
  PrsGridEdit->setValidChars(FLOAT_VALIDS);
  PrsZeroEdit->setValidChars(FLOAT_VALIDS);
  LevelGridEdit->setValidChars(FLOAT_VALIDS);
  LevelZeroEdit->setValidChars(FLOAT_VALIDS);

  GridSpin->setValue(GridDefaults.Grid);
  ZeroSpin->setValue(GridDefaults.ZeroLine);

  for(int i=0; i<TempUnitCmb->count(); i++) {
    if (strcmp(TempUnitCmb->text(i), GridDefaults.LineUnits)==0) {
      TempUnitCmb->setCurrentItem(i);
      break;
    }
  }
  //TempGridSpin->setValue(GridDefaults.LineGrids);
  //TempZeroSpin->setValue(GridDefaults.LineZero);
  TempGridEdit->setText(float2char(GridDefaults.LineGrids,0,2));
  TempZeroEdit->setText(float2char(GridDefaults.LineZero,0,2));
  TempLeftChk->setChecked(GridDefaults.LineDspLeft);
  TempRightChk->setChecked(GridDefaults.LineDspRight);
  TempColChk->setChecked(GridDefaults.ColorFlags & 0x0001);

  for(int i=0; i<PrsUnitCmb->count(); i++) {
    if (strcmp(PrsUnitCmb->text(i), GridDefaults.PrsUnits)==0) {
      PrsUnitCmb->setCurrentItem(i);
      break;
    }
  }
  //PrsGridSpin->setValue(GridDefaults.PrsGrids);
  //PrsZeroSpin->setValue(GridDefaults.PrsZero);
  PrsGridEdit->setText(float2char(GridDefaults.PrsGrids,0,2));
  PrsZeroEdit->setText(float2char(GridDefaults.PrsZero,0,2));
  PrsLeftChk->setChecked(GridDefaults.PrsDspLeft);
  PrsRightChk->setChecked(GridDefaults.PrsDspRight);
  PrsColChk->setChecked(GridDefaults.ColorFlags & 0x0002);

  for(int i=0; i<LevelUnitCmb->count(); i++) {
    if (strcmp(LevelUnitCmb->text(i), GridDefaults.LevelUnits)==0) {
      LevelUnitCmb->setCurrentItem(i);
      break;
    }
  }
  //LevelGridSpin->setValue(GridDefaults.LevelGrids);
  //LevelZeroSpin->setValue(GridDefaults.LevelZero);
  LevelGridEdit->setText(float2char(GridDefaults.LevelGrids,0,2));
  LevelZeroEdit->setText(float2char(GridDefaults.LevelZero,0,2));
  LevelLeftChk->setChecked(GridDefaults.LevelDspLeft);
  LevelRightChk->setChecked(GridDefaults.LevelDspRight);
  LevelColChk->setChecked(GridDefaults.ColorFlags & 0x0004);

  for(int i=0; i<WindDirUnitCmb->count(); i++) {
    if (strcmp(WindDirUnitCmb->text(i), GridDefaults.WindDirUnits)==0) {
      WindDirUnitCmb->setCurrentItem(i);
      break;
    }
  }
  for(int i=0; i<WindStrengthUnitCmb->count(); i++) {
    if (strcmp(WindStrengthUnitCmb->text(i), GridDefaults.WindStrengthUnits)==0) {
      WindStrengthUnitCmb->setCurrentItem(i);
      break;
    }
  }


  //connect(TempUnitCmb, SIGNAL(highlighted(int)), SLOT(TempUnitCmbSelect(int)));
  connect(TempUnitCmb, SIGNAL(activated(const char*)), SLOT(TempUnitCmbSelect(const char*)));
  connect(PrsUnitCmb,  SIGNAL(activated(const char*)), SLOT(PrsUnitCmbSelect(const char*)));
  connect(LevelUnitCmb,SIGNAL(activated(const char*)), SLOT(LevelUnitCmbSelect(const char*)));

  connect(OkBtn, SIGNAL(clicked()), SLOT(OkBtnClick()));
  connect(CancelBtn, SIGNAL(clicked()), SLOT(reject()));
  connect(ResetBtn, SIGNAL(clicked()), SLOT(ResetValues()));
}

GridDlg::~GridDlg(){
}

void GridDlg::TempUnitCmbSelect(const char* c) {
  SetTempScales(c, TempGridEdit, TempZeroEdit);
}

void GridDlg::PrsUnitCmbSelect(const char* c) {
  SetPrsScales(c, PrsGridEdit, PrsZeroEdit);
}

void GridDlg::LevelUnitCmbSelect(const char* c) {
  SetLevelScales(c, LevelGridEdit, LevelZeroEdit);
}

int GridDlg::CheckFields() {
int Ok=TRUE;

  Ok&=checkfloat(TempGridEdit->text());
  Ok&=checkfloat(TempZeroEdit->text());
  Ok&=checkfloat(PrsGridEdit->text());
  Ok&=checkfloat(PrsZeroEdit->text());
  Ok&=checkfloat(LevelGridEdit->text());
  Ok&=checkfloat(LevelZeroEdit->text());
  return Ok;
}

void GridDlg::OkBtnClick() {
QString S;
bool ok;

debug("Ok1 - ColorBits=%X",GridDefaults.ColorFlags);

  if (!CheckFields()) {
    QMessageBox::critical ( this,  i18n("Invalid Data in one or more floatfields"), i18n("Input Error"),
        i18n("Ok"), 0, 0,
        0, -1 );

    return;
  }
  GridDefaults.Grid = GridSpin->value();
  GridDefaults.ZeroLine = ZeroSpin->value();
  //GridDefaults.Grid=Chart->GridY;
  //GridDefaults.ZeroLine=Chart->GridN;


  strcpy(GridDefaults.LineUnits, TempUnitCmb->currentText());
  //GridDefaults.LineGrids = TempGridSpin->value();
  //GridDefaults.LineZero = TempZeroSpin->value();
  S=TempGridEdit->text();
  GridDefaults.LineGrids=S.toFloat(&ok);
  S=TempZeroEdit->text();
  GridDefaults.LineZero=S.toFloat(&ok);

  if (TempLeftChk->isChecked())
    GridDefaults.LineDspLeft=1;
  else
    GridDefaults.LineDspLeft=0;
  if (TempRightChk->isChecked())
    GridDefaults.LineDspRight=1;
  else
    GridDefaults.LineDspRight=0;
  if (TempColChk->isChecked())
    GridDefaults.ColorFlags |= 0x0001;
  else
    GridDefaults.ColorFlags &= 0xFFFE;

  strcpy(GridDefaults.PrsUnits, PrsUnitCmb->currentText());
  //GridDefaults.PrsGrids = PrsGridSpin->value();
  //GridDefaults.PrsZero = PrsZeroSpin->value();
  S=PrsGridEdit->text();
  GridDefaults.PrsGrids=S.toFloat(&ok);
  S=PrsZeroEdit->text();
  GridDefaults.PrsZero=S.toFloat(&ok);
  if (PrsLeftChk->isChecked())
    GridDefaults.PrsDspLeft=1;
  else
    GridDefaults.PrsDspLeft=0;
  if (PrsRightChk->isChecked())
    GridDefaults.PrsDspRight=1;
  else
    GridDefaults.PrsDspRight=0;
  if (PrsColChk->isChecked())
    GridDefaults.ColorFlags |= 0x0002;
  else
    GridDefaults.ColorFlags &= 0xFFFD;

  strcpy(GridDefaults.LevelUnits, LevelUnitCmb->currentText());
  //GridDefaults.LevelGrids = LevelGridSpin->value();
  //GridDefaults.LevelZero = LevelZeroSpin->value();
  S=LevelGridEdit->text();
  GridDefaults.LevelGrids=S.toFloat(&ok);
  S=LevelZeroEdit->text();
  GridDefaults.LevelZero=S.toFloat(&ok);
  if (LevelLeftChk->isChecked())
    GridDefaults.LevelDspLeft=1;
  else
    GridDefaults.LevelDspLeft=0;
  if (LevelRightChk->isChecked())
    GridDefaults.LevelDspRight=1;
  else
    GridDefaults.LevelDspRight=0;
  if (LevelColChk->isChecked())
    GridDefaults.ColorFlags |= 0x0004;
  else
    GridDefaults.ColorFlags &= 0xFFFB;


  strcpy(GridDefaults.WindDirUnits, WindDirUnitCmb->currentText());
  strcpy(GridDefaults.WindStrengthUnits, WindStrengthUnitCmb->currentText());

  accept();
  Chart->update();
debug("Ok2 - ColorBits=%X",GridDefaults.ColorFlags);
}

void GridDlg::ResetValues() {
// Zurcksetzen auf Defaultwerte

  GridSpin->setValue(12);
  ZeroSpin->setValue(5);

  TempUnitCmb->setCurrentItem(0);
  TempGridEdit->setText("5.00");
  TempZeroEdit->setText("0.00");
  TempLeftChk->setChecked(TRUE);
  TempRightChk->setChecked(FALSE);
  TempColChk->setChecked(FALSE);

  PrsUnitCmb->setCurrentItem(0);
  PrsGridEdit->setText("10.00");
  PrsZeroEdit->setText("1000.00");
  PrsLeftChk->setChecked(FALSE);
  PrsRightChk->setChecked(TRUE);
  PrsColChk->setChecked(FALSE);

  LevelUnitCmb->setCurrentItem(0);
  LevelGridEdit->setText("10.00");
  LevelZeroEdit->setText("0.00");
  LevelLeftChk->setChecked(FALSE);
  LevelRightChk->setChecked(TRUE);
  LevelColChk->setChecked(FALSE);

  WindDirUnitCmb->setCurrentItem(0);
  WindStrengthUnitCmb->setCurrentItem(0);
}
