    /*

    graphicdialog.h  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __GRAPHICDIALOG__
#define __GRAPHICDIALOG__


#include <qcolor.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qdialog.h>



class GraphicDialog : public QDialog
  {
  Q_OBJECT

  public:
    enum { Circle, Square };
    enum { Red, Green, Blue, Black };
    enum { Small, Medium, Large };
    enum { Solid, Dash, Dotted, Dashdot };
    GraphicDialog( int pointsShape, int pointsShapeDefault,
                   int pointsColour, int pointsColourDefault,
                   int pointsSize, int pointsSizeDefault,
                   int linesStyle, int linesStyleDefault,
                   int linesColour, int linesColourDefault,
                   int linesWidth, int linesWidthDefault,
                   QWidget *parent = 0,
                   const char *name = 0);
    ~GraphicDialog();

  signals:
    void pointsShapeChanged( int value );
    void pointsColourChanged( int value );
    void pointsSizeChanged( int value );
    void linesStyleChanged( int value );
    void linesColourChanged( int value );
    void linesWidthChanged( int value );

  protected slots:
    void slotPointsShapeChanged( int value );
    void slotPointsColourChanged( int value );
    void slotPointsSizeChanged( int value );
    void slotLinesStyleChanged( int value );
    void slotLinesColourChanged( int value );
    void slotLinesWidthChanged( int value );
    void slotDefaults();
    void slotOK();

  private:
    int _pointsShape, _pointsShapeDefault;
    int _pointsColour, _pointsColourDefault;
    int _pointsSize, _pointsSizeDefault;
    int _linesStyle, _linesStyleDefault;
    int _linesColour, _linesColourDefault;
    int _linesWidth, _linesWidthDefault;
    QComboBox *pointsShapeCombo;
    QComboBox *pointsColourCombo;
    QComboBox *pointsSizeCombo;
    QComboBox *linesStyleCombo;
    QComboBox *linesColourCombo;
    QComboBox *linesWidthCombo;
  };




#endif   //  __GRAPHICDIALOG__
