#include <ktopwidget.h>
#include <kapp.h>
#include <qwidget.h>
#include <kkeyconf.h>
#include <kmsgbox.h>
#include "ksoa.h"
#include "ksoa.moc"

void klist :: mousePressEvent(QMouseEvent *m)
{
        if (m->button()==RightButton) 
        	emit popup(current_line,m->x(),m->y());
}


ksoa :: ksoa(QWidget *, const char *name)
	: KTopLevelWidget(name)
{

	resize (500,200);	

	label=new QLabel(this);				
	label->setText(i18n("Domain to check : "));	
	label->setAlignment(AlignTop);
	label->setMargin(5);				
	label->resize(label->sizeHint());	

	line=new KLined(this,"file");			
	line->setGeometry(77,0,100,21);
	line->setFocus();				
	
	helpb=new QPushButton("Help",this);		
	helpb->setGeometry(283,0,50,21);

	QString at = "Ksoa 0.1";			
	at += i18n("\n\nJimmy Z. Stergiou (hermes@mbn.gr)\n\nSOA check for the KDE Desktop Environment");

	helpMenu = kapp->getHelpMenu(true, at.data());	

	statusbar=new KStatusBar(this);
	statusbar->insertItem("Idle",1);
	statusbar->show();
	setStatusBar(statusbar);

	connect(line,SIGNAL(returnPressed()),this,SLOT(doit()));
	connect(helpb,SIGNAL(clicked()),this,SLOT(showhelp()));
	box=new klist(this);
	connect(box,SIGNAL(popup(int,int,int)),this,SLOT(showpopup(int,int,int)));
}


ksoa :: ~ksoa() {}

void ksoa::showhelp()
{
	helpMenu->show();
	helpMenu->move(x()+width()-helpMenu->width(),y()+20);
}

void ksoa::doit()
{
	char *nsList[NSLIMIT];
	char cmd[1024];
	int nsNum = 0;
	int found;

	statusbar->insertItem(i18n("Idle"),1);
	found=0;
	box->clear();
	sprintf(cmd,"%s",line->text());

        (void) res_init();
        findNameServers(cmd, nsList, &nsNum);
        queryNameServers(cmd, nsList, nsNum);
}

void ksoa::showpopup(int,int ex, int ey)
{
	QPopupMenu *popmenu=new QPopupMenu();
	popmenu->insertItem(i18n("Ksoa"),0);
	popmenu->insertSeparator();
	popmenu->insertItem(i18n("About"),1);
	popmenu->insertItem("Quit", qApp,  SLOT(quit()) );
	popmenu->resize(popmenu->sizeHint());
	popmenu->move(ex+x(),ey+y()+20);
	connect(popmenu,SIGNAL(activated(int)), this,SLOT(popcallback(int)));
	popmenu->exec(); 
}

void ksoa::popcallback(int id)
{
        switch (id) {
        case 1:
 	QMessageBox::about(this, "Ksoa",
                        "Created by Jimmy Z. Stergiou (hermes@mbn.gr).\n"
                        "Find SOA records for domains\n" );
        break;
	}
}

void ksoa::resizeEvent(QResizeEvent *)
{
	line->setGeometry(label->width(),0,
		width()-label->width()-helpb->width()-5,line->height());
	helpb->setGeometry(width()-helpb->width(),0,
		helpb->width(),helpb->height());
	box->setGeometry(0,line->height(),width(),
	       height()-line->height()-statusbar->height());
	statusbar->setGeometry(0,height()-statusbar->height(),
		width(),statusbar->height());
}

int main(int argc, char* argv[])
{

	KApplication *app=new KApplication(argc,argv);
	ksoa *soa=new ksoa;

	app->setMainWidget(soa);
	soa->show();
	app->exec();

	return(0);
}

void ksoa::findNameServers(char *domain, char *nsList[], int *nsNum)
{
	char tmpstr[1024];
        union {
                HEADER hdr;
                unsigned char buf[PACKETSZ];
        } response;
        int responseLen;
        unsigned char *cp;
        unsigned char *endofMsg;
        unsigned short classn;
        unsigned short type;
        unsigned int ttl;
        unsigned short dlen;
        int i, count, dup;

        if ((responseLen =
                res_query ( domain,
                           C_IN,
                           T_NS,
                           (unsigned char *) &response,
                           sizeof(response))) < 0)
        {
                nsError(h_errno, domain);
        }
        endofMsg = response.buf + responseLen;
        cp = response.buf + sizeof(HEADER);
        cp += skipName(response.buf, cp, endofMsg) + QFIXEDSZ;
        count = ntohs(response.hdr.ancount) + ntohs(response.hdr.nscount);
        while ((--count >= 0)
            && (cp < endofMsg)
            && (*nsNum < NSLIMIT))
        {
                cp += skipToData(response.buf, cp, &type, &classn, &ttl, &dlen,endofMsg);
                if (type ==T_NS)
                {
                        nsList[*nsNum] = (char *) malloc (MAXDNAME);
                        if (nsList[*nsNum] == NULL)
                        {
				sprintf(tmpstr,"Not enough memory for the program to work");
				statusbar->changeItem(i18n(tmpstr),1);
                        }
                        if (dn_expand(response.buf,
                                      endofMsg,
                                      cp,
                                      (char *)nsList[*nsNum],
                                      MAXDNAME) < 0)
                        {
				sprintf(tmpstr,"Cannot find nameservers for domain");
				statusbar->changeItem(i18n(tmpstr),1);
                        }
                        for (i=0, dup=0; (i < *nsNum) && !dup; i++)
                                dup = !strcasecmp(nsList[i], nsList[*nsNum]);
                        if (dup)
                                        free(nsList[*nsNum]);
                        else
                                        (*nsNum)++;
                }
                cp +=dlen;
        }
}

void ksoa::queryNameServers(char *domain, char* nsList[], int nsNum)
{
        union {
                HEADER hdr;
                unsigned char buf[PACKETSZ];
        } query, response;
        int responseLen, queryLen;
        unsigned char *cp;
        unsigned char *endofMsg;
        unsigned short classn;
        unsigned short type;
        unsigned int ttl;
        unsigned short dlen;
        unsigned int serial;
        struct in_addr saveNsAddr[MAXNS];
        int nsCount;
        struct hostent *host;
        int i, myindex;
	char tmpstr[1024];
	char tmpstr2[1024];
	char tmpstr3[1024];

        nsCount = _res.nscount;
        for (i=0; i < nsCount; i++)
                saveNsAddr[i] = _res.nsaddr_list[i].sin_addr;
        _res.options &= ~(RES_DNSRCH | RES_DEFNAMES);
	myindex=nsNum;
        for (nsNum--; nsNum >= 0 ; nsNum--)
        {
                _res.options |= RES_RECURSE;
                _res.retry = 4;
                _res.nscount = nsCount;
                for (i=0; i < nsCount; i++)
                        _res.nsaddr_list[i].sin_addr = saveNsAddr[i];
                host = gethostbyname(nsList[nsNum]);
                if (host == NULL)
                {
			sprintf(tmpstr,"There is no address for: %s", nsList[nsNum]);
			statusbar->changeItem(i18n(tmpstr),1);
                        continue;
                }
                (void) memcpy((void *) &_res.nsaddr_list[0].sin_addr, (void *)host->h_addr_list[0], (size_t)host->h_length);
                _res.nscount = 1;
                _res.options &= ~RES_RECURSE;
                _res.retry = 2;
                queryLen = res_mkquery(QUERY,
                                          domain,
                                          C_IN,
                                          T_SOA,
                                          (unsigned char *)NULL,
                                          0,
                                          (unsigned char *)NULL,
                                          (unsigned char *)&query,
                                          sizeof(query));
                errno = 0;
                if ((responseLen = res_send((unsigned char *)&query,
                                        queryLen,
                                        (unsigned char *)&response,
                                        sizeof(response))) < 0)
                {
                        if (errno == ECONNREFUSED)
                        {
                                sprintf(tmpstr, "There is no nameserver running on: %s", nsList[nsNum]);
				statusbar->changeItem(i18n(tmpstr),1);
                        }
                        else
                        {
                                sprintf(tmpstr, "There was no response from %s",nsList[nsNum]);
				statusbar->changeItem(i18n(tmpstr),1);
                        }
                        continue;
                }
                endofMsg = response.buf + responseLen;
                cp = response.buf + sizeof(HEADER);
                if (response.hdr.rcode != NOERROR)
                {
                        returnCodeError((int)response.hdr.rcode, nsList[nsNum]);                        continue;
                }
                if (!response.hdr.aa)
                {
                        sprintf(tmpstr, "%s is not authorative for %s\n", nsList[nsNum], domain);
			statusbar->changeItem(i18n(tmpstr),1);
                        continue;
                }
                if (ntohs(response.hdr.ancount) != 1)
                {
                        sprintf(tmpstr, "%s: expected 1 answer, got %d\n", nsList[nsNum], ntohs(response.hdr.ancount));
			statusbar->changeItem(i18n(tmpstr),1);
                        continue;
                }
                cp += skipName(response.buf, cp, endofMsg) + QFIXEDSZ;
                cp += skipToData(response.buf, cp, &type, &classn, &ttl, &dlen, endofMsg);
                if (type != T_SOA)
                {
                        sprintf(tmpstr, "%s: expected answer type %d, got %d\n", nsList[nsNum], T_SOA, type);
			statusbar->changeItem(i18n(tmpstr),1);
                        continue;
                }
                cp += skipName(response.buf, cp, endofMsg);
                cp += skipName(response.buf, cp, endofMsg);
                GETLONG(serial, cp);
                sprintf(tmpstr2, "%s has serial number %d\n", nsList[nsNum], serial);
		box->insertItem(i18n(tmpstr2));
        }
	if (myindex <=0)
	{
		sprintf(tmpstr3,"No entries found");
		statusbar->changeItem(i18n(tmpstr3),1);
		box->insertItem(i18n("** No entries found **"));
	}
	else
	{
		sprintf(tmpstr3,"Found %d entries", myindex);
		statusbar->changeItem(i18n(tmpstr3),1);
	}
}

int ksoa::skipName(unsigned char *startofMsg, unsigned char *cp, unsigned char *endofMsg)
{
        char buf[MAXDNAME];
	char tmpstr[1024];
        int n;

        if ((n = dn_expand(startofMsg, endofMsg, cp, buf, MAXDNAME)) < 0)
        {
                sprintf(tmpstr, "Query failed\n");
		statusbar->changeItem(i18n(tmpstr),1);
        }
        return(n);
}

int ksoa::skipToData(unsigned char *startofMsg,
                unsigned char *cp,
                unsigned short *type,
                unsigned short *classn,
                unsigned int *ttl,
                unsigned short *dlen,
                unsigned char *endofMsg)
{
        unsigned char* tmp_cp = cp;
        tmp_cp += skipName(startofMsg, tmp_cp, endofMsg);
        GETSHORT(*type, tmp_cp);
        GETSHORT(*classn, tmp_cp);
        GETLONG(*ttl, tmp_cp);
        GETSHORT(*dlen, tmp_cp);
        return (tmp_cp - cp);
}

void ksoa::nsError(int error, char* domain)
{
	char tmpstr[1024];
        switch (error)
        {
                case HOST_NOT_FOUND:
                        sprintf(tmpstr, "Unknown domain: %s\n", domain);
			statusbar->changeItem(i18n(tmpstr),1);
                        break;
                case NO_DATA:
                        sprintf(tmpstr, "No NS record for: %s\n", domain);
			statusbar->changeItem(i18n(tmpstr),1);
                        break;
                case TRY_AGAIN:
                        sprintf(tmpstr, "No response for NS query\n");
			statusbar->changeItem(i18n(tmpstr),1);
	                break;
                default:
                        sprintf(tmpstr, "Unexpected error\n");
			statusbar->changeItem(i18n(tmpstr),1);
                        break;
        }
}

void ksoa::returnCodeError (int rcode, char* nameserver)
{
	char tmpstr[1024];
	char tmpstr2[1024];
        sprintf(tmpstr2, "%s: ", nameserver);
	statusbar->changeItem(i18n(tmpstr2),1);
	
        switch (rcode)
        {
                case FORMERR:
                        sprintf(tmpstr, "FORMERR response\n");
			statusbar->changeItem(i18n(tmpstr),1);
                        break;
                case SERVFAIL:
                        sprintf(tmpstr, "SERVFAIL response\n");
			statusbar->changeItem(i18n(tmpstr),1);
                        break;
                case NXDOMAIN:
                        sprintf(tmpstr, "NXDOMAIN response\n");
			statusbar->changeItem(i18n(tmpstr),1);
                        break;
                case NOTIMP:
                        sprintf(tmpstr, "NOTIMP response\n");
			statusbar->changeItem(i18n(tmpstr),1);
                      break;
                default:
                        sprintf(tmpstr, "UNEXPECTED RETURN CODE\n");
			statusbar->changeItem(i18n(tmpstr),1);
                        break;
        }
}

