/***************************************************************************
                          knd_view.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSNUFFLEVIEW_H 
#define KSNUFFLEVIEW_H 

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<ktabctl.h>

#include	"ksnuffle.h"
#include	"knd_gra.h"
#include	"knd_pkt.h"

class KNDView : public KTabCtl
{
	Q_OBJECT

	bool	onview	;
	int	curtab	;

public:
	KNDView (KNDApp *, int, char *, KConfig * = NULL) ;

	virtual	~KNDView () ;

	inline	char	*getName()	{ return name	; }
	inline	int	getSlot	()	{ return slot	; }

	void	setName		(const char *)	;
	void	setOnview	(bool)		;
virtual	void	timerTick 	(long)		= 0 ;
virtual	void	writeConfig	(KConfig    *)	= 0 ;

	void	viewConfig	() ;
	void	viewGraphic	() ;
	void	viewPackets	() ;

virtual	void	viewStop	() = 0 ;
virtual	void	viewStart	() = 0 ;
virtual	void	viewFreeze	() = 0 ;
virtual	void	viewResume	() = 0 ;

protected :

	KNDApp		*parent    ;
	KNDGraphic	*graphic   ;
	KNDPacket	*packets   ;

	int		slot	   ;
	char		name[32]   ;

private slots :

	void	tabSelect (int) ;
}	;

#endif // KSNUFFLEVIEW_H 
