/***************************************************************************
                          knd_gra.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef 	KSNUFFLEGRAPHIC_H 
#define 	KSNUFFLEGRAPHIC_H 

#ifdef 		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<qframe.h>
#include	<qgroupbox.h>
#include	<qtooltip.h>

#include 	"ksnuffle.h"
#include	"knd_multi.h"
#include	"knd_load.h"
#include	"knd_pcap.h"
#include	"knd_pkt.h"



/*  KNDGraphic								*/
/*  ----------								*/

class	KNDGraphic : public QFrame
{
	Q_OBJECT	;

	QGroupBox	g_load		;
	QGroupBox	g_bar		;
	QGroupBox	g_count		;

	QLabel		lhmax		;
	QLabel		lhmin		;
	QLabel		pHist1		;
	QLabel		pBar1		;
	QLabel		pBar2		;
	QLabel		pcmax		;
	QLabel		pcmin		;

	KNDLoadHist	*loadHist	;
	KNDLoadBar	*loadBar1	;
	KNDLoadBar	*loadBar2	;
	int		loadScale	;

	KNDPktHist	*pktHist	;
	int		pktScale	;

	bool		onview		;
	bool		going		;
	bool		frozen		;

	int		v_hist		;
	int		v_bar1		;
	int		v_bar2		;

public	:
	KNDGraphic	(KNDView *)	;
       ~KNDGraphic  	()		;

	void	setOptions	(int, int, int) ;
	void	setOnview	(bool)	   ;
	void	addPacket 	(PktInfo *);
	void	paintAll	()	   ;
	void	execute		(bool)	   ;
	void	freeze		(bool)	   ;
	void	timerTick	(long) 	   ;
}	;

#endif // KSNUFFLEGRAPHIC_H 
