/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __SCAN_H__
#define __SCAN_H__

#include <qimage.h>
#include <qprogdlg.h>
#include <qobject.h>
#include <qfile.h>
#include <qdstream.h>
extern "C" {
#include <sane.h>
}
#include <stdio.h>

#define NUMREQ 9
// Scanner Options
#define MODE        0
#define BRIGHTNESS  1
#define CONTRAST    2
#define RESOLUTION  3
#define TLX         4
#define TLY         5
#define BRX         6
#define BRY         7
#define RESOLUTION_BIND 8

#define MIN_SUPPORTED_BRIGHTNESS 10
#define MIN_SUPPORTED_CONTRAST 10

//Don't change it
#define BRIGHTNESS_RANGE 127
#define CONTRAST_RANGE 127

const double mms_per_inch = 25.39; //Am I right ?

enum scan_type { GRAY, COLOR};

class ScanImage : public QObject {
	Q_OBJECT
public:
	static int getDevices(const SANE_Device ***dl)
	{ return !sane_get_devices(dl,FALSE); }
	static bool InitScanner(char *backend); // Returns true on success
	static void CloseScanner();
        static void forceBrightnessEmulation(bool f);
        static void forceContrastEmulation(bool f);
	static bool scannerPresent();
        static bool haveColorMode();
        static bool haveGrayMode();
        static bool brightnessEmulated();
        static bool contrastEmulated();
	ScanImage(scan_type t = COLOR,bool _preview = TRUE);
	~ScanImage();
	scan_type getType() { return type; }
        void setType(scan_type t);
	QImage *image() { return img; }
	int getResolution()
	{ int tmp; get_option(RESOLUTION,&tmp); return tmp; }
	void getArea(SANE_Fixed &tlx,SANE_Fixed &tly,
		      SANE_Fixed &brx,SANE_Fixed &bry);
	int acquire();
	void save();
	void adjust_and_convert(int gamma = 100,int brightness = 0,
				int contrast = 0);
	bool picturePresent() { return pp; }
public slots:
        void setMode(char *mode);
	void setBrightness(int brightness);
	void setContrast(int contrast);
	void setResolution(int dpi);
	void setArea(SANE_Fixed tlx,SANE_Fixed tly,
		      SANE_Fixed brx,SANE_Fixed bry) {
		set_option(TLX,&tlx); set_option(TLY,&tly);
		set_option(BRX,&brx); set_option(BRY,&bry);
	}
	void receive();
protected:
	SANE_Status set_option(int opt,void *val);
	void get_option(int opt,void *val);
	void set_auto(int opt);
	static bool find_options();
        void grayify();
        void colorify();
private:
	QImage *img;
	QFile *preview_data;
	QProgressDialog *dlg;
	//QSocketNotifier *sn;
	SANE_Byte *data,*dat;
	SANE_Parameters p;
	SANE_Fixed t_tlx,t_tly,t_brx,t_bry;
	int maxlen,done;
        int resolution;
	scan_type type;
        int cur_brightness,cur_contrast;
	bool pp,preview;
};

#endif
