#include <iostream.h>
#include <stdlib.h>
#include <unistd.h>
#include <qmessagebox.h>
#include <unistd.h>
#include "protmgr.h"
#include "fileprot.h"
#include "mountprot.h"
#include "ftpprot.h"
#include "trashprot.h"
#include "tarprot.h"
#include "zipprot.h"
#include "rpmprot.h"
#include "smbprot.h"
#include "smb.h"
// DEB
//#include "debprot.h"
// DEB
#include <kapp.h>

#include <errno.h>
#include <string.h>

#ifdef	HAVE_PTH
#define _PTHREAD_PRIVATE
#include <pth.h>
#endif

#include "LineDlg.h"

//--------------------------------------------------------------------------------------

#define	PROTOCOL_LIST		0
#define	PROTOCOL_COPY		1
#define PROTOCOL_MOVE		2
#define PROTOCOL_INIT		3
#define PROTOCOL_FINISH		4
#define PROTOCOL_RENAME		5
#define	PROTOCOL_REMOVE		6
#define PROTOCOL_MKDIR		7
#define	PROTOCOL_CHMOD		8
#define PROTOCOL_TRASH		9
#define PROTOCOL_GETFILE	10
#define	PROTOCOL_TRANSFER	11
#define PROTOCOL_CHOWN		12

#define INIT_ERROR		ErrorMsg.truncate(0);
#define	CHECK_ERROR		if (!ErrorMsg.isEmpty()) QMessageBox::critical(ParentWidget,i18n("Error"),ErrorMsg.data(),QMessageBox::Ok | QMessageBox::Default,0);

#define	CHECK_TIMEOUT		5000	// 5 seconds

void* __thread_routine(void *arg);
void __thread_cleanup_routine(void *arg);

struct Protocol_Interface
{
	Protocol_Interface(ProtocolMgr *mgr,int t,void *a1=0,void* a2=0,void *a3=0,void *a4=0,void *a5=0,void *a6=0)
		: Mgr(mgr),type(t),arg1(a1),arg2(a2),arg3(a3),arg4(a4),arg5(a5),arg6(a6),out(0),done(false) {}
	ProtocolMgr	*Mgr;
	int	type;
	void	*arg1,*arg2,*arg3,*arg4,*arg5,*arg6;
	void	*out;
	bool	done;
};

void* __thread_routine(void *arg)
{
	pthread_cleanup_push(__thread_cleanup_routine,arg);
	((Protocol_Interface*)arg)->Mgr->thread_Dispatcher((Protocol_Interface*)arg);
	pthread_detach(pthread_self());		// detach it before exiting to free memory
	pthread_cleanup_pop(0);
	return 0;
}

void __thread_cleanup_routine(void *arg)
{
	((Protocol_Interface*)arg)->Mgr->thread_Cleanup((Protocol_Interface*)arg);
}

void ProtocolMgr::thread_start(Protocol_Interface *p)
{
	INIT_ERROR;
	pthread_attr_t	attr;
	pthread_attr_init(&attr);
	pthread_attr_setdetachstate(&attr,PTHREAD_CREATE_JOINABLE);
	if (pthread_create(&th_id,&attr,__thread_routine,(void*)p) == 0) {
#ifdef	HAVE_PTH
		pth_time_t	tout = {0,50000};
#endif
		while (!p->done) {
			kapp->processEvents();
#ifdef	HAVE_PTH
			pth_nap(tout);
#else
			usleep(50000);
#endif
		}
		kapp->processEvents();
	}
	else ErrorMsg = i18n("Unable to create child thread");
	pthread_attr_destroy(&attr);
	th_id = 0;
	CHECK_ERROR;
}

void ProtocolMgr::thread_Dispatcher(Protocol_Interface *p)
{
	switch (p->type) {
	   case PROTOCOL_LIST:
		p->out = (void*)thread_list((Protocol*)p->arg1,(KURL*)p->arg2,(bool)p->arg3,(bool)p->arg4,(bool)p->arg5);
		break;
	   case PROTOCOL_RENAME:
		p->out = (void*)thread_rename((Protocol*)p->arg1,(KURL*)p->arg2,(KURL*)p->arg3);
		break;
	   case PROTOCOL_MKDIR:
		p->out = (void*)thread_mkdir((Protocol*)p->arg1,(KURL*)p->arg2);
		break;
	   case PROTOCOL_CHMOD:
		p->out = (void*)thread_chmod((Protocol*)p->arg1,(KURL*)p->arg2,(int)p->arg3);
		break;
	   case PROTOCOL_INIT:
		p->out = (void*)thread_init((Protocol*)p->arg1);
		break;
	   case PROTOCOL_FINISH:
		p->out = (void*)thread_finish((Protocol*)p->arg1);
		break;
/*	   case PROTOCOL_COPY:
		p->out = (void*)thread_copy((QStrList*)p->arg1,(const char*)p->arg2);
		break;
	   case PROTOCOL_MOVE:
		p->out = (void*)thread_move((QStrList*)p->arg1,(const char*)p->arg2);
		break;*/
	   case PROTOCOL_REMOVE:
		p->out = (void*)thread_remove((Protocol*)p->arg1,(QStrList*)p->arg2);
		break;
	   case PROTOCOL_TRASH:
		p->out = (void*)thread_emptyTrash((Protocol*)p->arg1);
		break;
	   case PROTOCOL_GETFILE:
		p->out = (void*)thread_getFile((Protocol*)p->arg1,(KURL*)p->arg2);
		break;
	   case PROTOCOL_TRANSFER:
		p->out = (void*)thread_transfer((Protocol*)p->arg1,(Protocol*)p->arg2,(KURL*)p->arg3,(KURL*)p->arg4,(bool)p->arg5,(bool)p->arg6);
		break;
	   case PROTOCOL_CHOWN:
		p->out = (void*)thread_chown((Protocol*)p->arg1,(KURL*)p->arg2,(const char*)p->arg3,(const char*)p->arg4);
		break;
	}

	p->done = true;
}

void ProtocolMgr::thread_Cleanup(Protocol_Interface *p)
{
	if (activeProtocol) activeProtocol->cleanup();
	p->out = (void*)0;
	p->done = true;
}

//--------------------------------------------------------------------------------------

const FileInfoList* ProtocolMgr::thread_list(Protocol *prot, KURL* url, bool hidden, bool dirsOnly, bool showArchive)
{
	activeProtocol = prot;
	QString		RealPath;
	if (url->hasSubProtocol()) {
		QString	str(url->childURL().data());
		int	pos = str.findRev(':');
		RealPath = str.right(str.length()-pos-1);
	}
	else RealPath = url->path();
	if (prot->setPath(RealPath.data())) {
		const FileInfoList	*tmp = prot->entryInfoList(hidden,dirsOnly,showArchive);
		if (tmp) {
			activeProtocol = 0;
			return tmp;
		}
	}
	QString		msg(i18n("Unable to read directory "));
	msg.append(url->path());
	showError(msg.data());
	activeProtocol = 0;
	return 0;
}

const FileInfoList* ProtocolMgr::list(Protocol *prot, KURL& url, bool hidden, bool dirsOnly, bool showArchive)
{
	if (prot->needLogin() && !initProtocol(prot)) return 0;
	Protocol_Interface	*p = new Protocol_Interface(this,PROTOCOL_LIST,(void*)prot,(void*)(&url),(void*)hidden,(void*)dirsOnly,(void*)showArchive);
	thread_start(p);
	const FileInfoList	*retval = (FileInfoList*)(p->done ? p->out : 0);
	delete p;
	return retval;
}

bool ProtocolMgr::thread_rename(Protocol *prot, KURL* src, KURL* dest)
{
	activeProtocol = prot;
	bool	tmp(true);
	tmp = prot->rename(src->path(),dest->path());
	activeProtocol = 0;
	if (!tmp) showError(i18n("Unable to rename file"));
	return tmp;
}

bool ProtocolMgr::rename(Protocol *prot, const KURL& src, const KURL& dest)
{
	if (prot->exists(dest.path())) {
		QString		msg;
		msg.sprintf(i18n("%s already exists. Do you want to replace it ?"),dest.path());
		if (QMessageBox::warning(ParentWidget,i18n("Warning"),msg.data(),i18n("Yes"),i18n("No"),(char*)0,0,1) == 1)
			return false;
	}
	return thread_routine1(PROTOCOL_RENAME,(void*)prot,(void*)(&src),(void*)(&dest));
}

bool ProtocolMgr::thread_mkdir(Protocol *prot, KURL* url)
{
	activeProtocol = prot;
	bool	tmp = prot->mkdir(url->path());
	activeProtocol = 0;
	if (!tmp) showError(i18n("Unable to create directory"));
	return tmp;
}

bool ProtocolMgr::mkdir(Protocol *prot, const KURL& url)
{ return thread_routine1(PROTOCOL_MKDIR,(void*)prot,(void*)(&url));}

bool ProtocolMgr::thread_chmod(Protocol *prot, KURL* url, int perm)
{
	activeProtocol = prot;
	bool	tmp = prot->chmod(url->path(),perm);
	activeProtocol = 0;
	if (!tmp) showError(i18n("Unable to change permissions"));
	return tmp;
}

bool ProtocolMgr::chmod(Protocol *prot, const KURL& url, int perm)
{ return thread_routine1(PROTOCOL_CHMOD,(void*)prot,(void*)(&url),(void*)perm);}

bool ProtocolMgr::thread_chown(Protocol *prot, KURL* url, const char *owner, const char *group)
{
	activeProtocol = prot;
	bool	tmp = prot->chown(url->path(),owner,group);
	activeProtocol = 0;
	if (!tmp) showError(i18n("Unable to change owner/group"));
	return tmp;
}

bool ProtocolMgr::chown(Protocol *prot, const KURL& url, const char *owner, const char *group)
{ return thread_routine1(PROTOCOL_CHOWN,(void*)prot,(void*)(&url),(void*)owner,(void*)group);}

bool ProtocolMgr::thread_init(Protocol *prot)
{
	bool	retval;
	activeProtocol = prot;
	if (!(retval = prot->init())) showError(prot->errorMsg());
	activeProtocol = 0;
	return retval;
}

bool ProtocolMgr::initProtocol(Protocol *prot)
{
	if (prot->needLogin()) {
		LineDlg	*Dlg = new LineDlg(0,0,2);
		QString		str(i18n("Password required"));
		Dlg->setCaption(str.data());
//		Dlg->setLabel(prot->prefix().data());
		Dlg->setLabel(i18n("User"),1);
		Dlg->setLabel(i18n("Password"),2);
		QString		user = prot->user();
		if (user.isEmpty()) user = getenv("USER");
		Dlg->setText(user.data(),1,true);
		Dlg->setPasswd();
		if (Dlg->exec()) prot->setLogin(Dlg->text(1),Dlg->text(2));
		else return false;
	}
	return thread_routine1(PROTOCOL_INIT,(void*)prot);
}

bool ProtocolMgr::thread_finish(Protocol *prot)
{
	bool	retval;
	activeProtocol = prot;
	if (!(retval = prot->finish())) showError(prot->errorMsg());
	activeProtocol = 0;
	return retval;
}

bool ProtocolMgr::finishProtocol(Protocol *prot)
{ return thread_routine1(PROTOCOL_FINISH,(void*)prot);}

/*bool ProtocolMgr::thread_copy(QStrList* src, const char *dest)
{
	askOverwrite = TRUE;
	QStrListIterator	it(*src);
	bool	retval = FALSE;
	for ( ; it.current(); ++it)
		if ((retval = transfer(it.current(),dest,FALSE,FALSE)) == FALSE) break;
	dlg->reset();
	return retval;
}*/

bool ProtocolMgr::copy(const QStrList& src, const char *dest)
{ return init_transfer(src,dest,false);}

bool ProtocolMgr::init_transfer(const QStrList& src, const char *dest, bool move)
{
	askOverwrite = true;
	Protocol	*protSrc, *protDest;
	bool		needDel(false);
	QStrListIterator	it(src);
	KURL	urlDest(dest), urlSrc(it.current());
	protSrc = searchProtocol(urlSrc);
	protDest = searchProtocol(urlDest);
	if (protSrc == 0) {
		protSrc = createProtocol(urlSrc);
		needDel = true;
	}
	bool	retval = false;
	for ( ; it.current(); ++it) {
		urlSrc.parse(it.current());
		if ((retval = transfer(protSrc,protDest,urlSrc,urlDest,false,move)) == false) break;
	}
	dlg->reset();
	if (needDel) deleteProtocol(protSrc);
	return retval;
}

/*bool ProtocolMgr::thread_move(QStrList* src, const char *dest)
{
	askOverwrite = TRUE;
	QStrListIterator	it(*src);
	bool	retval = FALSE;
	for ( ; it.current(); ++it)
		if ((retval = transfer(it.current(),dest,FALSE,TRUE)) == FALSE) break;
	dlg->reset();
	return retval;
}*/

bool ProtocolMgr::move(const QStrList& src, const char *dest)
{ return init_transfer(src,dest,true);}

bool ProtocolMgr::thread_remove(Protocol *prot, QStrList* src)
{
	QStrListIterator	it(*src);
	bool			retval(true);
	int			c(0);
	KURL			url;
	activeProtocol = prot;
	for (;retval && it.current();++it,c++) {
		url.parse(it.current());
		if (url.url().right(1) == "/") retval = prot->rmdir(url.path(),dlg);
		else retval = prot->remove(url.path(),dlg);
	}
	if (!retval) {
		showError(QString(i18n("Unable to delete ") + QString(it.current())).data());
		while ((int)(src->count()) > (c-1)) src->removeLast();
	}
	activeProtocol = 0;
	dlg->reset();
	return retval;
}

bool ProtocolMgr::remove(Protocol *prot, QStrList& src)
{ return thread_routine1(PROTOCOL_REMOVE,(void*)prot,(void*)(&src));}

bool ProtocolMgr::thread_emptyTrash(Protocol *prot)
{
	activeProtocol = prot;
	bool	tmp = ((TrashProtocol*)prot)->empty(dlg);
	activeProtocol = 0;
	dlg->reset();
	if (!tmp) showError(i18n("Unable to empty trash"));
	return tmp;
}

bool ProtocolMgr::emptyTrash(Protocol *prot)
{ return thread_routine1(PROTOCOL_TRASH,(void*)prot);}

const char* ProtocolMgr::thread_getFile(Protocol *prot, KURL *url)
{
	activeProtocol = prot;
	const char	*retval = prot->getTempFile(url,dlg);
	dlg->reset();
	if (!retval) showError(0);
	activeProtocol = 0;
	return retval;
}

const char* ProtocolMgr::getFile(Protocol *prot, KURL& url)
{
	Protocol_Interface	*p = new Protocol_Interface(this,PROTOCOL_GETFILE,(void*)prot,(void*)(&url));
	thread_start(p);
	const char	*retval = (const char*)p->out;
	delete p;
	return retval;
}

bool ProtocolMgr::transfer(Protocol *protSrc, Protocol *protDest, KURL& src, KURL& dest, bool needHide, bool move)
{
cout << (move ? "moving " : "copying ") << src.url() << endl << " -> " << dest.url() << endl;
	QString		DestURL_dir(dest.directory()), SrcURL_url(src.url()), DestURL_url(dest.url());
	QString		FileName = SrcURL_url.right(SrcURL_url.length()-QMAX(SrcURL_url.findRev('/',SrcURL_url.length()-2),SrcURL_url.findRev(':',SrcURL_url.length()-2))-1);
	DestURL_dir += FileName;
	DestURL_url += FileName;
	if (DestURL_url == src.url() || src.url() == dest.url()) {
		QMessageBox::critical(ParentWidget,i18n("Error"),i18n("Can't copy a file onto itself"),QMessageBox::Ok | QMessageBox::Default,0);
		return false;
	}
	if (protDest->exists(DestURL_dir.data()) && askOverwrite) {
		QString		msg;
		msg.sprintf(i18n("%s already exists. Do you want to replace it ?"),DestURL_dir.data());
		int	result = QMessageBox::warning(ParentWidget,i18n("Warning"),msg.data(),i18n("Yes"),i18n("Yes to All"),i18n("Cancel"),0);
		switch (result) {
		  case 0 : break;
		  case 1 : askOverwrite = FALSE; break;
		  case 2 : return FALSE;
		}
	}
	return thread_routine1(PROTOCOL_TRANSFER,(void*)protSrc,(void*)protDest,(void*)(&src),(void*)(&dest),(void*)needHide,(void*)move);
}

bool ProtocolMgr::thread_transfer(Protocol *protSrc, Protocol *protDest, KURL* src, KURL* dest, bool needHide, bool move)
{
	bool	retval(true);
	if (protSrc->type() == Protocol::File || protSrc->type() == Protocol::Mount || protSrc->type() == Protocol::Trash) {
		activeProtocol = protDest;
		retval = protDest->copyToProtocol(src->path(),dest->path(),move,dlg);
	}
	else if (protDest->type() == Protocol::File || protDest->type() == Protocol::Mount || protDest->type() == Protocol::Trash) {
		activeProtocol = protSrc;
		retval = protSrc->copyFromProtocol(src->path(),dest->path(),move,dlg);
	}
	else {
		QString		tmp(getenv("TMP"));
		if (tmp.isEmpty()) tmp = "/tmp";
		activeProtocol = protSrc;
		retval = protSrc->copyFromProtocol(src->path(),tmp.data(),move,dlg);
		if (retval) {
			tmp += "/";
			tmp += src->filename();
			activeProtocol = protDest;
			retval = protDest->copyToProtocol(tmp.data(),dest->path(),move,dlg);
		}
	}
	if (!retval) showError(activeProtocol->errorMsg());
	activeProtocol = 0;
	if (needHide) dlg->reset();
	return retval;
}

bool ProtocolMgr::thread_routine1(int type, void *p1, void *p2, void *p3, void *p4, void *p5, void *p6)
{
	Protocol_Interface	*p = new Protocol_Interface(this,type,p1,p2,p3,p4,p5,p6);
	thread_start(p);
	bool	retval = (p->done && (bool)(p->out));
	delete p;
	return retval;
}

//--------------------------------------------------------------------------------------

void createErrorMsg(QString& msg)
{
	if (errno != 0) {
		msg.append(i18n("\nMessage from system : "));
		msg.append(strerror(errno));
	}
}

void ProtocolMgr::showError(const char *str)
{
	ErrorMsg = str;
	if (activeProtocol && !activeProtocol->isLocal()) {
		ErrorMsg += '\n';
		ErrorMsg += activeProtocol->errorMsg();
	}
	else createErrorMsg(ErrorMsg);
//	QMessageBox::critical(ParentWidget,i18n("Error"),msg.data(),QMessageBox::Ok | QMessageBox::Default,0);
}

ProtocolMgr::ProtocolMgr(QWidget *parent)
	: QObject(parent)
{
	protList = new QList<Protocol>;
	protList->setAutoDelete(true);
	tmpList = new QStrList(true);
	tmpList->setAutoDelete(true);
	ParentWidget = parent;
	activeProtocol = 0;
	dlg = new ProgressDlg(0,"Abort",100,parent,0,TRUE,0);
	dlg->resize(400,150);
	th_id = 0;
//	dlg->setMinimumDuration(500);
	QObject::connect(dlg,SIGNAL(cancelled()),parent,SLOT(abort()));
	protList->append(new SMBManager);
	protList->first()->setManager(this);
	CheckTimer = new QTimer(this);
	connect(CheckTimer,SIGNAL(timeout()),SLOT(checkTimer()));
	CheckTimer->start(CHECK_TIMEOUT);	// check protocols every 5 seconds
}

ProtocolMgr::~ProtocolMgr()
{
	QStrListIterator	it(*tmpList);
	for ( ; it.current(); ++it) {
		QString		cmd("rm -rf ");
		cmd += it.current();
		system(cmd.data());
	}
	delete tmpList;
	delete protList;
//	delete dlg;
}

Protocol* ProtocolMgr::searchProtocol(const KURL& url)
{
	QListIterator<Protocol>		it(*protList);
	Protocol	*prot(0);
	int		score(0);
	for ( ; it.current(); ++it)
		if (it.current()->matchURL(url) && it.current()->score() > score) { prot = it.current(); score = it.current()->score();}
if (prot) cout << "protocol : " << prot->prefix() << endl;
else cout << "no protocol found" << endl;
	return prot;
}

void ProtocolMgr::deleteProtocol(KURL& url)
{
	Protocol	*tmp = searchProtocol(url);
	if (tmp) protList->removeRef(tmp);
}

void ProtocolMgr::deleteProtocol(Protocol *prot)
{
	protList->removeRef(prot);
}

Protocol* ProtocolMgr::createProtocol(int type, const char *str1, const char *str2, const char *str3, const char *str4, const char *str5)
{
	Protocol	*prot = 0;
	switch (type) {
	   case Protocol::File: prot = new FileProtocol(str1); break;
	   case Protocol::Mount:
		if (!str2) return 0;
		prot = new MountProtocol(str1,str2,str3);
		break;
	   case Protocol::Smb:
		if (!str1 || !str2) return 0;
		prot = new SmbProtocol(str1,str2,str3,str4,str5);
		break;
	   case Protocol::Ftp:
		if (!str2) return 0;
		prot = new FtpProtocol(str1,str2,str3,str4,str5);
		break;
	   case Protocol::Trash: prot = new TrashProtocol(str1); break;
	   case Protocol::Zip:
	   case Protocol::Rpm:
	   case Protocol::Deb:
	   case Protocol::Tar: {
		KURL	url(str1);
		Protocol	*prot2 = searchProtocol(url);
		if (prot2 == 0) return 0;
		if (type == Protocol::Tar) prot = new TarProtocol(getFile(prot2,url),str1);
		else if (type == Protocol::Zip) prot = new ZipProtocol(getFile(prot2,url),str1);
		else if (type == Protocol::Rpm) prot = new RpmProtocol(getFile(prot2,url),str1);
// DEB
//		else if (type == Protocol::Deb) prot = new DebProtocol(getFile(prot2,url),str1);
// DEB
		break;
	   }
	   case Protocol::SmbMach:
		prot = new SMBMachine(str1,str2,str3);
		break;
	   case Protocol::SmbShare:
		if (!str1 || !str2 || !str3 || !str4 || !str5) return 0;
		prot = new SMBShare(str1,str2,str3,str4,str5);
		break;
	}
	protList->append(prot);
	prot->setupMime(ExtDict,NameDict,Magic,UseMagic);
	prot->setupSubProtList(subProtList);
	prot->setManager(this);
	return prot;
}

Protocol* ProtocolMgr::createProtocol(KURL& url)
{
	if (strncmp(url.protocol(),"file",4) == 0) return createProtocol(Protocol::File);
//	else if (strncmp(url.protocol(),"ftp",3) == 0) return createProtocol(Protocol::Ftp,url.host(),url.directory(),url.user(),url.passwd());
	else return 0;
}

const char *ProtocolMgr::getFile(const char *url)
{
	KURL		Url(url);
	Protocol	*prot = searchProtocol(Url);
	if (prot != 0) return getFile(prot,Url);
	else return 0;
}

const FileInfoList* ProtocolMgr::list(const char *url, bool hidden, bool dirsOnly, bool showArchive)
{
	KURL	URL(url);
	Protocol	*prot = searchProtocol(URL);
	if (prot != 0) return list(prot,URL,hidden,dirsOnly,showArchive);
	else return 0;
}

void ProtocolMgr::abort()
{
cout << "aborting" << endl;
	if (activeProtocol != 0 && th_id != 0) {
		if (pthread_cancel(th_id) == 0) cout << "cancellation successful" << endl;
cout << "waiting thread termination ... " << flush;
		pthread_join(th_id,0);	// waiting for thread termination
cout << "done" << endl;
	}
	else return;
	th_id = 0;
	activeProtocol = 0;
}

bool ProtocolMgr::rename(const char *src, const char *dest)
{
	KURL		Src(src),Dest(dest);
	Protocol	*prot = searchProtocol(Src);
	if (prot != 0) return rename(prot,Src,Dest);
	else return FALSE;
}

bool ProtocolMgr::chmod(const char *url, int perm)
{
	KURL	Url(url);
	Protocol	*prot = searchProtocol(Url);
	if (prot) return chmod(prot,Url,perm);
	else return FALSE;
}

bool ProtocolMgr::chown(const char *url, const char *owner, const char *group)
{
	KURL	Url(url);
	Protocol	*prot = searchProtocol(Url);
	if (prot) return chown(prot,Url,owner,group);
	else return FALSE;
}

bool ProtocolMgr::mkdir(const char *url)
{
	KURL	Url(url);
	Protocol	*prot = searchProtocol(Url);
	if (prot) return mkdir(prot,Url);
	else return FALSE;
}

void ProtocolMgr::setupMime(KMimeExtDict *extDict, KMimeExtList *nameDict, MimeMagic *magic, bool use)
{
	ExtDict = extDict;
	NameDict = nameDict;
	Magic = magic;
	UseMagic = use;
	QListIterator<Protocol>		it(*protList);
	for (;it.current();++it) it.current()->setupMime(ExtDict,NameDict,Magic,UseMagic);
}

void ProtocolMgr::setupSubProtList(SubProtList *list)
{
	subProtList = list;
	QListIterator<Protocol>		it(*protList);
	for (;it.current();++it) it.current()->setupSubProtList(list);
}

bool ProtocolMgr::remove(QStrList& src)
{
	KURL	Url(src.first());
	Protocol	*prot = searchProtocol(Url);
	if (prot) return remove(prot,src);
	else return FALSE;
}

void ProtocolMgr::loadImage(FileInfo *fi, int save, int size)
{
	KURL	url(fi->absFilePath());
	Protocol	*prot = searchProtocol(url);
	activeProtocol = prot;
	prot->loadImage(fi,save,size);
	activeProtocol = 0;
}

bool ProtocolMgr::event(QEvent *e)
{
	switch (e->type()) {
	   case Event_Message:
		emit message(((QMessageEvent*)e)->message());
		return true;
	   default: return false;
	}
}

void ProtocolMgr::checkTimer()
{
	if (activeProtocol) return;	// don't do anything while working
	// check all idle protocols for connection
	QListIterator<Protocol>		it(*protList);
	for (;it.current();++it)
		if (it.current() != activeProtocol && !it.current()->check()) emit protocolClosed(it.current());
}
