#ifndef _MIMEMAGIC_H_
#define _MIMEMAGIC_H_

#include <unistd.h>
#include <qstring.h>
#include <qlist.h>
#include <ctype.h>

class MimeMagic;

class MagicNumber
{
public:
	MagicNumber(const QString& line, MagicNumber *parent);
	~MagicNumber();
	bool match(int fd, QString& str);

	int		offset;
	int		len;
	char		*data, *data2;
	QString		text;
	QList<MagicNumber>	childs;
	MagicNumber		*parent;
	int			layer;
};

inline bool MagicNumber::match(int fd, QString& str)
{
	if (::lseek(fd,offset,SEEK_SET) < 0) return FALSE;
	if (::read(fd,data2,len) < len) return FALSE;
	if (memcmp(data,data2,len) != 0) return FALSE;
	bool	retval = TRUE;
	str += text;
	if (childs.count() > 0) {
		QListIterator<MagicNumber>	it(childs);
		for ( ; it.current(); ++it) it.current()->match(fd,str);
	}
	return retval;
}

class MimeMagic
{
public:
	MimeMagic(const char *magic = 0);
	void setMagicFile(const char *magic);
	const char* getMimeType(const char *filename);
	bool parseMagicFile(const char *magic);

private:
	QList<MagicNumber>	list;
	QString			result;
};

#endif

