/**********************************************************************

	--- Qt Architect generated file ---

	File: PropertyDlg.cc
	Last generated: Mon Feb 8 16:52:10 1999

	DO NOT EDIT!!!  This file will be automatically
	regenerated by qtarch.  All changes will be lost.

 *********************************************************************/

#include "PropertyDlg.h"

#define Inherited QDialog

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <kapp.h>

// forward declaration
QString processPath(const QString& str, int w, const QFontMetrics& fm);

PropertyDlg::PropertyDlg
(
	FileInfo *fi,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, TRUE, 0 ), Changed(FALSE)
{
	Info = fi;

	QButtonGroup* dlgedit_GroupPerm;
	dlgedit_GroupPerm = new QButtonGroup( i18n("Permissions"), this, "GroupPerm" );
	dlgedit_GroupPerm->setGeometry( 10, 160, 310, 150 );
	dlgedit_GroupPerm->setFrameStyle( 49 );

	QLabel* dlgedit_LabelName;
	dlgedit_LabelName = new QLabel( i18n("Name :"), this, "LabelName" );
	dlgedit_LabelName->setGeometry( 30, 20, 100, 20 );
	dlgedit_LabelName->setAlignment(AlignRight | AlignVCenter);

	QLabel* dlgedit_LabelPath;
	dlgedit_LabelPath = new QLabel( i18n("Path :"), this, "LabelPath" );
	dlgedit_LabelPath->setGeometry( 30, 40, 100, 20 );
	dlgedit_LabelPath->setAlignment(AlignRight | AlignVCenter);

	if (fi->isSymLink()) {
		QLabel* dlgedit_LabelLink;
		dlgedit_LabelLink = new QLabel( i18n("Symbolic link :"), this, "LabelLink" );
		dlgedit_LabelLink->setGeometry( 30, 100, 100, 20 );
		dlgedit_LabelLink->setAlignment(AlignRight | AlignVCenter);

		QLabel* dlgedit_FileLink;
		dlgedit_FileLink = new QLabel( fi->readLink().data(), this, "FileLink" );
		dlgedit_FileLink->setGeometry( 140, 100, 190, 20 );
	}

	QLabel* dlgedit_LabelType;
	dlgedit_LabelType = new QLabel( i18n("Type :"), this, "LabelType" );
	dlgedit_LabelType->setGeometry( 30, 60, 100, 20 );
	dlgedit_LabelType->setAlignment(AlignRight | AlignVCenter);

	QLabel* dlgedit_LabelSize;
	dlgedit_LabelSize = new QLabel( i18n("Size :"), this, "LabelSize" );
	dlgedit_LabelSize->setGeometry( 30, 80, 100, 20 );
	dlgedit_LabelSize->setAlignment(AlignRight | AlignVCenter);

	if (fi->isDir()) {
		dlgedit_Content = new QPushButton( i18n("Content"), this, "Content" );
		dlgedit_Content->setGeometry( 250, 80, 80, 20 );
		dlgedit_Content->setToggleButton( TRUE );
		connect(dlgedit_Content,SIGNAL(clicked()),SLOT(contentToggled()));
	}

	QLabel* dlgedit_LabelRead;
	dlgedit_LabelRead = new QLabel( i18n("Read"), this, "LabelRead" );
	dlgedit_LabelRead->setGeometry( 100, 180, 70, 20 );
	dlgedit_LabelRead->setAlignment(AlignCenter);

	QLabel* dlgedit_LabelWrite;
	dlgedit_LabelWrite = new QLabel( i18n("Write"), this, "LabelWrite" );
	dlgedit_LabelWrite->setGeometry( 160, 180, 70, 20 );
	dlgedit_LabelWrite->setAlignment(AlignCenter);

	QLabel* dlgedit_LabelExecute;
	dlgedit_LabelExecute = new QLabel( i18n("Execute"), this, "LabelExecute" );
	dlgedit_LabelExecute->setGeometry( 220, 180, 80, 20 );
	dlgedit_LabelExecute->setAlignment(AlignCenter);

	QLabel* dlgedit_LabelOwnerPerm;
	dlgedit_LabelOwnerPerm = new QLabel( i18n("Owner"), this, "LabelOwnerPerm" );
	dlgedit_LabelOwnerPerm->setGeometry( 20, 210, 80, 20 );

	QLabel* dlgedit_LabelGroupPerm;
	dlgedit_LabelGroupPerm = new QLabel( i18n("Group"), this, "LabelGroupPerm" );
	dlgedit_LabelGroupPerm->setGeometry( 20, 240, 80, 20 );

	QLabel* dlgedit_LabelOthersPerm;
	dlgedit_LabelOthersPerm = new QLabel( i18n("Others"), this, "LabelOthersPerm" );
	dlgedit_LabelOthersPerm->setGeometry( 20, 270, 80, 20 );

	QLabel* dlgedit_LabelOwner;
	dlgedit_LabelOwner = new QLabel( i18n("Owner :"), this, "LabelOwner" );
	dlgedit_LabelOwner->setGeometry( 10, 130, 90, 20 );

	QLabel* dlgedit_LabelGroup;
	dlgedit_LabelGroup = new QLabel( i18n("Group :"), this, "LabelGroup" );
	dlgedit_LabelGroup->setGeometry( 160, 130, 90, 20 );

	dlgedit_CheckRO = new QCheckBox( this, "CheckRO" );
	dlgedit_CheckRO->setGeometry( 130, 205, 20, 30 );
	dlgedit_CheckRO->setChecked(fi->permissions(S_IRUSR));

	dlgedit_CheckWO = new QCheckBox( this, "CheckWO" );
	dlgedit_CheckWO->setGeometry( 190, 205, 20, 30 );
	dlgedit_CheckWO->setChecked(fi->permissions(S_IWUSR));

	dlgedit_CheckXO = new QCheckBox( this, "CheckXO" );
	dlgedit_CheckXO->setGeometry( 250, 205, 20, 30 );
	dlgedit_CheckXO->setChecked(fi->permissions(S_IXUSR));

	dlgedit_CheckRG = new QCheckBox( this, "CheckRG" );
	dlgedit_CheckRG->setGeometry( 130, 235, 20, 30 );
	dlgedit_CheckRG->setChecked(fi->permissions(S_IRGRP));

	dlgedit_CheckWG = new QCheckBox( this, "CheckWG" );
	dlgedit_CheckWG->setGeometry( 190, 235, 20, 30 );
	dlgedit_CheckWG->setChecked(fi->permissions(S_IWGRP));

	dlgedit_CheckXG = new QCheckBox( this, "CheckXG" );
	dlgedit_CheckXG->setGeometry( 250, 235, 20, 30 );
	dlgedit_CheckXG->setChecked(fi->permissions(S_IXGRP));

	dlgedit_CheckRW = new QCheckBox( this, "CheckRW" );
	dlgedit_CheckRW->setGeometry( 130, 265, 20, 30 );
	dlgedit_CheckRW->setChecked(fi->permissions(S_IROTH));

	dlgedit_CheckWW = new QCheckBox( this, "CheckWW" );
	dlgedit_CheckWW->setGeometry( 190, 265, 20, 30 );
	dlgedit_CheckWW->setChecked(fi->permissions(S_IWOTH));

	dlgedit_CheckXW = new QCheckBox( this, "CheckXW" );
	dlgedit_CheckXW->setGeometry( 250, 265, 20, 30 );
	dlgedit_CheckXW->setChecked(fi->permissions(S_IXOTH));

/*	QLabel* dlgedit_FileName;
	dlgedit_FileName = new QLabel( fi->fileName().data(), this, "FileName" );
	dlgedit_FileName->setGeometry( 140, 20, 190, 20 );
*/
	FileName = new QLineEdit(this, "FileName");
	FileName->setGeometry(140,20,190,20);
	FileName->setText(fi->fileName().data());

	QLabel* dlgedit_FilePath;
	dlgedit_FilePath = new QLabel( processPath(fi->absFilePath(),190,fontMetrics()), this, "FilePath" );
	dlgedit_FilePath->setGeometry( 140, 40, 190, 20 );

	QLabel* dlgedit_FileType;
	dlgedit_FileType = new QLabel( fi->description(), this, "FileType" );
	dlgedit_FileType->setGeometry( 140, 60, 190, 20 );

	dlgedit_FileSize = new QLabel( this, "FileSize" );
	dlgedit_FileSize->setGeometry( 140, 80, 110, 20 );
	QString	str;
	str.setNum(fi->size());
	dlgedit_FileSize->setText( str.data() );

/*	QLabel* dlgedit_FileOwner;
	dlgedit_FileOwner = new QLabel( fi->owner(), this, "FileOwner" );
	dlgedit_FileOwner->setGeometry( 100, 130, 60, 20 );

	QLabel* dlgedit_FileGroup;
	dlgedit_FileGroup = new QLabel( fi->group(), this, "FileGroup" );
	dlgedit_FileGroup->setGeometry( 250, 130, 60, 20 );
*/
	FileOwner = new QLineEdit(this, "FileOwner");
	FileOwner->setGeometry( 100, 130, 55, 20 );
	FileOwner->setText(fi->owner());
	FileGroup = new QLineEdit(this, "FileGroup");
	FileGroup->setGeometry( 250, 130, 55, 20 );
	FileGroup->setText(fi->group());

	QLabel* dlgedit_FileIcon;
	dlgedit_FileIcon = new QLabel( this, "FileIcon" );
	dlgedit_FileIcon->setGeometry( 20, 40, 50, 50 );
	if (fi->icon()) dlgedit_FileIcon->setPixmap(*(fi->icon()));

	QPushButton* dlgedit_ButtonCancel;
	dlgedit_ButtonCancel = new QPushButton( i18n("Cancel"), this, "ButtonCancel" );
	dlgedit_ButtonCancel->setGeometry( 230, 320, 90, 30 );
	connect( dlgedit_ButtonCancel, SIGNAL(clicked()), SLOT(reject()) );

	QPushButton* dlgedit_ButtonOk;
	dlgedit_ButtonOk = new QPushButton( i18n("Ok"), this, "ButtonOk" );
	dlgedit_ButtonOk->setGeometry( 130, 320, 90, 30 );
	connect( dlgedit_ButtonOk, SIGNAL(clicked()), SLOT(accept()) );
	dlgedit_ButtonOk->setDefault(true);

	dlgedit_GroupPerm->insert( dlgedit_CheckRO );
	dlgedit_GroupPerm->insert( dlgedit_CheckWO );
	dlgedit_GroupPerm->insert( dlgedit_CheckXO );
	dlgedit_GroupPerm->insert( dlgedit_CheckRG );
	dlgedit_GroupPerm->insert( dlgedit_CheckWG );
	dlgedit_GroupPerm->insert( dlgedit_CheckXG );
	dlgedit_GroupPerm->insert( dlgedit_CheckRW );
	dlgedit_GroupPerm->insert( dlgedit_CheckWW );
	dlgedit_GroupPerm->insert( dlgedit_CheckXW );
	connect(dlgedit_CheckRO,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckWO,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckXO,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckRG,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckWG,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckXG,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckRW,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckWW,SIGNAL(clicked()),SLOT(changed()));
	connect(dlgedit_CheckXW,SIGNAL(clicked()),SLOT(changed()));

	resize( 340,360 );
	setCaption(i18n("File properties"));
	setMinimumSize( 340, 360 );
	setMaximumSize( 340, 360 );
}


PropertyDlg::~PropertyDlg()
{
}

#include <stdio.h>
#include <kurl.h>

void PropertyDlg::contentToggled()
{
	QString		str;
	if (dlgedit_Content->isOn()) {
		setCursor(waitCursor);
		int	size(0);
		KURL	url(Info->absFilePath());
		QString		cmd("du -sk ");
		if (strcmp(url.protocol(),"file") == 0) {
			cmd += url.path();
			FILE	*f = popen(cmd.data(),"r");
			int	result(0);
			while ((result = fscanf(f,"%d",&size)) == 0 && result != EOF) usleep(50000);
			pclose(f);
		}
		str.setNum(size);
		str += " Kbytes";
		dlgedit_FileSize->setText(str.data());
		setCursor(arrowCursor);
	}
	else {
		str.setNum(Info->size());
		dlgedit_FileSize->setText(str.data());
	}
}

int PropertyDlg::permissions()
{
	int	mode = 0;
	if (dlgedit_CheckRO->isChecked()) mode |= S_IRUSR;
	if (dlgedit_CheckWO->isChecked()) mode |= S_IWUSR;
	if (dlgedit_CheckXO->isChecked()) mode |= S_IXUSR;
	if (dlgedit_CheckRG->isChecked()) mode |= S_IRGRP;
	if (dlgedit_CheckWG->isChecked()) mode |= S_IWGRP;
	if (dlgedit_CheckXG->isChecked()) mode |= S_IXGRP;
	if (dlgedit_CheckRW->isChecked()) mode |= S_IROTH;
	if (dlgedit_CheckWW->isChecked()) mode |= S_IWOTH;
	if (dlgedit_CheckXW->isChecked()) mode |= S_IXOTH;
	return mode;
}

//---------------------------------------------------------------------------------------------------------

QString processPath(const QString& str, int w, const QFontMetrics& fm)
{
	QString	out(str.data());
	int	p1 = out.findRev('/',out.length()-2), p2;
	while (fm.width(out.data()) > w) {
		p2 = out.findRev('/',p1-1);
		if (p1 != -1 && p2 != -1) out.replace(p2+1,p1-p2-1,"...");
		else break;
		p1 = p2;
	}
	return out;
}
