#include "OptionsSMB2.h"

OptionsSMB2::OptionsSMB2(QWidget *parent, const char *name)
  : QWidget(parent,name)
{
  UseWINS = new QCheckBox(i18n("Use WINS server"),this);
  WINS_Server = new QLineEdit(this);
  for (int i=0;i<4;i++)
    {
      IP[i] = new QLineEdit(this);
      IP[i]->setMaxLength(3);
    }
  ServerLabel = new QLabel(i18n("WINS server name"),this);
  IPLabel = new QLabel(i18n("WINS server IP"),this);
  connect(UseWINS,SIGNAL(clicked()),SLOT(useWINSToggle()));
}

OptionsSMB2::~OptionsSMB2()
{
}

void OptionsSMB2::resizeEvent(QResizeEvent *)
{
  int w=(width()-40)/2;
  UseWINS->setGeometry(10,10,width()-20,25);
  ServerLabel->setGeometry(20,45,w,25);
  IPLabel->setGeometry(20,80,w,25);
  WINS_Server->setGeometry(20+w,45,w,25);
  int w2=(w-15)/4;
  for (int i=0, c=20+w;i<4;i++,c+=(w2+5)) IP[i]->setGeometry(c,80,w2,25);
}

void OptionsSMB2::useWINSToggle()
{
  bool check = UseWINS->isChecked();
  WINS_Server->setEnabled(check);
  for (int i=0;i<4;i++) IP[i]->setEnabled(check);
}

void OptionsSMB2::writeSMB()
{
  kapp->getConfig()->setGroup("SMB Config");
  kapp->getConfig()->writeEntry("UseWINS",UseWINS->isChecked());
  kapp->getConfig()->writeEntry("WINS_Server",WINS_Server->text());
  QString IPStr;
  IPStr.sprintf("%s.%s.%s.%s",IP[0]->text(),IP[1]->text(),IP[2]->text(),IP[3]->text());
  kapp->getConfig()->writeEntry("WINS_IP",IPStr.data());
}

void OptionsSMB2::readSMB()
{
  kapp->getConfig()->setGroup("SMB Config");
  UseWINS->setChecked(kapp->getConfig()->readBoolEntry("UseWINS",false));
  WINS_Server->setText(kapp->getConfig()->readEntry("WINS_Server","UNKNOWN").data());
  QString IPStr = kapp->getConfig()->readEntry("WINS_IP","127.0.0.1");
  int ip[4];
  sscanf(IPStr,"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]);
  for (int i=0;i<4;i++)
    {
      QString num;
      num.sprintf("%d",ip[i]);
      IP[i]->setText(num.data());
    }
  useWINSToggle();
}
