#include "OptionsSMB.h"
#include <kapp.h>
#include <qstring.h>

OptionsSMB::OptionsSMB(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	resize(385,330);

	BroadCastListView = new QListView(this);
	BroadCastListView->addColumn(i18n("Broadcast IP"));
	BroadCastListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	BroadCastListView->setLineWidth(2);
	BroadCastListView->setSorting(-1);
	connect(BroadCastListView,SIGNAL(selectionChanged(QListViewItem*)),SLOT(selectionChanged(QListViewItem*)));
	ComputerListView = new QListView(this);
	ComputerListView->addColumn(i18n("Computers"));
	ComputerListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ComputerListView->setLineWidth(2);
	ComputerListView->setSorting(-1);
	connect(ComputerListView,SIGNAL(selectionChanged(QListViewItem*)),SLOT(selectionChanged(QListViewItem*)));

	IPType = new QComboBox(this);
	IPType->insertItem(i18n("Broadcast"));
	IPType->insertItem(i18n("Computer"));

	BroadCastList.setAutoDelete(false);
	ComputerList.setAutoDelete(false);
	Modified = false;
	CurrentView = 0;

	for (int i=0;i<4;i++) {
		IP[i] = new QLineEdit(this);
		IP[i]->setMaxLength(3);
	}

	IPLabel = new QLabel(i18n("IP"),this);

	Add = new QPushButton(i18n("Add"),this);
	connect(Add,SIGNAL(clicked()),SLOT(addClicked()));
	Remove = new QPushButton(i18n("Remove"),this);
	connect(Remove,SIGNAL(clicked()),SLOT(removeClicked()));
	Update = new QPushButton(i18n("Update"),this);
	connect(Update,SIGNAL(clicked()),SLOT(updateClicked()));

	ShowHiddenShares = new QCheckBox(i18n("Show hidden shares"),this);

	SambaVersion = new QComboBox(this);
	SambaVersion->insertItem("2.0.3");
	SambaVersion->insertItem("2.0.5a");
	SambaVersion->insertItem("2.0.6");
	SambaLabel = new QLabel(i18n("Samba version :"),this);
}

OptionsSMB::~OptionsSMB()
{
}

void OptionsSMB::addClicked()
{
	QString		StartStr;
	StartStr.sprintf("%s.%s.%s.%s",IP[0]->text(),IP[1]->text(),IP[2]->text(),IP[3]->text());
	QListViewItem	*item = new QListViewItem(selectView(),StartStr.data());
	selectList()->insert(0,item);
	selectView()->setSelected(selectView()->currentItem(),false);
	Modified = true;
	clearAll();
}

void OptionsSMB::removeClicked()
{
	QListViewItem	*it = (CurrentView ? CurrentView->currentItem() : 0);
	if (it) {
		if (CurrentView == BroadCastListView) BroadCastList.removeRef(it);
		else ComputerList.removeRef(it);
		delete it;
		Modified = true;
		clearAll();
	}
}

void OptionsSMB::updateClicked()
{
	QListViewItem	*it = (CurrentView ? CurrentView->currentItem() : 0);
	if (it) {
		QString		StartStr;
		StartStr.sprintf("%s.%s.%s.%s",IP[0]->text(),IP[1]->text(),IP[2]->text(),IP[3]->text());
		it->setText(0,StartStr.data());
		CurrentView->setSelected(CurrentView->currentItem(),false);
		Modified = true;
		clearAll();
	}
}

void OptionsSMB::resizeEvent(QResizeEvent*)
{
	int	h = (height()-20)/2, w = (width()-30)/2;
	BroadCastListView->setGeometry(10,10,w,h);
	ComputerListView->setGeometry(20+w,10,w,h);
	w = (BroadCastListView->width()-4)/2;
	BroadCastListView->setColumnWidth(0,2*w);
	ComputerListView->setColumnWidth(0,2*w);
	int	space = (h-105)/4, current = 10+h+space;
	IPLabel->setGeometry(10,current,70,25);
	for (int p=80,i=0;i<4;i++,p+=40) IP[i]->setGeometry(p,current,30,25);
	IPType->setGeometry(80+4*40+10,current,width()-20-80-4*40,25);
	current += (25+space);
	int	space2 = (width()-20-3*80)/2;
	Add->setGeometry(10,current,80,30);
	Remove->setGeometry(90+space2,current,80,30);
	Update->setGeometry(170+2*space2,current,80,30);
	current += (30+space);
	ShowHiddenShares->setGeometry(10,current,width()-20,25);
	current += (25+space);
	w = (width()-20)/2;
	SambaLabel->setGeometry(10,current,w,25);
	SambaVersion->setGeometry(10+w,current,w,25);
}

void OptionsSMB::clearAll()
{
	for (int i=0;i<4;i++) IP[i]->setText(0);
}

void OptionsSMB::selectionChanged(QListViewItem *item)
{
	if (!item->isSelected()) return;	// don't process if unselection
	QString		StartStr = item->text(0);
	int		IPI[4];
	sscanf(StartStr,"%d.%d.%d.%d",&IPI[0],&IPI[1],&IPI[2],&IPI[3]);
	for (int i=0;i<4;i++) {
		QString		num;
		num.setNum(IPI[i]);
		IP[i]->setText(num.data());
	}
	IPType->setCurrentItem((item->listView() == BroadCastListView ? 0 : 1));
	if (CurrentView && CurrentView != item->listView()) CurrentView->setSelected(CurrentView->currentItem(),false);
	CurrentView = item->listView();
}

void OptionsSMB::readSMB()
{
	KConfig	*conf = kapp->getConfig();
	conf->setGroup("Configuration");
	QStrList	start;
	start.setAutoDelete(true);
	conf->readListEntry("BroadCastIP",start);
	for (start.first();start.current();start.next()) {
		QListViewItem	*item = new QListViewItem(BroadCastListView,start.current());
		BroadCastList.insert(0,item);
	}
	start.clear();
	conf->readListEntry("ComputerIP",start);
	for (start.first();start.current();start.next()) {
		QListViewItem	*item = new QListViewItem(ComputerListView,start.current());
		ComputerList.insert(0,item);
	}
	ShowHiddenShares->setChecked(conf->readBoolEntry("ShowHiddenShares",false));
	Modified = false;
}

void OptionsSMB::writeSMB()
{
	KConfig	*conf = kapp->getConfig();
	conf->setGroup("Configuration");
	if (Modified) {
		QStrList	start;
		start.setAutoDelete(true);
		QListIterator<QListViewItem>	it(BroadCastList);
		for (;it.current();++it) start.append(it.current()->text(0));
		conf->writeEntry("BroadCastIP",start);
		start.clear();
		QListIterator<QListViewItem>	it2(ComputerList);
		for (;it2.current();++it2) start.append(it2.current()->text(0));
		conf->writeEntry("ComputerIP",start);
	}
	conf->writeEntry("ShowHiddenShares",ShowHiddenShares->isChecked());
	Modified = false;
}
