#include "OptionsMisc.h"
#include <kapp.h>

OptionsMisc::OptionsMisc(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	DefaultEdit = new QCheckBox(i18n("Edit on double-click for unknown files"),this);
	lab[0] = new QLabel(i18n("Edit application :"),this);
	EditApplication = new QLineEdit(this);
	PasswdSaving = new QCheckBox(i18n("Save passwords on exit"),this);
	MouseTracking = new QCheckBox(i18n("Change mouse icon over file items"),this);
	SortingExtended = new QCheckBox(i18n("Use extended sorting schemes"),this);
	lab[1] = new QLabel(i18n("History size :"),this);
	HistorySize = new QLineEdit(this);
	lab[2] = new QLabel(i18n("URL Toolbar style :"),this);
	URLToolBarStyle = new QComboBox(this);
	URLToolBarStyle->insertItem(i18n("Icon"));
	URLToolBarStyle->insertItem(i18n("Icon and text"));
	URLToolBarStyle->insertItem(i18n("Text"));
	SingleClick = new QCheckBox(i18n("Open on single click (KFM style)"),this);
	TreeFollow = new QCheckBox(i18n("Directory tree follows browsing"),this);
	AppsInSubMenu = new QCheckBox(i18n("Show associated applications in sub-menu"),this);
}

void OptionsMisc::resizeEvent(QResizeEvent*)
{
	int	s = (height()-20-10*25)/9, h = 10, w = width()-20;
	DefaultEdit->setGeometry(10,h,w,25);
	h += (25+s);
	lab[0]->setGeometry(10,h,w/2,25);
	EditApplication->setGeometry(width()/2,h,w/2,25);
	h += (25+s);
	PasswdSaving->setGeometry(10,h,w,25);
	h += (25+s);
	MouseTracking->setGeometry(10,h,w,25);
	h += (25+s);
	SortingExtended->setGeometry(10,h,w,25);
	h += (25+s);
	lab[1]->setGeometry(10,h,w/2,25);
	HistorySize->setGeometry(width()/2,h,w/2,25);
	h += (25+s);
	lab[2]->setGeometry(10,h,w/2,25);
	URLToolBarStyle->setGeometry(width()/2,h,w/2,25);
	h += (25+s);
	SingleClick->setGeometry(10,h,w,25);
	h += (25+s);
	TreeFollow->setGeometry(10,h,w,25);
	h += (25+s);
	AppsInSubMenu->setGeometry(10,h,w,25);
}
