#ifndef _LINEDLG_H_
#define _LINEDLG_H_

#include <qdialog.h>
#include <klined.h>
#include <qpushbutton.h>
#include <qlabel.h>

#include "filecompletion.h"

class LineDlg : public QDialog
{
	Q_OBJECT;

public:
	LineDlg(QWidget *parent = 0, const char *name = 0, int nLines = 1);
	virtual ~LineDlg() {}

	const char* text(int i = 1) { return EditText[i-1]->text();}
	void setLabel(const char *text, int i = 1) { Label[i-1]->setText(text);}
	void setText(const char *text, int i = 1, bool selected = false) { EditText[i-1]->setText(text); if (selected) EditText[i-1]->selectAll();}
	void setPasswd() { EditText[NLines-1]->setEchoMode(QLineEdit::Password);}
	void enableCompletion();

protected:
	QLabel		*Label[2];
	KLined		*EditText[2];
	FileCompletion	*Completion;
	int		NLines;

protected slots:
	void tabPressed();
};

#endif