/*
 *  libbab.h -- BabyTrans ( Babylon Translator front-end for GTK )
 *
 *  Copyright (C) September 1999  Frederic Jolliton -- <fjolliton@chez.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef LIBBAB_H
#define LIBBAB_H

typedef struct bab_def{
    struct bab_def* next ;
    char* word ;
    char* attrib ;
    char* definition ;
} bab_def;

/* #define FILE_READ_BINARY "rb" for MS-DOS*/
#define FILE_READ_BINARY "r"
#define PATH_SEPARATOR "/"
#define MAX_WORD_LENGTH 63

#include <stdio.h>
#include <htmlview.h>
#include <kclipboard.h>
#include "transc.h"

  /** Reads and interprets the Babylon databases
*/
class BabylonC:public TransC
{
  private:
  char *word;
  size_t word_length;
  int bab_init;
  FILE *file_idx;
  FILE *file_def;
  char attrib_data[14+1];

  public:
  BabylonC(const char *Directory="",const char *Filename = ""); // Initialisation
  ~BabylonC(); // Cleanup
  int html(KHTMLView *html,const char *p_word);

  private:
  int babFree( struct bab_def* def );
  bab_def *babDefinition( const char * p_word );
  long babIndex( const char* word ); // Compute a index from word's first 3 characters
  char bab_to_char( int c );
  void babReadDef( char* dst , FILE* src , int size );
  bab_def *babMakeDef( FILE* file_def , fpos_t pos );
  bab_def *babMain( const char* word );
};

#endif /* LIBBAB_H */
