#ifndef _KPSTREE_H
#define _KPSTREE_H

/*=============================================================================
  HEADERs
 =============================================================================*/
#include <qmenubar.h>
#include <qlist.h>
#include <qpopmenu.h>
#include <qlayout.h>
#include <qcombo.h>

#include <kfm.h>
#include <kapp.h>
#include <kurl.h>
#include <klocale.h>
#include <kpanner.h>

#include "ptree.h"

/*=============================================================================
  MENU ITEM IDs
 =============================================================================*/
#define ID_FILE_NEWWIN     1
#define ID_FILE_QUIT       2

#define ID_SORT_NAME      41
#define ID_SORT_PID       42

#define ID_REFRESH        50
#define ID_ROOT           51
#define ID_CUT            52

#define ID_VIEW_TOOLBAR   60
#define ID_VIEW_STATUSBAR 61

#define ID_RELOAD         70

#define ID_HELP_ABOUT    100
#define ID_HELP_HELP     101

/*=============================================================================
  CLASS KpstreeWidget : public KTopLevelWidget
 =============================================================================*/
class KpstreeWidget : public KTopLevelWidget {

  Q_OBJECT
    
public:
    KpstreeWidget();
   ~KpstreeWidget();
   
public slots:
    void    menuCallback(int);
    void    refreshCallback(int);
    void    procHighlighted(int);
protected:

    int    init        (void);
    void   closeEvent  (QCloseEvent *); 
    void   timerEvent  (QTimerEvent *);

    static QList<KpstreeWidget> windowList;

private:
    int          winID;
    KToolBar    *toolbar;
    KStatusBar  *statusBar;
    KMenuBar    *menu;
    KFM         *kfm;
    KPanner     *panner;
    ProcTree    *plist;
    QPopupMenu  *sort;
    QPopupMenu  *refresh;

    bool        nameSort;

           int           initGUI            ( void );
           void          refreshProcList    ( void );
	   void          sortProcList       ( void );
	   void          sortUpdateProcList ( void );
	   void          changeProcListRoot ( void );
           void          readProcDir        ( void );

    static void          reorderProcList    ( ProcTree* , ProcTree* );
    static ProcTreeItem* getParentItem      ( ProcTreeItem* , int ); 
    static ProcTreeItem* sortProcListByName ( ProcTreeItem* );
    static ProcTreeItem* sortProcListByPid  ( ProcTreeItem* );

};

#endif



