/*=============================================================================
  KDE - kpstree
  Nicolas Leclercq <nicknet@planete.net>
  
    * v0.1.0 ::  17.01.98 :: 
     first beta release with dirty code
    
    * v0.2.0 ::  22.01.98 :: 
      + better code 
      + remove proc from list
      + 
 
    *
    
 =============================================================================*/

/*=============================================================================
  HEADERs
 =============================================================================*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <getopt.h>
#include <pwd.h>
#include <dirent.h>
#include <termios.h>
#include <termcap.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#include <qpopmenu.h>
#include <qkeycode.h>
#include <qaccel.h> 
#include <qfiledlg.h> 
#include <qmsgbox.h>
#include <qlayout.h> 

#include <kmsgbox.h>  
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kwm.h>
#include <kpanner.h>

#include "klocale.h"
#include "kpstree.h"
#include "comm.h"

/*-----------------------------------------------------------------------------
  #DEFINEs
 -----------------------------------------------------------------------------*/
#define PROC_BASE    "/proc"
#define INIT_PID     1

/*-----------------------------------------------------------------------------
  GLOBALs
 -----------------------------------------------------------------------------*/
QList<KpstreeWidget> KpstreeWidget::windowList;

static const char *refreshrates[] = {
    "No autorefresh",
    "Every second", 
    "Every two seconds", 
    "Every three seconds",
    "Every five seconds", 
    "Every ten seconds", 0 };

static const int timer[] = {
    0, 1000, 2000, 3000, 5000, 10000 };


/*=============================================================================
 Class :  KpstreeWidget:KTopLevelWidget
 =============================================================================*/
/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::init
 -----------------------------------------------------------------------------*/
int KpstreeWidget::initGUI(void) 
{

  windowList.append(this);
  KWM::setIcon(winId(), kapp->getIcon());
  KWM::setMiniIcon(winId(), kapp->getMiniIcon());

  QPopupMenu *file = new QPopupMenu;
  CHECK_PTR(file);
  file->insertItem( klocale->translate("New Window..."), ID_FILE_NEWWIN);
  file->insertSeparator();
  file->insertItem(  klocale->translate("Quit"), ID_FILE_QUIT);

  sort = new QPopupMenu;
  CHECK_PTR(sort);
  sort->setCheckable(TRUE);
  sort->insertItem( klocale->translate("by Name"),ID_SORT_NAME);
  sort->insertItem( klocale->translate("by pID"),ID_SORT_PID);
  sort->setItemChecked(ID_SORT_NAME,TRUE);

  refresh = new QPopupMenu;
  CHECK_PTR(refresh);
  refresh->setCheckable(TRUE);
  for ( int i=0 ; refreshrates[i] ; i++ ) {
    refresh->insertItem( klocale->translate(refreshrates[i]),ID_REFRESH+i);
  }
  refresh->setItemChecked(ID_REFRESH,TRUE);

  QPopupMenu *options = new QPopupMenu;
  CHECK_PTR(options);
  options->insertItem("Sort",sort);
  options->insertSeparator();
  options->insertItem("Refresh",refresh);


  QPopupMenu *view = new QPopupMenu;
  CHECK_PTR(view); 
  view->insertItem( klocale->translate("Toggle Toolbar"), ID_VIEW_TOOLBAR);
  view->insertItem( "Toggle Statusbar", ID_VIEW_STATUSBAR);
  
  QPopupMenu *help = new QPopupMenu;
  CHECK_PTR(help);
  help->insertItem( klocale->translate("Help"), ID_HELP_HELP);
  help->insertSeparator();
  help->insertItem( klocale->translate("About..."), ID_HELP_ABOUT);
  
  connect (file   , SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (help   , SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (view   , SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (sort   , SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (refresh, SIGNAL (activated (int)), SLOT (refreshCallback (int)));

  menu = new KMenuBar( this );
  CHECK_PTR( menu );
  menu->insertItem( klocale->translate("&File"), file );
  menu->insertItem( klocale->translate("&Options"),options);
  menu->insertItem( klocale->translate("&Refresh"),refresh);
  menu->insertItem( klocale->translate("&View"), view );
  menu->insertSeparator();
  menu->insertItem( klocale->translate("&Help"), help );
  menu->show();
  setMenu( menu );

  KIconLoader *loader = kapp->getIconLoader();
  toolbar = new KToolBar(this);
  CHECK_PTR(toolbar);
  toolbar->insertButton(loader->loadIcon("filenew.xpm"),
			ID_FILE_NEWWIN, TRUE, klocale->translate("New Window"));  
  toolbar->insertButton(loader->loadIcon("reload.xpm"),
			ID_RELOAD, TRUE, klocale->translate("Refresh"));
  toolbar->insertButton(loader->loadIcon("start.xpm"),
			ID_ROOT,TRUE,klocale->translate("Root"));
  toolbar->insertButton(loader->loadIcon("editcut.xpm"),
			ID_CUT,TRUE,klocale->translate("Remove"));

  addToolBar(toolbar);
  toolbar->setBarPos(KToolBar::Top);
  toolbar->show();
  connect(toolbar, SIGNAL(clicked(int)), this, SLOT(menuCallback(int)));

  statusBar = new KStatusBar( this );
  statusBar->insertItem( (char*)klocale->translate("Welcome to kpstree..."), 1 );
  statusBar->show();
  setStatusBar( statusBar );
  
  panner = new KPanner(this,"panner",KPanner::O_VERTICAL,55);
  CHECK_PTR(panner);
  setView(panner);
  panner->show();

  
  plist = new ProcTree(panner->child0(),"plist");
  CHECK_PTR(plist);
  plist->setAutoUpdate(FALSE);
  connect(plist,SIGNAL(highlighted(int)),SLOT(procHighlighted(int)));
  plist->hide();
  

  QGridLayout *glayout = new QGridLayout(panner->child0(),1,1);
  CHECK_PTR(glayout);
  glayout->addWidget(plist,0,0);
  
  kfm = 0L;

  setMinimumSize(200,200);  
  resize(640,500);
  show();

  return 0;
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::KpstreeWidget (constructor)
 -----------------------------------------------------------------------------*/
KpstreeWidget::KpstreeWidget() 
{
  initGUI();
  nameSort=TRUE;
  refreshProcList();
  plist->setExpandLevel(20); 
  plist->show();
  setCaption(kapp->getCaption());
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::~KpstreeWidget (destructor)
 -----------------------------------------------------------------------------*/
KpstreeWidget::~KpstreeWidget() 
{
  killTimers();
  delete refresh;
  delete sort;
  delete toolbar;
  delete statusBar;
  delete kfm;
  delete menu;
  delete plist;
  delete panner;
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::menuCallback
 -----------------------------------------------------------------------------*/
void KpstreeWidget::menuCallback(int item) 
{
  int currentIndx;

  switch (item) {

  case ID_FILE_NEWWIN:
    new KpstreeWidget();
    break;

  case ID_FILE_QUIT: 
    kapp->quit();
    break;

  case ID_SORT_NAME: 
    if ( ! nameSort ) {
      nameSort = TRUE;
      sort->setItemChecked(ID_SORT_NAME,TRUE);
      sort->setItemChecked(ID_SORT_PID,FALSE);
      sortUpdateProcList();
    }
    break;

  case ID_SORT_PID: 
    if ( nameSort ) {
      nameSort = FALSE;
      sort->setItemChecked(ID_SORT_NAME,FALSE);
      sort->setItemChecked(ID_SORT_PID,TRUE);
      sortUpdateProcList();
    }
    break;

  case ID_VIEW_TOOLBAR: 
    enableToolBar();
    break;
    
  case ID_VIEW_STATUSBAR:
    enableStatusBar();
    break;

  case ID_RELOAD:
    refreshProcList();
    break;

  case ID_CUT:
    currentIndx = plist->currentItem();
    if ( currentIndx == -1 ) break;
    plist->removeItem(currentIndx); 
    break;

  case ID_ROOT:
    changeProcListRoot();
    break;

  case ID_HELP_HELP:
    kapp->invokeHTMLHelp( "kpstree/kpstree.html", "" );
    break;

  case ID_HELP_ABOUT:
    QString str;
    str.sprintf( klocale->translate("kpstree 0.1\nby Nicolas Leclercq (nicknet@planete.net)
\nPart of the code is\nCopyright 1993-1998 Werner Almesberger.\n(pstree author)") );
    KMsgBox::message( 0, klocale->translate("About Kpstree"), 
		       (const char *)str,
		       KMsgBox::INFORMATION, klocale->translate("Close") );
    break;
  }

}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::refreshCallback
 -----------------------------------------------------------------------------*/
void KpstreeWidget::refreshCallback(int item) 
{ 
  int indx = item-ID_REFRESH;
  
  for ( int i=0 ; refreshrates[i] ; i++ ) 
    refresh->setItemChecked(ID_REFRESH+i,FALSE);

  refresh->setItemChecked(item,TRUE);
  killTimers();
  if ( indx )
    startTimer( timer[item-ID_REFRESH] );
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::procHighlighted
 -----------------------------------------------------------------------------*/
void KpstreeWidget::procHighlighted(int indx)
{ 
  //fprintf(stdout,"item %d selected.\n",indx);
  if ( ! indx ) return;
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::closeEvent
 -----------------------------------------------------------------------------*/
void KpstreeWidget::closeEvent ( QCloseEvent *e ) 
{
  windowList.remove(this);
  if (windowList.isEmpty())
    kapp->quit();
  e->accept();
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::timerEvent
 -----------------------------------------------------------------------------*/
void KpstreeWidget::timerEvent( QTimerEvent *e )
{ 
  //just to remove a stupid warning : unused parameter 
  int timerID; 
  timerID = e->timerId(); 

  refreshProcList();
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::refreshProcList
 -----------------------------------------------------------------------------*/
void KpstreeWidget::refreshProcList( void )
{
  plist->setUpdatesEnabled(FALSE);  
    plist->setExpandLevel(0); 
    plist->clear();
    readProcDir();
    sortProcList();
    plist->setCurrentItem(0);
    plist->setExpandLevel(50); 
  plist->setUpdatesEnabled(TRUE);
  plist->repaint(TRUE); 
     
  char str[256];
  sprintf(str,"Current number of proc : %d", plist->count());
  statusBar->changeItem((char*)klocale->translate(str), 1 ); 
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::refreshProcList
 -----------------------------------------------------------------------------*/
void KpstreeWidget::sortProcList( void )
{
 ProcTreeItem *mainItem = plist->itemAt(0); 
 if ( nameSort ) 
   mainItem->setChild(sortProcListByName(mainItem->getChild())); 
 else 
   mainItem->setChild(sortProcListByPid(mainItem->getChild()));
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::sortUpdateProcList
 -----------------------------------------------------------------------------*/
void KpstreeWidget::sortUpdateProcList( void )
{    
  plist->setUpdatesEnabled(FALSE);  
    sortProcList();
    plist->setCurrentItem(0); 
  plist->setUpdatesEnabled(TRUE);
  plist->repaint(TRUE); 
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::getParentItem
 -----------------------------------------------------------------------------*/
ProcTreeItem* KpstreeWidget::getParentItem(ProcTreeItem* item, int ppid )
{
 ProcTreeItem* anItem;

 if ( ! item ) return NULL ; 
 if ( item->getProcId() == ppid ) 
      return item;
 if ( (anItem = getParentItem(item->getSibling(),ppid)) )
    return anItem;
 return getParentItem(item->getChild(),ppid);
 
}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::sortProcListByName
 -----------------------------------------------------------------------------*/
ProcTreeItem* KpstreeWidget::sortProcListByName ( ProcTreeItem* ref ) 
{
 ProcTreeItem *newTop,*cur,*aTempItem,*prev=NULL;

 if ( ! ref ) return ref;

 if ( ref->hasChild() )
   ref->setChild( sortProcListByName(ref->getChild()) );

 if ( ! ref->hasSibling() ) 
   return ref;

 newTop = sortProcListByName(ref->getSibling());
 ref->setSibling(newTop);  
 if ( ! newTop ) return newTop;  
 
 cur = newTop;

 int counter = 0; 

 while ( cur )   
   { 
     aTempItem = cur->getSibling();
     if ( strcmp(ref->getProcName(),cur->getProcName()) > 0 ) {
	 cur->setSibling(ref); 
	 ref->setSibling(aTempItem);
	 if ( prev ) prev->setSibling(cur);
	 prev = cur;
	 counter++;   
     } 
     cur = aTempItem;
   }
 if ( counter ) return newTop; else return ref; 

}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::sortProcListByPid
 -----------------------------------------------------------------------------*/
ProcTreeItem* KpstreeWidget::sortProcListByPid ( ProcTreeItem* ref ) 
{
 ProcTreeItem *newTop,*cur,*aTempItem,*prev=NULL;

 if ( ! ref ) return ref;
  
 if ( ref->hasChild() )
   ref->setChild( sortProcListByPid(ref->getChild()) );

 if ( ! ref->hasSibling() ) 
   return ref;
 
 newTop = sortProcListByPid(ref->getSibling());
 ref->setSibling(newTop);  
 if ( ! newTop ) return newTop;  
 
 cur = newTop;

 int   counter = 0; 

 while ( cur )   
   { 
     aTempItem = cur->getSibling();
     if ( ref->getProcId() > cur->getProcId() ) {
	 cur->setSibling(ref); 
	 ref->setSibling(aTempItem);
	 if ( prev ) prev->setSibling(cur);
	 prev = cur;
	 counter++;   
     } 
     cur = aTempItem;
   }
 if ( counter ) return newTop; else return ref; 

}

/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::reorderProcList
 -----------------------------------------------------------------------------*/
void KpstreeWidget::reorderProcList( ProcTree* plist, ProcTree* alist)
{
  ProcTreeItem   *anItem = alist->itemAt(0);

  if (!anItem) return;
 
  while ( anItem ) 
    { 
      ProcTreeItem *parent = getParentItem(plist->itemAt(0),anItem->getParentId()); 
      if ( parent ) 
	{ 
          ProcTreeItem *child = new ProcTreeItem(anItem->getProcInfo());
	  parent->appendChild(child);
	}
      anItem = anItem->getSibling();
    }
}
/*-----------------------------------------------------------------------------
  Routine : KpstreeWidget::changeProcListRoot
 -----------------------------------------------------------------------------*/
void KpstreeWidget::changeProcListRoot()
{  
  int newRootIndx = plist->currentItem();
  if ( newRootIndx == -1 ) return;
  
  ProcTreeItem *newRoot = plist->takeItem(newRootIndx);
  if ( ! newRoot ) return;

  plist->setUpdatesEnabled(FALSE);  
    plist->clear();
    plist->insertItem(newRoot);
    plist->setCurrentItem(0);
  plist->setUpdatesEnabled(TRUE);
  plist->repaint(TRUE); 
     
  char str[256];
  sprintf(str,"Current number of proc in list : %d", plist->count());
  statusBar->changeItem((char*)klocale->translate(str), 1 ); 
  
}

/*-----------------------------------------------------------------------------
  Routine : readProcDir
  Most of this code (this routine) is :
  Copyright 1993-1998 Werner Almesberger (pstree author). All rights reserved.
 -----------------------------------------------------------------------------*/
void KpstreeWidget::readProcDir(  )
{
    DIR           *dir;
    struct dirent *de;
    FILE          *file;
    struct stat    st;
    char           path[PATH_MAX+1];
    int            empty,dummy;
    ProcInfo       pi;
    //int            fd,size=0;

    ProcTree      *alist = new ProcTree();  
    CHECK_PTR(alist);

    if (!(dir = opendir(PROC_BASE))) 
      {
	perror(PROC_BASE);
	exit(1);
      }

    empty = 0;
    while ((de = readdir(dir)))
	if ((pi.pid = atoi(de->d_name))) {
	    sprintf(path,"%s/%d/stat",PROC_BASE,pi.pid);
	    if ((file = fopen(path,"r"))) {
		empty = 0;
		if (fstat(fileno(file),&st) < 0) {
		    perror(path);
		    exit(1);
		}
                pi.uid = st.st_uid;
		if (fscanf(file,"%d (%[^)]) %c %d"
			       ,&dummy
			       ,pi.name
			       ,(char*)&dummy
			       ,&(pi.ppid)) == 4) 
		  {
                    ProcTreeItem *child = new ProcTreeItem(pi,NULL);
                    CHECK_PTR(child);
		    
                    /*
                    sprintf(path,"%s/%d/cmdline",PROC_BASE,pi.pid); 
		    if ((fd = open(path,O_RDONLY,S_IRUSR)) >  0) { 
		      if ((size = read(fd,pi.arg,(size_t)OUTPUT_WIDTH)) < 0) 
			{ 
		          perror(path);  
			  exit(1);  
			} 
		        (void) close(fd); 
			if (size) pi.arg[size++] = 0; 
			fprintf(stdout,pi.arg);
		    } 
                    else 
                    */

		    strcpy(pi.arg,"Not implemented");
  
		    if ( pi.pid == INIT_PID )
		         plist->insertItem(child);
		    else if ( pi.ppid == INIT_PID ) 
			 plist->addChildItem(child,0); 
		    else { 
		      ProcTreeItem *item=getParentItem(plist->itemAt(0),pi.ppid);   
		      if ( item )  
			  item->appendChild(child); 
		      else  
			  alist->insertItem(child);   
		    }	
	          }
		(void)fclose(file);
	    }
	}
    (void)closedir(dir);

    if ( empty ) {
	fprintf(stderr,PROC_BASE " is empty (not mounted ???)\n");
	exit(1);
    }

    reorderProcList(plist,alist);
    
    delete alist;
}

/*-----------------------------------------------------------------------------
  Routine : main
 -----------------------------------------------------------------------------*/
int main(int argc, char **argv) {

  KApplication a(argc,argv,"kpstree");  
  
  KpstreeWidget *mw = new KpstreeWidget();
  CHECK_PTR(mw);

  a.setMainWidget(mw);

  return a.exec();
}

#include "kpstree.moc"



