/***************************************************************************
                          KoverTop.cpp  -  TopLevelWidget
                             -------------------

    version              : 
    begin                : Mon Dez 14 19:01:57 CET 1998
                                           
    copyright            : (C) 1998 by Denis Oliver Kropp
    email                : dok@fischlustig.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// alter mach kaffe
#include "KoverTop.h"
#include "cddb_fill.h"
#include "imagedlg.h"
#include "../config.h"

#include <kiconloader.h>
#include <kmsgbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <kapp.h>
#include <kfontdialog.h>
#include <kcolordlg.h>
#include <ktopwidget.h>
#include <qmultilinedit.h>
#include <kfiledialog.h>
#include <qregexp.h>

#define NORM_WIDTH	520
#define NORM_HEIGHT	366
#define PREV_WIDTH	695
#define PREV_HEIGHT	686

#define CDVIEW_X	224
#define CDVIEW_Y	 55
#define CDVIEW_WIDTH	291
#define CDVIEW_HEIGHT	290

#define DATAICON(x) QPixmap( KApplication::kde_datadir() + "/kover/toolbar/" + x )

KoverTop::KoverTop( const char* name=NULL ) : KTopLevelWidget(name)
{
	setCaption( "Kover - untitled" );
	setFixedSize( NORM_WIDTH, NORM_HEIGHT );
	filename = "untitled";
  
	main_toolbar = new KToolBar( this, "main_toolbar" );
	main_toolbar->setBarPos(KToolBar::Top);
	main_toolbar->insertButton( Icon("filenew.xpm"), ID_MAIN_NEW, true, "Clear all" );
	main_toolbar->insertButton( Icon("fileopen.xpm"), ID_MAIN_OPEN, true, "Open" );
	main_toolbar->insertButton( Icon("filefloppy.xpm"), ID_MAIN_SAVE, true, "Save" );
	main_toolbar->insertButton( Icon("filesaveas.xpm"), ID_MAIN_SAVEAS, true, "Save As" );
	main_toolbar->insertSeparator();
	main_toolbar->insertButton( Icon("fileprint.xpm"), ID_MAIN_PRINT, true, "Print" );
	main_toolbar->insertButton( Icon("mini/mini-camera.xpm"), ID_MAIN_VIEW, true, "Full View" );
	main_toolbar->insertSeparator();
	main_toolbar->insertButton( Icon("mini/sample.xpm"), ID_MAIN_ABOUT, true, "About" );
	main_toolbar->insertButton( Icon("exit.xpm"), ID_MAIN_EXIT, true, "Exit" );
	main_toolbar->alignItemRight( ID_MAIN_ABOUT );

	addToolBar( main_toolbar );
	connect( main_toolbar, SIGNAL(clicked(int)), SLOT(handleMainToolBar(int)) );


	cd_toolbar = new KToolBar( this, "cd_toolbar" );
	cd_toolbar->setBarPos(KToolBar::Top);
	cd_toolbar->insertButton( DATAICON("bgcolor.xpm"), ID_CD_BGCOLOR, true, "Background Color" );
	cd_toolbar->insertSeparator();
	cd_toolbar->insertButton( DATAICON("titlefont.xpm"), ID_CD_TITLEFONT, true, "Title Font" );
	cd_toolbar->insertButton( DATAICON("textcolor.xpm"), ID_CD_TITLECOLOR, true, "Title Textcolor" );
	cd_toolbar->insertSeparator();
	cd_toolbar->insertButton( DATAICON("contentsfont.xpm"), ID_CD_CONTENTSFONT, true, "Contents Font" );
	cd_toolbar->insertButton( DATAICON("textcolor.xpm"), ID_CD_CONTENTSCOLOR, true, "Contents Textcolor" );
	cd_toolbar->insertSeparator();
	cd_toolbar->insertButton( DATAICON("images.xpm"), ID_CD_IMAGES, true, "Image Embedding" );
	cd_toolbar->insertSeparator();
	cd_toolbar->insertButton( DATAICON("cddb.xpm"), ID_CD_CDDBFILL, true, "CDDB Fill" );

	addToolBar( cd_toolbar );
	connect( cd_toolbar, SIGNAL(clicked(int)), SLOT(handleCdToolBar(int)) );
  
  
	status_bar = new KStatusBar( this, "status_bar" );
	status_bar->insertItem( "Kover "VERSION" - http://www.fischlustig.de/kover - dok@fischlustig.de (Denis Oliver Kropp)", 1 );
	status_bar->setBorderWidth( 2 );
	setStatusBar( status_bar );
  
	title_label = new QLabel( "Title", this, "title_label" );
	title_label->move( 5, 60 );

	title_edit = new QMultiLineEdit( this, "title_edit" );
	title_edit->resize( 215, 50 );
	title_edit->move( 5, 90 );
	connect( title_edit, SIGNAL(textChanged()), SLOT(titleBoxChanged()) );
  
	contents_label = new QLabel( "Contents", this, "contents_label" );
	contents_label->move( 5, 145 );

	contents_edit = new QMultiLineEdit( this, "contents_edit" );
	contents_edit->resize( 215, 175 );
	contents_edit->move( 5, 170 );
	connect( contents_edit, SIGNAL(textChanged()), SLOT(contentsBoxChanged()) );
  
  
	number_spin = new QSpinBox( 1, 999, 1, this, "numberspin" );
	number_spin->setEnabled(false);
	number_spin->resize( 50, 25 );
	number_spin->move( 170, 55 );
	connect( number_spin, SIGNAL(valueChanged(int)), SLOT(numberChanged(int)) );

	number_check = new QCheckBox( "CD Number", this, "number_check" );
	number_check->resize( 85, 25 );
	number_check->move( 70, 55 );
	connect( number_check, SIGNAL(toggled(bool)), SLOT(numberChecked(bool)) );

    
	cdview = new CDView( &kover_file, this );
	cdview->resize( CDVIEW_WIDTH, CDVIEW_HEIGHT );
	cdview->move( CDVIEW_X, CDVIEW_Y );
	connect( cdview, SIGNAL(stopPreview()), SLOT(stopPreview()) );

	connect( &kover_file, SIGNAL(dataChanged(bool)), SLOT(dataChanged(bool)) );

	cddb_fill = new CDDB_Fill( &kover_file );
	connect( cddb_fill, SIGNAL(statusText(const char*)), SLOT(setStatusText(const char*)) );

	altered_data = false;
}

KoverTop::~KoverTop()
{
	delete cddb_fill;
	delete cdview;
}

void KoverTop::dataChanged(bool image)
{
	setStatusText( "Data changed" );
	altered_data = true;
}

void KoverTop::setStatusText( const char* _status_text )
{
	status_bar->changeItem( _status_text, 1 );
	kapp->processEvents();
}

void KoverTop::titleBoxChanged()
{
	kover_file.setTitle( title_edit->text() );
}

void KoverTop::contentsBoxChanged()
{
	kover_file.setContents( contents_edit->text() );
}

void KoverTop::numberChanged(int value)
{
	kover_file.setNumber( value );
}

void KoverTop::numberChecked(bool checked)
{
	number_spin->setEnabled(checked);
  
	if (checked)
	{
		kover_file.setNumber( number_spin->value() );
	} else
	{
		kover_file.setNumber( 0 );
	}
}

char KoverTop::hexToChar( char hexc )
{
	switch (hexc)
	{
	case 48:
		return 0;
	case 49:
		return 1;
	case 50:
		return 2;
	case 51:
		return 3;
	case 52:
		return 4;
	case 53:
		return 5;
	case 54:
		return 6;
	case 55:
		return 7;
	case 56:
		return 8;
	case 57:
		return 9;
	case 97:
	case 65:
		return 10;
	case 98:
	case 66:
		return 11;
	case 99:
	case 67:
		return 12;
	case 100:
	case 68:
		return 13;
	case 101:
	case 69:
		return 14;
	case 102:
	case 70:
		return 15;
	}

	return 0;
}

void KoverTop::parseFilename( QString& filename )
{
	unsigned int	i;
	char		c;
	QString		tmp = "";
	
	for (i=0; i<filename.length(); i++)
	{
		c = filename.at(i);
		if (c == 37)
		{
			c = hexToChar(filename.at(i+1)) * 16 + hexToChar(filename.at(i+2));
			i += 2;
		}
		tmp += c;
	}
	
	filename = tmp;
}

void KoverTop::handleMainToolBar(int id)
{
	QString newfilename;

	switch (id)
	{
		case ID_MAIN_NEW:
			if (altered_data)
			{
				switch (KMsgBox::yesNoCancel( this, "Kover", "Data changed since last saving!\nDo you want to save the changes?", KMsgBox::QUESTION ))
				{
					case 1:
						handleMainToolBar( ID_MAIN_SAVE );
						if (altered_data)
						{
							return;
						}
					break;
					case 2:
					break;
					case 3:
					return;
				}
			}
			title_edit->clear();
			contents_edit->clear();
			number_spin->setValue( 1 );
			number_spin->setEnabled( false );
			number_check->setChecked( false );
			title_edit->setFocus();
			kover_file.reset();
			setStatusText( "Chop!" );
			altered_data = false;
			filename = "untitled";
			setCaption( "Kover - untitled" );
		break;
		case ID_MAIN_OPEN:
			if (altered_data)
			{
				switch (KMsgBox::yesNoCancel( this, "Kover", "Data changed since last saving!\nDo you want to save the changes?", KMsgBox::QUESTION ))
				{
					case 1:
						handleMainToolBar( ID_MAIN_SAVE );
						if (altered_data)
						{
							return;
						}
					break;
					case 2:
					break;
					case 3:
					return;
				}
			}
			newfilename = KFileDialog::getOpenFileName( 0, 0, this );
			if (newfilename.length())
			{
				parseFilename( newfilename );
				if (kover_file.openFile( newfilename ))
				{
					filename = newfilename;
              
					QString newCaption;
					newCaption.append( "Kover - " );
					newCaption.append( filename );
					setCaption( newCaption );
              
					disconnect( contents_edit, SIGNAL(textChanged()), this, SLOT(contentsBoxChanged()) );
					title_edit->setText( kover_file.title() );
					contents_edit->setText( kover_file.contents() );
					connect( contents_edit, SIGNAL(textChanged()), SLOT(contentsBoxChanged()) );

					if (kover_file.number())
					{
						number_spin->setValue( kover_file.number() );
						number_spin->setEnabled( true );
						number_check->setChecked( true );
					} else
					{
						number_spin->setEnabled( false );
						number_check->setChecked( false );
					}
              
					setStatusText( "File loaded" );
					altered_data = false;
				} else
				{
					KMsgBox::message( this, "Kover Alert", "Error while opening/reading file!", KMsgBox::EXCLAMATION );
				}
			}
		break;
		case ID_MAIN_SAVE:
			if (filename == "untitled")
			{
				handleMainToolBar( ID_MAIN_SAVEAS );
			} else
			{
				if (kover_file.saveFile( filename ))
				{
					setStatusText( "File saved" );
					altered_data = false;
				} else
				{
					KMsgBox::message( this, "Kover Alert", "Error while opening/writing to file!", KMsgBox::EXCLAMATION );
				}
			}
		break;
		case ID_MAIN_SAVEAS:
			newfilename = KFileDialog::getSaveFileName( 0, 0, this );
			if (newfilename.length())
			{
				parseFilename( newfilename );
				if (kover_file.saveFile( newfilename ))
				{
					filename = newfilename;

					QString newCaption;
					newCaption.append( "Kover - " );
					newCaption.append( filename );
					setCaption( newCaption );
					setStatusText( "File saved" );
					altered_data = false;
				} else
				{
					KMsgBox::message( this, "Kover Alert", "Error while opening/writing to file!", KMsgBox::EXCLAMATION );
				}
			}
		break;
		case ID_MAIN_PRINT:
			cdview->printKover();
		break;
		case ID_MAIN_VIEW:
			cdview->resize( PREV_WIDTH, PREV_HEIGHT );
			cdview->move( 0, 0 );
			setFixedSize( PREV_WIDTH, PREV_HEIGHT );
			resize( PREV_WIDTH, PREV_HEIGHT );
			cdview->showPreview();
			cdview->setFocus();
		break;
		case ID_MAIN_ABOUT:
			KMsgBox::message( this, "Kover", "Kover "VERSION"\n(C) 1998 Denis Oliver Kropp, a one-man division of Fischlustig\n\ndok@fischlustig.de\nCheck www.fischlustig.de/kover\n" );
		break;
		case ID_MAIN_EXIT:
			close();
		break;
	}
}

void KoverTop::handleCdToolBar(int id)
{
	QColor        new_color;
	QFont         new_font;
	KColorDialog* kc;
	KFontDialog*  kf;
	QString       tracks;
  
	switch (id)
	{
		case ID_CD_BGCOLOR:
			kc = new KColorDialog(this, "kc", true);
			new_color = kover_file.backColor();
			if (kc->getColor( new_color ))
			{
				kover_file.setBackColor( new_color );
			}
			delete kc;
		break;
		case ID_CD_TITLEFONT:
			kf = new KFontDialog(this, "kf", true);
			new_font = kover_file.titleFont();
			if (kf->getFont( new_font ))
			{
				kover_file.setTitleFont( new_font );
			}
			delete kf;
		break;
		case ID_CD_TITLECOLOR:
			kc = new KColorDialog(this, "kc", true);
			new_color = kover_file.titleColor();
			if (kc->getColor( new_color ))
			{
				kover_file.setTitleColor( new_color );
			}
			delete kc;
		break;
		case ID_CD_CONTENTSFONT:
			kf = new KFontDialog(this, "kf", true);
			new_font = kover_file.contentsFont();
			if (kf->getFont( new_font ))
			{
				kover_file.setContentsFont( new_font );
			}
			delete kf;
		break;
		case ID_CD_CONTENTSCOLOR:
			kc = new KColorDialog(this, "kc", true);
			new_color = kover_file.contentsColor();
			if (kc->getColor( new_color ))
			{
				kover_file.setContentsColor( new_color );
			}
			delete kc;
		break;
		case ID_CD_IMAGES:
			ImageDlg* imgdlg;
			imgdlg = new ImageDlg(this,&kover_file);
			imgdlg->exec();
			delete imgdlg;
		break;
		case ID_CD_CDDBFILL:
			if (altered_data)
			{
				switch (KMsgBox::yesNoCancel( this, "Kover", "Data changed since last saving!\nDo you want to save the changes?", KMsgBox::QUESTION ))
				{
					case 1:
						handleMainToolBar( ID_MAIN_SAVE );
						if (altered_data)
						{
							return;
						}
					break;
					case 2:
					break;
					case 3:
					return;
				}
			}
			if (cddb_fill->execute())
			{
				disconnect( contents_edit, SIGNAL(textChanged()), this, SLOT(contentsBoxChanged()) );
				title_edit->setText( kover_file.title() );
				contents_edit->setText( kover_file.contents() );
				connect( contents_edit, SIGNAL(textChanged()), SLOT(contentsBoxChanged()) );
				altered_data = false;
				cddb_fill->cdInfo();
			}
		break;
	}
}

void KoverTop::stopPreview()
{
	cdview->resize( CDVIEW_WIDTH, CDVIEW_HEIGHT );
	cdview->move( CDVIEW_X, CDVIEW_Y );
	setFixedSize( NORM_WIDTH, NORM_HEIGHT );
	resize( NORM_WIDTH, NORM_HEIGHT );
	cdview->showPreview( false );
} 

void KoverTop::closeEvent( QCloseEvent* e )
{
	if (altered_data)
	{
		switch (KMsgBox::yesNoCancel( this, "Kover", "Data changed since last saving!\nDo you want to save the changes?", KMsgBox::QUESTION ))
		{
			case 1:
				handleMainToolBar( ID_MAIN_SAVE );
				if (altered_data)
				{
					e->ignore();
				} else
				{
					e->accept();
				}
			break;
			case 2:
				e->accept();
			break;
			case 3:
				e->ignore();
			return;
		}
	} else
	{
		e->accept();
	}
}


